/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementNames;
import org.openconcerto.utils.i18n.Phrase;

public abstract class SQLElementNamesMap<K>
extends SQLElementNames {
    private final Map<K, Phrase> names = new HashMap<K, Phrase>();

    public SQLElementNamesMap(Locale locale) {
        super(locale);
    }

    @Override
    protected final Phrase _getName(SQLElement elem) {
        return this.handleGetName(this.getKey(elem));
    }

    public final synchronized Phrase handleGetName(K key) {
        return this.names.get(key);
    }

    protected abstract K getKey(SQLElement var1);

    protected final synchronized void put(K key, Phrase value) {
        this.names.put(key, value);
    }

    public static class ByClass
    extends SQLElementNamesMap<Class<? extends SQLElement>> {
        public ByClass(Locale locale) {
            super(locale);
        }

        @Override
        protected Class<? extends SQLElement> getKey(SQLElement elem) {
            return elem.getClass();
        }
    }

    public static class ByCode
    extends SQLElementNamesMap<String> {
        public ByCode(Locale locale) {
            super(locale);
        }

        @Override
        protected String getKey(SQLElement elem) {
            return elem.getCode();
        }
    }
}

