/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementLink;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.utils.CollectionMap2;
import org.openconcerto.utils.CollectionMap2Itf;
import org.openconcerto.utils.SetMap;

public final class SQLElementLinks {
    private static final SQLElementLinks EMPTY = new SQLElementLinks(SetMap.empty());
    private final CollectionMap2Itf.SetMapItf<SQLElementLink.LinkType, SQLElementLink> byType;
    private final Map<Path, SQLElementLink> byPath;

    public static final SQLElementLinks empty() {
        return EMPTY;
    }

    protected SQLElementLinks(CollectionMap2Itf.SetMapItf<SQLElementLink.LinkType, SQLElementLink> byType) {
        SetMap copy = new SetMap(CollectionMap2.Mode.NULL_FORBIDDEN);
        copy.putAllCollections(byType, true);
        this.byType = SetMap.unmodifiableMap(copy);
        HashMap<Path, SQLElementLink> tmp = new HashMap<Path, SQLElementLink>();
        for (SQLElementLink l : byType.allValues()) {
            tmp.put(l.getPath(), l);
        }
        this.byPath = Collections.unmodifiableMap(tmp);
    }

    public final Map<Path, SQLElementLink> getByPath() {
        return this.byPath;
    }

    public final SQLElementLink getByPath(Path p) {
        return this.getByPath(p, null);
    }

    public final SQLElementLink getByPath(Path p, SQLElementLink.LinkType type) {
        SQLElementLink res = this.byPath.get(p);
        if (type == null || res != null && res.getLinkType().equals((Object)type)) {
            return res;
        }
        return null;
    }

    public final CollectionMap2Itf.SetMapItf<SQLElementLink.LinkType, SQLElementLink> getByType() {
        return this.byType;
    }

    public final Set<SQLElementLink> getByType(SQLElementLink.LinkType type) {
        return (Set)this.byType.getNonNull(type);
    }

    public final SQLElementLink getOneByOwned(SQLElement owned) {
        return this.getOneByOwned(owned, null);
    }

    public final SQLElementLink getOneByOwned(SQLElement owned, SQLElementLink.LinkType type) {
        Set<SQLElementLink> res = this.getByOwned(owned, type);
        if (res.size() == 0) {
            return null;
        }
        if (res.size() == 1) {
            return res.iterator().next();
        }
        throw new IllegalStateException("More than one link to " + owned + " : " + res);
    }

    public final Set<SQLElementLink> getByOwned(SQLElement owned, SQLElementLink.LinkType type) {
        HashSet<SQLElementLink> res = new HashSet<SQLElementLink>();
        Collection<SQLElementLink> links = type == null ? this.byPath.values() : this.getByType(type);
        for (SQLElementLink l : links) {
            if (owned != null && l.getOwned() != owned) continue;
            res.add(l);
        }
        return res;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.byPath.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLElementLinks other = (SQLElementLinks)obj;
        return this.byPath.values().equals(other.byPath.values());
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.byPath.values();
    }
}

