/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.convert;

import java.sql.SQLException;
import java.util.EnumSet;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.AlterTable;

public class OrderToDecimal
extends Changer<SQLTable> {
    public OrderToDecimal(DBSystemRoot b) {
        super(b);
    }

    @Override
    protected void changeImpl(SQLTable t) throws SQLException {
        this.getStream().print(String.valueOf(t.getName()) + "... ");
        if (!t.isOrdered()) {
            this.getStream().println("not ordered");
        } else if (this.getSyntax().isOrder(t.getOrderField(), false)) {
            this.getStream().println("already");
        } else {
            AlterTable alterTable = new AlterTable(t);
            alterTable.alterColumn(t.getOrderField().getName(), EnumSet.allOf(SQLField.Properties.class), this.getSyntax().getOrderType(), this.getSyntax().getOrderDefault(), this.getSyntax().isOrderNullable());
            this.getDS().execute(alterTable.asString());
            t.getSchema().updateVersion();
            this.getStream().println("done");
        }
    }
}

