/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.convert;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.utils.ReOrder;
import org.openconcerto.sql.utils.SQLUtils;

public class ChangeIDs
extends Changer<SQLTable> {
    public static final String OFFSET = "ids.offset";
    public static final String CHANGE_ORDER = "order.change";
    private Long offset = null;
    private boolean changeOrder = false;

    public ChangeIDs(DBSystemRoot b) {
        super(b);
    }

    public final void setOffset(Long offset) {
        this.offset = offset;
    }

    public final void setChangeOrder(boolean changeOrder) {
        this.changeOrder = changeOrder;
    }

    @Override
    public void setUpFromSystemProperties() {
        super.setUpFromSystemProperties();
        this.setOffset(Long.getLong(OFFSET));
        this.setChangeOrder(Boolean.getBoolean(CHANGE_ORDER));
    }

    @Override
    protected Class<? extends DBStructureItem<?>> getMaxLevel() {
        return SQLTable.class;
    }

    @Override
    protected void changeImpl(final SQLTable t) throws SQLException {
        this.getStream().print(t + "... ");
        if (this.offset == null) {
            throw new IllegalStateException("offset not given");
        }
        final long offset = this.offset;
        Object[] range = this.selMinMax(t.getKey());
        long beforeStart = ((Number)range[0]).longValue();
        long beforeEnd = ((Number)range[1]).longValue();
        final long afterStart = beforeStart + offset;
        long afterEnd = beforeEnd + offset;
        if ((long)t.getUndefinedID() >= afterStart && (long)t.getUndefinedID() <= afterEnd) {
            throw new IllegalStateException("Would overwrite undefined : " + afterStart + ", " + afterEnd);
        }
        if (beforeStart <= afterEnd && beforeEnd >= afterStart) {
            throw new IllegalStateException("Overlap with existing IDs : " + afterStart + ", " + afterEnd);
        }
        if (afterStart < 0L) {
            throw new IllegalStateException("Too low : " + afterStart);
        }
        SQLUtils.executeAtomic(this.getDS(), new SQLUtils.SQLFactory<Object>(){

            @Override
            public Object create() throws SQLException {
                ChangeIDs.this.getDS().execute(ChangeIDs.this.getSyntax().disableFKChecks(t.getDBRoot()));
                ChangeIDs.this.updateField(t.getKey(), t, offset);
                Set<Link> refLinks = t.getDBSystemRoot().getGraph().getReferentLinks(t);
                for (Link refLink : refLinks) {
                    ChangeIDs.this.updateField(refLink.getLabel(), t, offset);
                }
                ChangeIDs.this.getDS().execute(ChangeIDs.this.getSyntax().enableFKChecks(t.getDBRoot()));
                if (t.isOrdered() && ChangeIDs.this.changeOrder) {
                    ReOrder.create(t).exec();
                    if (!$assertionsDisabled && !ChangeIDs.this.selMinMaxAsLong(t.getOrderField()).equals(Arrays.asList(1L, (long)t.getRowCount() - 1L))) {
                        throw new AssertionError();
                    }
                    ChangeIDs.this.updateField(t.getOrderField(), t, afterStart - 1L);
                }
                return null;
            }
        });
        this.getStream().println("done");
    }

    private List<Long> selMinMaxAsLong(SQLField f) {
        Object[] minMax = this.selMinMax(f);
        ArrayList<Long> res = new ArrayList<Long>(2);
        res.add(((Number)minMax[0]).longValue());
        res.add(((Number)minMax[1]).longValue());
        return res;
    }

    private Object[] selMinMax(SQLField f) {
        SQLSelect sel = new SQLSelect(f.getTable().getBase(), true);
        sel.setExcludeUndefined(true);
        sel.addSelect(f, "min");
        sel.addSelect(f, "max");
        return this.getDS().executeA1(sel.asString());
    }

    private void updateField(SQLField f, SQLTable t, long offset) {
        if (offset == 0L) {
            return;
        }
        UpdateBuilder update = new UpdateBuilder(f.getTable()).set(f.getName(), String.valueOf(SQLBase.quoteIdentifier(f.getName())) + " + " + offset);
        update.setWhere(new Where((FieldRef)(f.isKey() ? f : t.getKey()), "!=", t.getUndefinedID()));
        this.getDS().execute(update.asString());
    }
}

