/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import org.openconcerto.erp.generationDoc.AbstractLocalTemplateProvider;
import org.openconcerto.erp.generationDoc.DefaultLocalTemplateProvider;
import org.openconcerto.erp.generationDoc.TemplateManager;
import org.openconcerto.erp.generationDoc.TemplateProvider;
import org.openconcerto.erp.preferences.TemplateNXProps;
import org.openconcerto.erp.preferences.TemplateTableModel;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.preferences.DefaultPreferencePanel;
import org.openconcerto.ui.table.TablePopupMouseListener;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.cc.ITransformer;

public class TemplatePreferencePanel
extends DefaultPreferencePanel {
    private JTextField textTemplate;
    private JFileChooser fileChooser = null;
    private JButton bModify;
    private JButton bUndo;
    private JButton bSync;

    public TemplatePreferencePanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints cPanel = new DefaultGridBagConstraints();
        cPanel.weighty = 0.0;
        cPanel.anchor = 17;
        this.add((Component)new JLabel("Mod\u00e8les des documents"), cPanel);
        ++cPanel.gridx;
        cPanel.weightx = 1.0;
        this.textTemplate = new JTextField();
        this.add((Component)this.textTemplate, cPanel);
        JButton buttonTemplate = new JButton("...");
        ++cPanel.gridx;
        cPanel.weightx = 0.0;
        cPanel.fill = 0;
        this.add((Component)buttonTemplate, cPanel);
        JPanel templates = this.createTemplateList();
        templates.setOpaque(false);
        ++cPanel.gridy;
        cPanel.fill = 1;
        cPanel.weightx = 1.0;
        cPanel.weighty = 1.0;
        cPanel.gridwidth = 3;
        cPanel.gridx = 0;
        this.add((Component)templates, cPanel);
        buttonTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TemplatePreferencePanel.this.directoryChoose("template");
            }
        });
        this.textTemplate.setEditable(false);
        this.setValues();
    }

    private JPanel createTemplateList() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 0;
        this.bModify = new JButton("Modifier");
        this.bModify.setEnabled(false);
        this.bModify.setOpaque(false);
        p.add((Component)this.bModify, c);
        this.bUndo = new JButton("R\u00e9tablir");
        this.bUndo.setEnabled(false);
        this.bUndo.setOpaque(false);
        ++c.gridx;
        p.add((Component)this.bUndo, c);
        this.bSync = new JButton("Synchroniser");
        this.bSync.setEnabled(false);
        this.bSync.setOpaque(false);
        if (!UserRightsManager.getCurrentUserRights().haveRight("SYNC_TEMPLATE")) {
            this.bSync.setToolTipText("Vous n'avez pas les droits suffisants pour synchroniser les mod\u00e8les!");
        }
        ++c.gridx;
        p.add((Component)this.bSync, c);
        final TemplateTableModel dm = new TemplateTableModel();
        final JTable table = new JTable(dm);
        TablePopupMouseListener.add(table, new ITransformer<MouseEvent, JPopupMenu>(){

            @Override
            public JPopupMenu transformChecked(MouseEvent input) {
                JPopupMenu res = new JPopupMenu();
                int selectedRow = table.getSelectedRow();
                if (selectedRow >= 0) {
                    JMenuItem menuItem = new JMenuItem(dm.getTemplateId(selectedRow));
                    res.add(menuItem);
                    menuItem.setEnabled(false);
                    res.addSeparator();
                    res.add(new AbstractAction("Modifier le mod\u00e8le"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TemplatePreferencePanel.this.modifyTemplate(dm, table);
                        }
                    });
                    res.add(new AbstractAction("Modifier la configuration du mod\u00e8le"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TemplatePreferencePanel.this.modifyTemplateXML(dm, table);
                        }
                    });
                    res.add(new AbstractAction("Modifier les param\u00e8tres d'impression"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            TemplatePreferencePanel.this.modifyTemplateODSP(dm, table);
                        }
                    });
                }
                return res;
            }
        });
        table.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component tableCellRendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                TemplateProvider provider = dm.getTemplateProvider(row);
                if (provider instanceof AbstractLocalTemplateProvider) {
                    String templateId = dm.getTemplateId(row);
                    File f = ((AbstractLocalTemplateProvider)provider).getFileTemplate(templateId, null, null);
                    if (f == null || !f.exists()) {
                        tableCellRendererComponent.setBackground(Color.ORANGE);
                        if (f != null) {
                            this.setToolTipText(String.valueOf(f.getAbsolutePath()) + " not found");
                        } else {
                            this.setToolTipText("no file for template " + templateId);
                        }
                    } else {
                        if (isSelected) {
                            tableCellRendererComponent.setBackground(table.getSelectionBackground());
                        } else {
                            tableCellRendererComponent.setBackground(table.getBackground());
                        }
                        this.setToolTipText(f.getAbsolutePath());
                    }
                }
                return tableCellRendererComponent;
            }
        });
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        p.add((Component)new JScrollPane(table), c);
        table.getSelectionModel().setSelectionMode(0);
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = table.getSelectedRow();
                if (row < 0) {
                    TemplatePreferencePanel.this.bModify.setEnabled(false);
                    TemplatePreferencePanel.this.bSync.setEnabled(false);
                    TemplatePreferencePanel.this.bUndo.setEnabled(false);
                    return;
                }
                boolean b = dm.isSynced(row);
                if (b) {
                    TemplatePreferencePanel.this.bModify.setEnabled(true);
                    TemplatePreferencePanel.this.bSync.setEnabled(false);
                    TemplatePreferencePanel.this.bUndo.setEnabled(false);
                } else {
                    TemplatePreferencePanel.this.bModify.setEnabled(true);
                    TemplatePreferencePanel.this.bSync.setEnabled(UserRightsManager.getCurrentUserRights().haveRight("SYNC_TEMPLATE"));
                    TemplatePreferencePanel.this.bUndo.setEnabled(true);
                }
            }
        });
        this.bModify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TemplatePreferencePanel.this.modifyTemplate(dm, table);
            }
        });
        this.bSync.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = table.getSelectedRow();
                dm.sync(row);
            }
        });
        this.bUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = table.getSelectedRow();
                dm.restore(row);
            }
        });
        return p;
    }

    @Override
    public void storeValues() {
        File z = new File(".");
        File f = new File(this.textTemplate.getText());
        try {
            TemplateNXProps.getInstance().setProperty("LocationTemplate", FileUtils.relative(z, f));
            DefaultLocalTemplateProvider provider = new DefaultLocalTemplateProvider();
            provider.setBaseDirectory(new File(FileUtils.relative(z, f)));
            TemplateManager.getInstance().setDefaultProvider(provider);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        TemplateNXProps.getInstance().store();
    }

    @Override
    public void restoreToDefaults() {
    }

    @Override
    public String getTitleName() {
        return "Emplacement des mod\u00e8les";
    }

    private void setValues() {
        try {
            File f = new File(TemplateNXProps.getInstance().getStringProperty("LocationTemplate"));
            if (f.exists()) {
                this.textTemplate.setForeground(UIManager.getColor("TextField.foreground"));
            } else {
                this.textTemplate.setForeground(Color.RED);
            }
            this.textTemplate.setText(f.getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void directoryChoose(final String type) {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setFileSelectionMode(1);
        }
        this.fileChooser.setCurrentDirectory(new File(this.textTemplate.getText()));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (TemplatePreferencePanel.this.fileChooser.showDialog(TemplatePreferencePanel.this, "S\u00e9lectionner") == 0 && type.equalsIgnoreCase("template")) {
                    File selectedFile = TemplatePreferencePanel.this.fileChooser.getSelectedFile();
                    if (selectedFile.exists()) {
                        TemplatePreferencePanel.this.textTemplate.setForeground(UIManager.getColor("TextField.foreground"));
                    } else {
                        TemplatePreferencePanel.this.textTemplate.setForeground(Color.RED);
                    }
                    TemplatePreferencePanel.this.textTemplate.setText(selectedFile.getPath());
                }
            }
        });
    }

    public void modifyTemplate(TemplateTableModel dm, JTable table) {
        int row = table.getSelectedRow();
        dm.unsync(row);
        final TemplateProvider templateProvider = dm.getTemplateProvider(row);
        if (templateProvider instanceof AbstractLocalTemplateProvider) {
            final String templateId = dm.getTemplateId(row);
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        File fileTemplate = ((AbstractLocalTemplateProvider)templateProvider).getFileTemplate(templateId, null, null);
                        if (fileTemplate != null && fileTemplate.exists()) {
                            FileUtils.openFile(fileTemplate);
                        }
                    }
                    catch (IOException e1) {
                        ExceptionHandler.handle("Impossible d'ouvrir le mod\u00e8le", e1);
                    }
                }
            });
            t.setName("TemplatePreferencePanel: open with OO");
            t.setDaemon(true);
            t.start();
        }
    }

    public void modifyTemplateXML(TemplateTableModel dm, JTable table) {
        int row = table.getSelectedRow();
        dm.unsync(row);
        final TemplateProvider templateProvider = dm.getTemplateProvider(row);
        if (templateProvider instanceof AbstractLocalTemplateProvider) {
            final String templateId = dm.getTemplateId(row);
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        File fileTemplateConfiguration = ((AbstractLocalTemplateProvider)templateProvider).getFileTemplateConfiguration(templateId, null, null);
                        if (fileTemplateConfiguration != null && fileTemplateConfiguration.exists()) {
                            FileUtils.openFile(fileTemplateConfiguration);
                        } else {
                            JOptionPane.showMessageDialog(TemplatePreferencePanel.this, "Pas de fichier de configuration associ\u00e9");
                        }
                    }
                    catch (IOException e1) {
                        ExceptionHandler.handle("Impossible d'ouvrir la configuration du mod\u00e8le", e1);
                    }
                }
            });
            t.setName("TemplatePreferencePanel: open with OO");
            t.setDaemon(true);
            t.start();
        }
    }

    public void modifyTemplateODSP(TemplateTableModel dm, JTable table) {
        int row = table.getSelectedRow();
        dm.unsync(row);
        final TemplateProvider templateProvider = dm.getTemplateProvider(row);
        if (templateProvider instanceof AbstractLocalTemplateProvider) {
            final String templateId = dm.getTemplateId(row);
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        File fileTemplatePrintConfiguration = ((AbstractLocalTemplateProvider)templateProvider).getFileTemplatePrintConfiguration(templateId, null, null);
                        if (fileTemplatePrintConfiguration != null && fileTemplatePrintConfiguration.exists()) {
                            FileUtils.openFile(fileTemplatePrintConfiguration);
                        }
                    }
                    catch (IOException e1) {
                        ExceptionHandler.handle("Impossible d'ouvrir la configuration d'impression", e1);
                    }
                }
            });
            t.setName("TemplatePreferencePanel: open with OO");
            t.setDaemon(true);
            t.start();
        }
    }
}

