/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openconcerto.erp.modules.Dependency;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModuleReference;
import org.openconcerto.erp.modules.ModuleVersion;
import org.openconcerto.utils.cc.IPredicate;

public abstract class PropsModuleFactory
extends ModuleFactory {
    private static final Pattern versionPatrn = Pattern.compile("(\\p{Digit}+)(?:\\.(\\p{Digit}+))?");
    private static final Pattern dependsSplitPatrn = Pattern.compile("\\p{Blank}*,\\p{Blank}+");
    private static final Pattern dependsPatrn = Pattern.compile("(" + ModuleReference.idPatrn.pattern() + ")(?:\\p{Blank}+\\( *(" + versionPatrn.pattern() + ") *\\))?");
    private final Map<Object, Dependency> depends;
    private final String mainClass;
    private ResourceBundle rsrcBundle;

    protected static Properties readAndClose(InputStream ins) throws IOException {
        Properties props = new Properties();
        try {
            props.load(ins);
        }
        finally {
            ins.close();
        }
        return props;
    }

    protected static final String getRequiredProp(Properties props, String key) {
        String res = props.getProperty(key);
        if (res == null) {
            throw new IllegalStateException("Missing " + key);
        }
        return res;
    }

    private static final int parseInt(Matcher m, int group) {
        String s = m.group(group);
        return s == null ? 0 : Integer.parseInt(s);
    }

    private static final ModuleVersion getVersion(Matcher m, int offset) {
        return new ModuleVersion(PropsModuleFactory.parseInt(m, offset + 1), PropsModuleFactory.parseInt(m, offset + 2));
    }

    private static final ModuleVersion getVersion(Properties props) {
        String version = PropsModuleFactory.getRequiredProp(props, "version").trim();
        Matcher versionMatcher = versionPatrn.matcher(version);
        if (!versionMatcher.matches()) {
            throw new IllegalArgumentException("Version doesn't match " + versionPatrn.pattern());
        }
        return PropsModuleFactory.getVersion(versionMatcher, 0);
    }

    protected PropsModuleFactory(Properties props) {
        super(new ModuleReference(PropsModuleFactory.getRequiredProp(props, "id"), PropsModuleFactory.getVersion(props)), PropsModuleFactory.getRequiredProp(props, "contact"));
        String depends = props.getProperty("depends", "").trim();
        String[] dependsArray = depends.length() == 0 ? new String[]{} : dependsSplitPatrn.split(depends);
        ArrayList<Dependency> l = new ArrayList<Dependency>(dependsArray.length);
        String[] stringArray = dependsArray;
        int n = dependsArray.length;
        int n2 = 0;
        while (n2 < n) {
            String depend = stringArray[n2];
            Matcher dependMatcher = dependsPatrn.matcher(depend);
            if (!dependMatcher.matches()) {
                throw new IllegalArgumentException("'" + depend + "' doesn't match " + dependsPatrn.pattern());
            }
            final ModuleVersion depVersion = PropsModuleFactory.getVersion(dependMatcher, 3);
            l.add(new Dependency(dependMatcher.group(1), new IPredicate<ModuleFactory>(){

                @Override
                public boolean evaluateChecked(ModuleFactory input) {
                    return input.getVersion().compareTo(depVersion) >= 0;
                }
            }));
            ++n2;
        }
        this.depends = Collections.unmodifiableMap(PropsModuleFactory.createMap(l));
        String entryPoint = ModuleReference.checkMatch(ModuleReference.javaIdentifiedPatrn, props.getProperty("entryPoint", "Module"), "Entry point");
        this.mainClass = String.valueOf(this.getID()) + "." + entryPoint;
        this.rsrcBundle = null;
    }

    protected final String getMainClass() {
        return this.mainClass;
    }

    @Override
    protected final Map<Object, Dependency> getDependencies() {
        return this.depends;
    }

    @Override
    protected final synchronized ResourceBundle getResourceBundle() {
        if (this.rsrcBundle == null) {
            this.rsrcBundle = ResourceBundle.getBundle(String.valueOf(this.getID()) + ".ModuleResources", Locale.getDefault(), this.getRsrcClassLoader(), ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES));
        }
        return this.rsrcBundle;
    }

    protected abstract ClassLoader getRsrcClassLoader();
}

