/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.openconcerto.erp.modules.AbstractModule;
import org.openconcerto.erp.modules.DepSolverGraph;
import org.openconcerto.erp.modules.ModuleReference;

final class ModulesStateChangeResult {
    private static final ModulesStateChangeResult EMPTY = ModulesStateChangeResult.onlyRemoved(Collections.emptySet());
    private final Set<ModuleReference> removed;
    private final Set<ModuleReference> notCreated;
    private final DepSolverGraph graph;
    private final Map<ModuleReference, AbstractModule> created;

    static final ModulesStateChangeResult empty() {
        return EMPTY;
    }

    static final ModulesStateChangeResult noneCreated(Set<ModuleReference> notCreated) {
        return new ModulesStateChangeResult(Collections.emptySet(), notCreated, null, Collections.emptyMap());
    }

    static final ModulesStateChangeResult onlyRemoved(Set<ModuleReference> removed) {
        return new ModulesStateChangeResult(removed, Collections.emptySet(), null, Collections.emptyMap());
    }

    ModulesStateChangeResult(Set<ModuleReference> removed, Set<ModuleReference> notCreated, DepSolverGraph graph, Map<ModuleReference, AbstractModule> created) {
        this.removed = Collections.unmodifiableSet(removed);
        this.notCreated = Collections.unmodifiableSet(notCreated);
        this.graph = graph;
        if (this.graph != null) {
            this.graph.freeze();
        }
        this.created = Collections.unmodifiableMap(created);
    }

    public final Set<ModuleReference> getRemoved() {
        return this.removed;
    }

    public final Set<ModuleReference> getNotCreated() {
        return this.notCreated;
    }

    public final DepSolverGraph getGraph() {
        return this.graph;
    }

    public final Map<ModuleReference, AbstractModule> getCreated() {
        return this.created;
    }
}

