/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.modules;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openconcerto.erp.modules.DepSolverGraph;
import org.openconcerto.erp.modules.DepSolverResult;
import org.openconcerto.erp.modules.InstallationState;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModuleManager;
import org.openconcerto.erp.modules.ModuleReference;
import org.openconcerto.erp.modules.ModulesStateChange;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.checks.ValidState;

public class DepSolverResultMM
extends DepSolverResult
implements ModulesStateChange {
    static final ITransformer<DepSolverResult, ValidState> VALID_PRED = new ITransformer<DepSolverResult, ValidState>(){

        @Override
        public ValidState transformChecked(DepSolverResult input) {
            DepSolverResultMM res = (DepSolverResultMM)input;
            return res.getInstallValidity().and(res.getUninstallValidity());
        }
    };
    private ModuleManager mngr;
    private InstallationState installState = null;
    private ModuleManager.NoChoicePredicate noChoice = null;
    private Set<ModuleReference> refs;
    private ChangeAndValidity toAdd = null;
    private ChangeAndValidity toRemove = null;

    private static final ChangeAndValidity createError(String error) {
        return new ChangeAndValidity(ValidState.createCached(false, error), null);
    }

    private static final ChangeAndValidity createOK(Set<ModuleReference> toChange) {
        if (toChange == null) {
            throw new NullPointerException("Null set");
        }
        return new ChangeAndValidity(ValidState.getTrueInstance(), toChange);
    }

    public DepSolverResultMM(DepSolverResultMM parent, int tryCount, String error, DepSolverGraph graph) {
        super(parent, tryCount, error, graph);
    }

    final void init(ModuleManager mngr, InstallationState installState) {
        this.init(mngr, installState, null, null);
    }

    final synchronized void init(ModuleManager mngr, InstallationState installState, ModuleManager.NoChoicePredicate s, Collection<ModuleReference> refs) {
        if (this.isInited()) {
            throw new IllegalStateException("Already set : " + this.installState);
        }
        if (mngr == null) {
            throw new NullPointerException("Null manager");
        }
        this.mngr = mngr;
        this.setInstallState(installState);
        this.noChoice = s;
        this.refs = refs == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<ModuleReference>(refs));
    }

    private final synchronized boolean isInited() {
        return this.installState != null;
    }

    private final synchronized void setInstallState(InstallationState installState) {
        if (installState == null) {
            throw new NullPointerException();
        }
        this.installState = installState;
    }

    public final synchronized ModuleManager getManager() {
        if (!this.isInited()) {
            throw new IllegalStateException("Not set");
        }
        return this.mngr;
    }

    @Override
    public final synchronized InstallationState getInstallState() {
        if (!this.isInited()) {
            throw new IllegalStateException("Not set");
        }
        return this.installState;
    }

    public final synchronized ModuleManager.NoChoicePredicate getNoChoiceSolution() {
        if (!this.isInited()) {
            throw new IllegalStateException("Not initialized");
        }
        return this.noChoice;
    }

    @Override
    public final synchronized Set<ModuleReference> getUserReferencesToInstall() {
        if (!this.isInited()) {
            throw new IllegalStateException("Not initialized");
        }
        return this.refs;
    }

    @Override
    public final synchronized Set<ModuleReference> getReferencesToInstall() {
        this.setToInstall();
        return this.toAdd.toChange;
    }

    private final synchronized void setToInstall() {
        if (this.toAdd == null) {
            this.toAdd = this.computeReferencesToInstall();
            assert (this.toAdd != null);
        }
    }

    public final synchronized ValidState getInstallValidity() {
        this.setToInstall();
        return this.toAdd.validity;
    }

    private final ChangeAndValidity computeReferencesToInstall() {
        Set<ModuleReference> localAndRemote = this.getInstallState().getLocalAndRemote();
        Set<ModuleFactory> factories = this.getGraph().getFactories();
        HashSet<ModuleReference> toInstall = new HashSet<ModuleReference>(factories.size());
        for (ModuleFactory f : factories) {
            if (localAndRemote.contains(f.getReference())) continue;
            toInstall.add(f.getReference());
        }
        ModuleManager.NoChoicePredicate s = this.getNoChoiceSolution();
        if (s == ModuleManager.NoChoicePredicate.NO_CHANGE && toInstall.size() > 0) {
            return DepSolverResultMM.createError((Object)((Object)s) + " required but would install " + toInstall);
        }
        if (s == ModuleManager.NoChoicePredicate.ONLY_INSTALL_ARGUMENTS && !this.getUserReferencesToInstall().containsAll(toInstall)) {
            return DepSolverResultMM.createError((Object)((Object)s) + " required but would install " + CollectionUtils.subtract(toInstall, this.getUserReferencesToInstall()) + "\nin addition to " + this.getUserReferencesToInstall());
        }
        for (ModuleReference toInst : toInstall) {
            if (this.getManager().canCurrentUserInstall(ModuleManager.ModuleAction.INSTALL, toInst, this.getInstallState())) continue;
            return DepSolverResultMM.createError("Current user cannot install " + toInst);
        }
        return DepSolverResultMM.createOK(toInstall);
    }

    @Override
    public final synchronized Set<ModuleReference> getReferencesToRemove() {
        this.setToUninstall();
        return this.toRemove.toChange;
    }

    private final synchronized void setToUninstall() {
        if (this.toRemove == null) {
            this.toRemove = this.computeReferencesToRemove();
            assert (this.toRemove != null);
        }
    }

    public final synchronized ValidState getUninstallValidity() {
        this.setToUninstall();
        return this.toRemove.validity;
    }

    @Override
    public boolean forceRemove() {
        return false;
    }

    private final ChangeAndValidity computeReferencesToRemove() {
        LinkedHashSet<ModuleReference> toUninstall;
        Set<ModuleFactory> factories = this.getGraph().getFactories();
        Collection<ModuleFactory> installedFactories = this.getInstallState().getAllInstalledFactories();
        if (installedFactories == null) {
            return DepSolverResultMM.createError("Missing some factories for installed modules");
        }
        HashSet<ModuleReference> conflicts = new HashSet<ModuleReference>();
        for (ModuleFactory f : installedFactories) {
            if (!f.conflictsWith(factories)) continue;
            conflicts.add(f.getReference());
        }
        try {
            toUninstall = this.getManager().getAllOrderedDependentModulesRecursively(conflicts);
        }
        catch (Exception e) {
            throw new IllegalStateException("couldn't find needing modules for " + conflicts, e);
        }
        if (this.getNoChoiceSolution() != null && toUninstall.size() > 0) {
            return DepSolverResultMM.createError((Object)((Object)this.getNoChoiceSolution()) + " required but would uninstall " + toUninstall);
        }
        for (ModuleReference toInst : toUninstall) {
            if (this.getManager().canCurrentUserInstall(ModuleManager.ModuleAction.UNINSTALL, toInst, this.getInstallState())) continue;
            return DepSolverResultMM.createError("Current user cannot uninstall " + toInst);
        }
        return DepSolverResultMM.createOK(toUninstall);
    }

    private static final class ChangeAndValidity {
        private final Set<ModuleReference> toChange;
        private final ValidState validity;

        private ChangeAndValidity(ValidState validity, Set<ModuleReference> toChange) {
            this.validity = validity;
            this.toChange = toChange;
            assert (this.toChange != null == this.validity.isValid());
        }
    }
}

