/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.util.Date;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.payment.element.ModeDeReglementSQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.generationEcritures.GenerationMvtSaisieVenteFacture;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class GenerationMvtRetourNatexis
extends GenerationEcritures {
    private static final SQLTable mvtTable = base.getTable("MOUVEMENT");
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);

    public GenerationMvtRetourNatexis(SQLRow rowFacture) throws Exception {
        if (rowFacture.getBoolean("AFFACTURAGE").booleanValue() && !rowFacture.getBoolean("RETOUR_NATEXIS").booleanValue()) {
            SQLRow rowClient = rowFacture.getForeign("ID_CLIENT");
            SQLRow modeRegl = rowFacture.getForeign("ID_MODE_REGLEMENT");
            SQLRow mvtSource = rowFacture.getForeign("ID_MOUVEMENT");
            Date dateEch = ModeDeReglementSQLElement.calculDate(modeRegl.getInt("AJOURS"), modeRegl.getInt("LENJOUR"), rowFacture.getDate("DATE").getTime());
            System.out.println("Ech\u00e9ance client");
            SQLRowValues valEcheance = new SQLRowValues(base.getTable("ECHEANCE_CLIENT"));
            this.idMvt = this.getNewMouvement("ECHEANCE_CLIENT", 1, ((SQLRowAccessor)mvtSource).getID(), mvtSource.getInt("ID_PIECE"));
            valEcheance.put("ID_MOUVEMENT", (Object)this.idMvt);
            valEcheance.put("DATE", dateEch);
            valEcheance.put("MONTANT", rowFacture.getObject("T_TTC"));
            valEcheance.put("ID_CLIENT", ((SQLRowAccessor)rowClient).getID());
            valEcheance.put("RETOUR_NATEXIS", Boolean.TRUE);
            SQLRow row = valEcheance.insert();
            SQLRowValues rowVals = new SQLRowValues(mvtTable);
            rowVals.put("IDSOURCE", row.getID());
            rowVals.update(this.idMvt);
            this.nom = "Retour natexis facture " + rowFacture.getObject("NUMERO").toString();
            this.date = new Date();
            this.mEcritures.put("DATE", this.date);
            this.mEcritures.put("NOM", this.nom);
            this.mEcritures.put("ID_JOURNAL", GenerationMvtSaisieVenteFacture.journal);
            int idJrnlFactor = rowPrefsCompte.getInt("ID_JOURNAL_FACTOR");
            if (idJrnlFactor > 1) {
                this.mEcritures.put("ID_JOURNAL", idJrnlFactor);
            }
            this.mEcritures.put("ID_MOUVEMENT", this.idMvt);
            int idComptefactor = rowPrefsCompte.getInt("ID_COMPTE_PCE_FACTOR");
            if (idComptefactor <= 1 && (idComptefactor = rowPrefsCompte.getInt("ID_COMPTE_PCE_FACTOR")) <= 1) {
                idComptefactor = ComptePCESQLElement.getIdComptePceDefault("Factor");
            }
            this.mEcritures.put("ID_COMPTE_PCE", idComptefactor);
            this.mEcritures.put("CREDIT", rowFacture.getObject("T_TTC"));
            this.mEcritures.put("DEBIT", 0L);
            this.ajoutEcriture();
            int idCompteClient = rowClient.getInt("ID_COMPTE_PCE");
            if (idCompteClient <= 1 && (idCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT")) <= 1) {
                try {
                    idCompteClient = ComptePCESQLElement.getIdComptePceDefault("Clients");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.mEcritures.put("ID_COMPTE_PCE", idCompteClient);
            this.mEcritures.put("DEBIT", rowFacture.getObject("T_TTC"));
            this.mEcritures.put("CREDIT", 0L);
            this.ajoutEcriture();
            SQLRowValues rowValsFacture = rowFacture.asRowValues();
            rowValsFacture.put("RETOUR_NATEXIS", Boolean.TRUE);
            rowValsFacture.update();
        }
    }
}

