/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.sql.model.SQLRowAccessor;

public class TotalAcompteProvider
implements SpreadSheetCellValueProvider {
    private final TypeTotalAcompteProvider type;

    public TotalAcompteProvider(TypeTotalAcompteProvider t) {
        this.type = t;
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor row = context.getRow();
        Calendar c = row.getDate("DATE");
        Collection<? extends SQLRowAccessor> rows = row.getReferentRows(row.getTable().getTable("TR_COMMANDE_CLIENT"));
        long total = 0L;
        HashSet<SQLRowAccessor> facture = new HashSet<SQLRowAccessor>();
        facture.add(row);
        for (SQLRowAccessor sQLRowAccessor : rows) {
            total += this.getPreviousAcompte(sQLRowAccessor.getForeign("ID_COMMANDE_CLIENT"), facture, c);
        }
        return new BigDecimal(total).movePointLeft(2);
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("sales.account.total", new TotalAcompteProvider(TypeTotalAcompteProvider.HT));
        SpreadSheetCellValueProviderManager.put("sales.account.total.ttc", new TotalAcompteProvider(TypeTotalAcompteProvider.TTC));
    }

    public long getPreviousAcompte(SQLRowAccessor sqlRowAccessor, Set<SQLRowAccessor> alreadyAdded, Calendar c) {
        if (sqlRowAccessor == null || sqlRowAccessor.isUndefined()) {
            return 0L;
        }
        Collection<? extends SQLRowAccessor> rows = sqlRowAccessor.getReferentRows(sqlRowAccessor.getTable().getTable("TR_COMMANDE_CLIENT"));
        long l = 0L;
        for (SQLRowAccessor sQLRowAccessor : rows) {
            SQLRowAccessor rowFact = sQLRowAccessor.getForeign("ID_SAISIE_VENTE_FACTURE");
            if (rowFact == null || rowFact.isUndefined() || alreadyAdded.contains(rowFact) || !rowFact.getDate("DATE").before(c)) continue;
            alreadyAdded.add(rowFact);
            l += this.type == TypeTotalAcompteProvider.HT ? rowFact.getLong("T_HT") : rowFact.getLong("T_TTC");
        }
        return l;
    }

    public static enum TypeTotalAcompteProvider {
        HT,
        TTC;

    }
}

