/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.openconcerto.erp.config.Log;
import org.openconcerto.erp.generationDoc.TemplateProvider;

public class TemplateManager {
    private static TemplateManager instance = new TemplateManager();
    private List<TemplateProvider> providers = new ArrayList<TemplateProvider>();
    private Map<String, TemplateProvider> defaultMap = new HashMap<String, TemplateProvider>();
    private TemplateProvider defautProvider;
    private List<String> knownTemplateIds = new ArrayList<String>();

    public static TemplateManager getInstance() {
        return instance;
    }

    public void add(TemplateProvider provider) {
        this.providers.add(provider);
    }

    public void remove(TemplateProvider provider) {
        this.providers.remove(provider);
        Set<String> keys = this.defaultMap.keySet();
        for (String key : keys) {
            if (!this.defaultMap.get(key).equals(provider)) continue;
            this.defaultMap.remove(key);
        }
    }

    public void setDefaultProvider(String templateId, TemplateProvider provider) {
        this.defaultMap.put(templateId, provider);
        this.register(templateId);
    }

    public void setDefaultProvider(TemplateProvider provider) {
        this.defautProvider = provider;
    }

    public InputStream getTemplate(String templateId, String language, String type) {
        TemplateProvider provider = this.defaultMap.get(templateId);
        if (provider == null) {
            for (TemplateProvider pr : this.providers) {
                InputStream stream = pr.getTemplate(templateId, language, type);
                if (stream == null) continue;
                return stream;
            }
            if (this.defautProvider == null) {
                throw new IllegalStateException("Not default provider registered when using template id:" + templateId + " language:" + language + " type:" + type);
            }
            return this.defautProvider.getTemplate(templateId, language, type);
        }
        return provider.getTemplate(templateId, language, type);
    }

    public InputStream getTemplatePrintConfiguration(String templateId, String language, String type) {
        TemplateProvider provider = this.defaultMap.get(templateId);
        if (provider == null) {
            for (TemplateProvider pr : this.providers) {
                InputStream stream = pr.getTemplatePrintConfiguration(templateId, language, type);
                if (stream == null) continue;
                return stream;
            }
            if (this.defautProvider == null) {
                throw new IllegalStateException("Not default provider registered when using template id:" + templateId + " langage:" + language + " type:" + type);
            }
            return this.defautProvider.getTemplatePrintConfiguration(templateId, language, type);
        }
        return provider.getTemplatePrintConfiguration(templateId, language, type);
    }

    public InputStream getTemplateConfiguration(String templateId, String language, String type) {
        TemplateProvider provider = this.defaultMap.get(templateId);
        if (provider == null) {
            for (TemplateProvider pr : this.providers) {
                InputStream stream = pr.getTemplateConfiguration(templateId, language, type);
                if (stream == null) continue;
                return stream;
            }
            if (this.defautProvider == null) {
                throw new IllegalStateException("Not default provider registered when using template id:" + templateId + " langage:" + language + " type:" + type);
            }
            return this.defautProvider.getTemplateConfiguration(templateId, language, type);
        }
        return provider.getTemplateConfiguration(templateId, language, type);
    }

    public InputStream getTemplate(String templateId) {
        return this.getTemplate(templateId, null, null);
    }

    public void register(String templateId) {
        if (!this.knownTemplateIds.contains(templateId)) {
            this.knownTemplateIds.add(templateId);
        }
    }

    public void dump() {
        Logger l = Log.get();
        l.config(String.valueOf(this.getClass().getCanonicalName()) + " Default provider: " + this.defautProvider);
        for (String templateId : this.knownTemplateIds) {
            try {
                InputStream stream = this.getTemplate(templateId);
                if (stream == null) {
                    l.warning(String.valueOf(this.rightAlign("'" + templateId + "'")) + " : stream missing");
                    continue;
                }
                l.config(String.valueOf(this.rightAlign("'" + templateId + "'")) + " : ok");
            }
            catch (Exception e) {
                l.warning(String.valueOf(this.rightAlign("'" + templateId + "'")) + ": stream error");
            }
        }
    }

    private String rightAlign(String s) {
        String r = s;
        int n = 20 - s.length();
        int i = 0;
        while (i < n) {
            r = String.valueOf(' ') + r;
            ++i;
        }
        return r;
    }

    public boolean isKnwonTemplate(String templateId) {
        return this.knownTemplateIds.contains(templateId);
    }

    public List<String> getKnownTemplateIds() {
        return this.knownTemplateIds;
    }

    public TemplateProvider getProvider(String templateId) {
        TemplateProvider provider = this.defaultMap.get(templateId);
        if (provider == null) {
            return this.defautProvider;
        }
        return provider;
    }
}

