/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.receipt.component;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.common.ui.TotalPanel;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.sales.product.ui.ReliquatRowValuesTable;
import org.openconcerto.erp.core.supplychain.receipt.element.BonReceptionSQLElement;
import org.openconcerto.erp.core.supplychain.receipt.ui.BonReceptionItemTable;
import org.openconcerto.erp.core.supplychain.stock.element.StockItemsUpdater;
import org.openconcerto.erp.core.supplychain.stock.element.StockLabel;
import org.openconcerto.erp.generationDoc.gestcomm.BonReceptionXmlSheet;
import org.openconcerto.erp.panel.PanelOOSQLComponent;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.JUniqueTextField;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.NumberUtils;

public class BonReceptionSQLComponent
extends TransfertBaseSQLComponent {
    private BonReceptionItemTable tableBonItem;
    private ReliquatRowValuesTable tableBonReliquatItem;
    private ElementComboBox selectCommande;
    private ElementComboBox fournisseur;
    private JUniqueTextField textNumeroUnique;
    private final SQLTable tableNum = this.getTable().getBase().getTable("NUMEROTATION_AUTO");
    private final JTextField textReference = new JTextField(25);
    private PanelOOSQLComponent panelOO;
    private JDate date = new JDate(true);

    public BonReceptionSQLComponent() {
        super(Configuration.getInstance().getDirectory().getElement("BON_RECEPTION"));
    }

    @Override
    protected SQLRowValues createDefaults() {
        this.tableBonItem.getModel().clearRows();
        this.textNumeroUnique.setText(NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass()));
        SQLRowValues rowVals = new SQLRowValues(this.getTable());
        rowVals.put("T_DEVISE", 0L);
        if (this.getTable().contains("CREATE_VIRTUAL_STOCK")) {
            rowVals.put("CREATE_VIRTUAL_STOCK", Boolean.TRUE);
        }
        return rowVals;
    }

    @Override
    public void addViews() {
        TitledSeparator sep;
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        if (this.getTable().contains("CREATE_VIRTUAL_STOCK")) {
            this.addView(new JCheckBox(), "CREATE_VIRTUAL_STOCK");
        }
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        JPanel addP = ComptaSQLConfElement.createAdditionalPanel();
        this.setAdditionalFieldsPanel(new FormLayouter(addP, 1));
        this.add((Component)addP, c);
        ++c.gridy;
        c.gridwidth = 1;
        this.selectCommande = new ElementComboBox();
        JLabel labelNum = new JLabel(this.getLabelFor("NUMERO"));
        labelNum.setHorizontalAlignment(4);
        this.add((Component)labelNum, c);
        this.textNumeroUnique = new JUniqueTextField(16){

            @Override
            public String getAutoRefreshNumber() {
                if (BonReceptionSQLComponent.this.getMode() == SQLComponent.Mode.INSERTION) {
                    return NumerotationAutoSQLElement.getNextNumero(BonReceptionSQLComponent.this.getElement().getClass(), BonReceptionSQLComponent.this.date.getDate());
                }
                return null;
            }
        };
        ++c.gridx;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        DefaultGridBagConstraints.lockMinimumSize(this.textNumeroUnique);
        this.add((Component)this.textNumeroUnique, c);
        JLabel labelDate = new JLabel(this.getLabelFor("DATE"));
        labelDate.setHorizontalAlignment(4);
        c.fill = 2;
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)labelDate, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.add((Component)this.date, c);
        this.date.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!BonReceptionSQLComponent.this.isFilling() && BonReceptionSQLComponent.this.date.getValue() != null) {
                    BonReceptionSQLComponent.this.tableBonItem.setDateDevise(BonReceptionSQLComponent.this.date.getValue());
                }
            }
        });
        ++c.gridy;
        c.gridx = 0;
        JLabel labelNom = new JLabel(this.getLabelFor("NOM"));
        labelNom.setHorizontalAlignment(4);
        this.add((Component)labelNom, c);
        ++c.gridx;
        c.fill = 2;
        DefaultGridBagConstraints.lockMinimumSize(this.textReference);
        this.add((Component)this.textReference, c);
        JLabel labelFournisseur = new JLabel(this.getLabelFor("ID_FOURNISSEUR"));
        labelFournisseur.setHorizontalAlignment(4);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.add((Component)labelFournisseur, c);
        this.fournisseur = new ElementComboBox();
        ++c.gridx;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.add((Component)this.fournisseur, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel(this.getLabelFor("ID_DEVISE"), 4), c);
        final ElementComboBox boxDevise = new ElementComboBox();
        c.gridx = -1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        DefaultGridBagConstraints.lockMinimumSize(boxDevise);
        this.add((Component)boxDevise, c);
        this.addView(boxDevise, "ID_DEVISE");
        this.fournisseur.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                if (BonReceptionSQLComponent.this.fournisseur.getSelectedRow() != null && BonReceptionSQLComponent.this.fournisseur.getSelectedRow().getFields().contains("ID_DEVISE")) {
                    boxDevise.setValue(BonReceptionSQLComponent.this.fournisseur.getSelectedRow().asRow().getForeignID("ID_DEVISE"));
                } else {
                    boxDevise.setValue((SQLRowAccessor)null);
                }
            }
        });
        this.tableBonItem = new BonReceptionItemTable();
        boxDevise.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BonReceptionSQLComponent.this.tableBonItem.setDevise(boxDevise.getSelectedRow());
            }
        });
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.fill = 1;
        this.add((Component)this.tableBonItem, c);
        this.fournisseur.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BonReceptionSQLComponent.this.tableBonItem.setFournisseur(BonReceptionSQLComponent.this.fournisseur.getSelectedRow());
            }
        });
        c.anchor = 13;
        ++c.gridy;
        c.gridx = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 13;
        c.gridwidth = 1;
        c.fill = 0;
        c.gridx = 2;
        c.gridwidth = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 13;
        c.fill = 2;
        DeviseField fieldHT = new DeviseField();
        DeviseField fieldEco = new DeviseField();
        DeviseField fieldTVA = new DeviseField();
        DeviseField fieldTTC = new DeviseField();
        DeviseField fieldDevise = new DeviseField();
        JTextField fieldPoids = new JTextField();
        fieldHT.setOpaque(false);
        fieldTVA.setOpaque(false);
        fieldTTC.setOpaque(false);
        this.addRequiredSQLObject(fieldEco, "T_ECO_CONTRIBUTION");
        this.addRequiredSQLObject(fieldDevise, "T_DEVISE");
        this.addRequiredSQLObject(fieldHT, "TOTAL_HT");
        this.addRequiredSQLObject(fieldTVA, "TOTAL_TVA");
        this.addRequiredSQLObject(fieldPoids, "TOTAL_POIDS");
        this.addRequiredSQLObject(fieldTTC, "TOTAL_TTC");
        this.allowEditable("TOTAL_HT", false);
        this.allowEditable("TOTAL_TVA", false);
        this.allowEditable("TOTAL_TTC", false);
        this.allowEditable("T_ECO_CONTRIBUTION", false);
        this.allowEditable("TOTAL_POIDS", false);
        DeviseField textRemiseHT = new DeviseField();
        DeviseField fieldService = new DeviseField();
        DeviseField textPortHT = new DeviseField();
        TotalPanel totalTTC = new TotalPanel(this.tableBonItem, fieldEco, fieldHT, fieldTVA, fieldTTC, textPortHT, textRemiseHT, fieldService, null, fieldDevise, fieldPoids, null, null, null);
        ++c.gridx;
        ++c.gridy;
        c.gridwidth = 0;
        c.gridheight = 2;
        c.anchor = 12;
        c.fill = 1;
        c.weighty = 0.0;
        DefaultGridBagConstraints.lockMinimumSize(totalTTC);
        this.add((Component)totalTTC, c);
        ++c.gridy;
        c.gridheight = 1;
        c.anchor = 17;
        if (this.getTable().getDBRoot().contains("RELIQUAT_BR")) {
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.fill = 2;
            c.gridx = 0;
            ++c.gridy;
            sep = new TitledSeparator("Reliquat de kits");
            c.insets = new Insets(10, 2, 1, 2);
            this.add((Component)sep, c);
            c.insets = new Insets(2, 2, 1, 2);
            this.tableBonReliquatItem = new ReliquatRowValuesTable("RELIQUAT_BR");
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridwidth = 0;
            c.fill = 1;
            this.add((Component)this.tableBonReliquatItem, c);
            this.tableBonItem.setReliquatTable(this.tableBonReliquatItem);
        }
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridx = 0;
        ++c.gridy;
        sep = new TitledSeparator("Informations compl\u00e9mentaires");
        c.insets = new Insets(10, 2, 1, 2);
        this.add((Component)sep, c);
        c.insets = new Insets(2, 2, 1, 2);
        c.gridx = 0;
        ++c.gridy;
        c.gridheight = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 1;
        ITextArea textInfos = new ITextArea(4, 4);
        JScrollPane scrollPane = new JScrollPane(textInfos);
        DefaultGridBagConstraints.lockMinimumSize(scrollPane);
        this.add((Component)textInfos, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        c.anchor = 14;
        c.gridwidth = 0;
        this.panelOO = new PanelOOSQLComponent(this);
        this.add((Component)this.panelOO, c);
        this.addRequiredSQLObject(this.date, "DATE");
        this.addSQLObject(textInfos, "INFOS");
        this.addSQLObject(this.textReference, "NOM");
        this.addSQLObject(this.selectCommande, "ID_COMMANDE");
        this.addRequiredSQLObject(this.textNumeroUnique, "NUMERO");
        this.addRequiredSQLObject(this.fournisseur, "ID_FOURNISSEUR");
        this.textNumeroUnique.setText(NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass()));
        DefaultGridBagConstraints.lockMinimumSize(this.fournisseur);
    }

    @Override
    public int insert(SQLRow order) {
        String num;
        int idBon = -1;
        int attempt = 0;
        if (!this.textNumeroUnique.checkValidation(false)) {
            while (attempt < JUniqueTextField.RETRY_COUNT) {
                num = NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass(), this.date.getDate());
                this.textNumeroUnique.setText(num);
                ++attempt;
                if (this.textNumeroUnique.checkValidation(false)) {
                    System.err.println("ATEMPT " + attempt + " SUCCESS WITH NUMERO " + num);
                    break;
                }
                try {
                    Thread.sleep(JUniqueTextField.SLEEP_WAIT_MS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        num = this.textNumeroUnique.getText();
        if (attempt == JUniqueTextField.RETRY_COUNT) {
            idBon = this.getSelectedID();
            ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de bon existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
        } else {
            idBon = super.insert(order);
            try {
                this.tableBonItem.updateField("ID_BON_RECEPTION", idBon);
                if (this.tableBonReliquatItem != null) {
                    this.tableBonReliquatItem.updateField("ID_BON_RECEPTION_ORIGINE", idBon);
                }
                this.tableBonItem.createArticle(idBon, this.getElement());
                if (NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass()).equalsIgnoreCase(this.textNumeroUnique.getText().trim())) {
                    SQLRowValues rowVals = new SQLRowValues(this.tableNum);
                    int val = this.tableNum.getRow(2).getInt("BON_R_START");
                    rowVals.put("BON_R_START", new Integer(++val));
                    rowVals.update(2);
                }
                final int idBonFinal = idBon;
                ComptaPropsConfiguration.getInstanceCompta().getNonInteractiveSQLExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            BonReceptionSQLComponent.this.updateStock(idBonFinal);
                            ((BonReceptionSQLElement)BonReceptionSQLComponent.this.getElement()).updateCmdElement(((BonReceptionSQLElement)BonReceptionSQLComponent.this.getElement()).getCmdFrom(idBonFinal), idBonFinal);
                        }
                        catch (Exception e) {
                            ExceptionHandler.handle("Update error", e);
                        }
                    }
                });
                BonReceptionXmlSheet sheet = new BonReceptionXmlSheet(this.getTable().getRow(idBonFinal));
                sheet.createDocumentAsynchronous();
                sheet.showPrintAndExportAsynchronous(this.panelOO.isVisualisationSelected(), this.panelOO.isImpressionSelected(), true);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return idBon;
    }

    @Override
    protected RowValuesTable getRowValuesTable() {
        return this.tableBonItem.getRowValuesTable();
    }

    public void loadFromReliquat(List<SQLRowValues> l) {
        this.tableBonItem.insertFromReliquat(l);
        this.tableBonItem.setEnabled(false);
    }

    public void loadQuantity(List<SQLRowValues> l) {
        HashMap<Integer, SQLRowValues> map = new HashMap<Integer, SQLRowValues>();
        for (SQLRowValues sqlRowValues : l) {
            if (sqlRowValues.isForeignEmpty("ID_ARTICLE")) continue;
            int foreignID = sqlRowValues.getForeignID("ID_ARTICLE");
            if (!map.containsKey(foreignID)) {
                map.put(foreignID, sqlRowValues);
                continue;
            }
            SQLRowValues vals = (SQLRowValues)map.get(foreignID);
            if (sqlRowValues.getInt("QTE") <= 0) continue;
            if (NumberUtils.areNumericallyEqual(sqlRowValues.getBigDecimal("QTE_UNITAIRE"), BigDecimal.ONE) || sqlRowValues.getInt("QTE") > 1) {
                vals.put("QTE", vals.getInt("QTE") + sqlRowValues.getInt("QTE"));
                continue;
            }
            vals.put("QTE_UNITAIRE", vals.getBigDecimal("QTE_UNITAIRE").add(sqlRowValues.getBigDecimal("QTE_UNITAIRE")));
        }
        int count = this.tableBonItem.getModel().getRowCount();
        int i = 0;
        while (i < count) {
            SQLRowValues r = this.tableBonItem.getModel().getRowValuesAt(i);
            SQLRowValues rowTR = (SQLRowValues)map.get(r.getForeignID("ID_ARTICLE"));
            if (rowTR != null && !rowTR.isUndefined() && r.getInt("QTE") > 0) {
                if (NumberUtils.areNumericallyEqual(r.getBigDecimal("QTE_UNITAIRE"), BigDecimal.ONE) || r.getInt("QTE") > 1) {
                    this.tableBonItem.getModel().putValue(r.getInt("QTE") - rowTR.getInt("QTE"), i, "QTE");
                } else {
                    this.tableBonItem.getModel().putValue(r.getBigDecimal("QTE_UNITAIRE").subtract(rowTR.getBigDecimal("QTE_UNITAIRE")), i, "QTE_UNITAIRE");
                }
            }
            ++i;
        }
    }

    @Override
    public void update() {
        if (!this.textNumeroUnique.checkValidation()) {
            ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de bon de livraison existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
            return;
        }
        super.update();
        final List<Object> cmdFrom = ((BonReceptionSQLElement)this.getElement()).getCmdFrom(this.getSelectedID());
        this.tableBonItem.updateField("ID_BON_RECEPTION", this.getSelectedID());
        if (this.tableBonReliquatItem != null) {
            this.tableBonReliquatItem.updateField("ID_BON_RECEPTION_ORIGINE", this.getSelectedID());
        }
        this.tableBonItem.createArticle(this.getSelectedID(), this.getElement());
        final int id = this.getSelectedID();
        ComptaPropsConfiguration.getInstanceCompta().getNonInteractiveSQLExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    BonReceptionSQLComponent.this.updateStock(id);
                    ((BonReceptionSQLElement)BonReceptionSQLComponent.this.getElement()).updateCmdElement(cmdFrom, BonReceptionSQLComponent.this.getSelectedID());
                }
                catch (Exception e) {
                    ExceptionHandler.handle("Update error", e);
                }
            }
        });
        BonReceptionXmlSheet sheet = new BonReceptionXmlSheet(this.getTable().getRow(id));
        sheet.createDocumentAsynchronous();
        sheet.showPrintAndExportAsynchronous(this.panelOO.isVisualisationSelected(), this.panelOO.isImpressionSelected(), true);
    }

    private void calculPHaPondere(int id) throws SQLException {
        SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
        SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement(sqlTableArticle);
        SQLElement eltStock = Configuration.getInstance().getDirectory().getElement("STOCK");
        SQLRow row = this.getTable().getRow(id);
        SQLTable sqlTableBonElt = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("BON_RECEPTION_ELEMENT");
        Collection elts = row.getReferentRows(sqlTableBonElt);
        for (SQLRow rowEltBon : elts) {
            SQLRow rowArticle;
            SQLRowValues rowVals = rowEltBon.createUpdateRow();
            int idArticle = ReferenceArticleSQLElement.getIdForCNM(rowVals, false);
            if (idArticle <= 1 || (rowArticle = eltArticle.getTable().getRow(idArticle)) == null) continue;
            BigDecimal prixHA = (BigDecimal)rowArticle.getObject("PRIX_METRIQUE_HA_1");
            int idStock = rowArticle.getInt("ID_STOCK");
            SQLRow rowStock = eltStock.getTable().getRow(idStock);
            BigDecimal qteStock = new BigDecimal(rowStock.getInt("QTE_REEL"));
            if (prixHA == null || qteStock.compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal qteRecue = new BigDecimal(rowEltBon.getInt("QTE"));
            BigDecimal prixHACmd = (BigDecimal)rowEltBon.getObject("PRIX_METRIQUE_HA_1");
            if (qteRecue.compareTo(BigDecimal.ZERO) <= 0 || prixHACmd == null) continue;
            BigDecimal totalHARecue = qteRecue.multiply(prixHACmd, DecimalUtils.HIGH_PRECISION);
            BigDecimal totalHAStock = qteStock.multiply(prixHA, DecimalUtils.HIGH_PRECISION);
            BigDecimal totalQte = qteRecue.add(qteStock);
            BigDecimal prixHaPond = totalHARecue.add(totalHAStock).divide(totalQte, DecimalUtils.HIGH_PRECISION);
            SQLRowValues rowValsArticle = rowArticle.createEmptyUpdateRow();
            rowValsArticle.put("PRIX_METRIQUE_HA_1", prixHaPond);
            rowValsArticle.commit();
        }
    }

    protected String getLibelleStock(SQLRowAccessor row, SQLRowAccessor rowElt) {
        return "Bon de r\u00e9ception N\u00b0" + row.getString("NUMERO");
    }

    private void updateStock(int id) throws SQLException {
        SQLRow row = this.getTable().getRow(id);
        StockItemsUpdater stockUpdater = new StockItemsUpdater(new StockLabel(){

            @Override
            public String getLabel(SQLRowAccessor rowOrigin, SQLRowAccessor rowElt) {
                return BonReceptionSQLComponent.this.getLibelleStock(rowOrigin, rowElt);
            }
        }, row, (List<? extends SQLRowAccessor>)row.getReferentRows(this.getTable().getTable("BON_RECEPTION_ELEMENT")), this.getTable().contains("CREATE_VIRTUAL_STOCK") && row.getBoolean("CREATE_VIRTUAL_STOCK") != false ? StockItemsUpdater.TypeStockUpdate.REAL_VIRTUAL_RECEPT : StockItemsUpdater.TypeStockUpdate.REAL_RECEPT);
        if (this.getTable().getDBRoot().contains("RELIQUAT_BR")) {
            Collection l = row.getReferentRows(this.getTable().getTable("RELIQUAT_BR").getField("ID_BON_RECEPTION_ORIGINE"));
            for (SQLRow sqlRow : l) {
                stockUpdater.addReliquat(sqlRow.getForeign("ID_ARTICLE"), sqlRow.getInt("QTE"), sqlRow.getBigDecimal("QTE_UNITAIRE"));
            }
        }
        stockUpdater.update();
    }

    @Override
    public void select(SQLRowAccessor r) {
        super.select(r);
        if (this.tableBonReliquatItem != null) {
            this.tableBonReliquatItem.getRowValuesTable().clear();
            if (r != null) {
                this.tableBonReliquatItem.getRowValuesTable().insertFrom("ID_BON_RECEPTION_ORIGINE", r.asRowValues());
            }
        }
    }

    @Override
    protected void refreshAfterSelect(SQLRowAccessor rSource) {
        if (this.date.getValue() != null) {
            this.tableBonItem.setDateDevise(this.date.getValue());
        }
    }
}

