/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.order.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.component.AdresseSQLComponent;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.common.ui.TotalPanel;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.supplychain.order.ui.CommandeItemTable;
import org.openconcerto.erp.core.supplychain.stock.element.StockItemsUpdater;
import org.openconcerto.erp.core.supplychain.stock.element.StockLabel;
import org.openconcerto.erp.generationDoc.gestcomm.CommandeXmlSheet;
import org.openconcerto.erp.panel.PanelOOSQLComponent;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.erp.utils.TM;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.DefaultElementSQLObject;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.sqlobject.JUniqueTextField;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.ui.AutoHideListener;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.component.ComboLockedMode;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.ui.component.ITextCombo;
import org.openconcerto.ui.component.InteractionMode;
import org.openconcerto.ui.preferences.DefaultProps;
import org.openconcerto.utils.ExceptionHandler;

public class CommandeSQLComponent
extends TransfertBaseSQLComponent {
    private CommandeItemTable table = new CommandeItemTable();
    private PanelOOSQLComponent panelOO;
    private JUniqueTextField numeroUniqueCommande;
    private final SQLTable tableNum = this.getTable().getBase().getTable("NUMEROTATION_AUTO");
    private final ITextArea infos = new ITextArea(3, 3);
    private ElementComboBox fourn = new ElementComboBox();
    final JCheckBox boxLivrClient = new JCheckBox("Livrer directement le client");
    private DefaultElementSQLObject compAdr;
    final JPanel panelAdrSpec = new JPanel(new GridBagLayout());
    protected ElementComboBox boxAdr;
    private JDate dateCommande = new JDate(true);
    private ElementSQLObject componentPrincipaleAdr;

    public CommandeSQLComponent() {
        super(Configuration.getInstance().getDirectory().getElement("COMMANDE"));
    }

    public ElementComboBox getBoxFournisseur() {
        return this.fourn;
    }

    @Override
    public void addViews() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        c.weightx = 0.0;
        this.add((Component)new JLabel(this.getLabelFor("NUMERO"), 4), c);
        this.numeroUniqueCommande = new JUniqueTextField(16){

            @Override
            public String getAutoRefreshNumber() {
                if (CommandeSQLComponent.this.getMode() == SQLComponent.Mode.INSERTION) {
                    return NumerotationAutoSQLElement.getNextNumero(CommandeSQLComponent.this.getElement().getClass(), CommandeSQLComponent.this.dateCommande.getDate());
                }
                return null;
            }
        };
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 0;
        DefaultGridBagConstraints.lockMinimumSize(this.numeroUniqueCommande);
        this.add((Component)this.numeroUniqueCommande, c);
        JLabel labelDate = new JLabel(this.getLabelFor("DATE"));
        labelDate.setHorizontalAlignment(4);
        c.gridx = 2;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)labelDate, c);
        ++c.gridx;
        c.fill = 0;
        this.add((Component)this.dateCommande, c);
        this.dateCommande.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!CommandeSQLComponent.this.isFilling() && CommandeSQLComponent.this.dateCommande.getValue() != null) {
                    CommandeSQLComponent.this.table.setDateDevise(CommandeSQLComponent.this.dateCommande.getValue());
                }
            }
        });
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel(this.getLabelFor("ID_FOURNISSEUR"), 4), c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.add((Component)this.fourn, c);
        if (!this.getTable().getFieldsName().contains("LIVRER")) {
            JCheckBox boxEnCours = new JCheckBox(this.getLabelFor("EN_COURS"));
            c.gridx += 2;
            c.weightx = 0.0;
            c.fill = 2;
            c.gridwidth = 0;
            this.add((Component)boxEnCours, c);
            c.gridwidth = 1;
            this.addRequiredSQLObject(boxEnCours, "EN_COURS");
        }
        if (this.getTable().contains("DATE_RECEPTION_DEMANDEE")) {
            JLabel labelDateRecptDemande = new JLabel(this.getLabelFor("DATE_RECEPTION_DEMANDEE"));
            labelDateRecptDemande.setHorizontalAlignment(4);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            c.fill = 2;
            this.add((Component)labelDateRecptDemande, c);
            ++c.gridx;
            c.fill = 0;
            JDate dateRecptDemande = new JDate();
            this.add((Component)dateRecptDemande, c);
            this.addView(dateRecptDemande, "DATE_RECEPTION_DEMANDEE", (Object)"required");
            JLabel labelDateRecptConfirme = new JLabel(this.getLabelFor("DATE_RECEPTION_CONFIRMEE"));
            labelDateRecptConfirme.setHorizontalAlignment(4);
            ++c.gridx;
            c.weightx = 0.0;
            c.fill = 2;
            this.add((Component)labelDateRecptConfirme, c);
            ++c.gridx;
            c.fill = 0;
            JDate dateRecptConfirme = new JDate();
            this.add((Component)dateRecptConfirme, c);
            this.addView(dateRecptConfirme, "DATE_RECEPTION_CONFIRMEE");
        }
        if (this.getTable().contains("ID_CONTACT_FOURNISSEUR")) {
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            c.fill = 2;
            this.add((Component)new JLabel(this.getLabelFor("ID_CONTACT_FOURNISSEUR"), 4), c);
            c.gridx = -1;
            c.gridwidth = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.fill = 2;
            final ElementComboBox boxContactFournisseur = new ElementComboBox();
            final SQLElement contactElement = Configuration.getInstance().getDirectory().getElement("CONTACT_FOURNISSEUR");
            boxContactFournisseur.init(contactElement, contactElement.getComboRequest(true));
            this.add((Component)boxContactFournisseur, c);
            this.addView(boxContactFournisseur, "ID_CONTACT_FOURNISSEUR", (Object)"required");
            this.fourn.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent arg0) {
                    if (CommandeSQLComponent.this.fourn.getSelectedRow() != null) {
                        boxContactFournisseur.getRequest().setWhere(new Where((FieldRef)contactElement.getTable().getField("ID_FOURNISSEUR"), "=", CommandeSQLComponent.this.fourn.getSelectedRow().getID()));
                    } else {
                        boxContactFournisseur.getRequest().setWhere(null);
                    }
                }
            });
        }
        if (this.getTable().getFieldsName().contains("ID_ADRESSE")) {
            if (this.getTable().getFieldsName().contains("LIVRAISON_F")) {
                c.gridx = 0;
                ++c.gridy;
                c.weightx = 0.0;
                c.fill = 2;
                this.boxAdr = new ElementComboBox();
                SQLElement adrElement = this.getElement().getForeignElement("ID_ADRESSE");
                this.boxAdr.init(adrElement);
                c.gridwidth = 1;
                final JLabel labelAdrLiv = new JLabel("Adresse de livraison existante");
                this.add((Component)labelAdrLiv, c);
                ++c.gridx;
                c.gridwidth = 2;
                this.add((Component)this.boxAdr, c);
                c.gridx = 0;
                ++c.gridy;
                this.add((Component)new JLabel(this.getLabelFor("ID_ADRESSE")), c);
                ++c.gridx;
                c.gridwidth = 0;
                this.addView("ID_ADRESSE");
                final DefaultElementSQLObject comp = (DefaultElementSQLObject)this.getView("ID_ADRESSE").getComp();
                this.componentPrincipaleAdr = (ElementSQLObject)this.getView("ID_ADRESSE");
                ((AdresseSQLComponent)this.componentPrincipaleAdr.getSQLChild()).setDestinataireVisible(true);
                final JCheckBox boxLivr = new JCheckBox("Livr\u00e9 par le fournisseur");
                this.add((Component)boxLivr, c);
                this.addSQLObject(boxLivr, "LIVRAISON_F");
                boxLivr.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (boxLivr.isSelected() && !comp.isCreated()) {
                            comp.setCreated(true);
                            CommandeSQLComponent.this.componentPrincipaleAdr.setEditable(InteractionMode.READ_WRITE);
                            if (CommandeSQLComponent.this.getTable().contains("ID_AFFAIRE")) {
                                SQLRow selectedRow = ((ElementComboBox)CommandeSQLComponent.this.getView("ID_AFFAIRE").getComp()).getSelectedRow();
                                SQLRowValues rowVals = CommandeSQLComponent.this.getLivraisonAdr(selectedRow);
                                comp.setValue(rowVals);
                                if (selectedRow != null && !selectedRow.isUndefined()) {
                                    SQLRow clientRow = selectedRow.getForeign("ID_CLIENT");
                                    Where w = new Where((FieldRef)CommandeSQLComponent.this.boxAdr.getRequest().getPrimaryTable().getField("ID_CLIENT"), "=", clientRow.getID());
                                    w = w.or(new Where((FieldRef)CommandeSQLComponent.this.boxAdr.getRequest().getPrimaryTable().getKey(), "=", clientRow.getInt("ID_ADRESSE")));
                                    w = w.or(new Where((FieldRef)CommandeSQLComponent.this.boxAdr.getRequest().getPrimaryTable().getKey(), "=", clientRow.getInt("ID_ADRESSE_L")));
                                    if (clientRow.getTable().contains("ID_ADRESSE_L_2")) {
                                        w = w.or(new Where((FieldRef)CommandeSQLComponent.this.boxAdr.getRequest().getPrimaryTable().getKey(), "=", clientRow.getInt("ID_ADRESSE_L_2")));
                                    }
                                    if (clientRow.getTable().contains("ID_ADRESSE_L_3")) {
                                        w = w.or(new Where((FieldRef)CommandeSQLComponent.this.boxAdr.getRequest().getPrimaryTable().getKey(), "=", clientRow.getInt("ID_ADRESSE_L_3")));
                                    }
                                    CommandeSQLComponent.this.boxAdr.getRequest().setWhere(w);
                                } else {
                                    CommandeSQLComponent.this.boxAdr.getRequest().setWhere(null);
                                }
                            }
                        } else if (!boxLivr.isSelected()) {
                            comp.setCreated(false);
                            CommandeSQLComponent.this.componentPrincipaleAdr.setEditable(InteractionMode.DISABLED);
                        }
                    }
                });
                ++c.gridy;
                this.add((Component)comp, c);
                this.add(this.getView("ID_ADRESSE").getComp(), c);
                comp.addValueListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        CommandeSQLComponent.this.boxAdr.setVisible(comp.isCreated());
                        labelAdrLiv.setVisible(comp.isCreated());
                    }
                });
                this.boxAdr.addValueListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        SQLRow selectedRow = CommandeSQLComponent.this.boxAdr.getSelectedRow();
                        if (selectedRow != null && !selectedRow.isUndefined()) {
                            SQLRowValues rowVals = selectedRow.asRowValues();
                            rowVals.clearPrimaryKeys();
                            comp.setValue(rowVals);
                        }
                    }
                });
                this.boxAdr.setVisible(false);
                labelAdrLiv.setVisible(false);
            } else {
                ++c.gridy;
                c.gridx = 0;
                this.add((Component)new JLabel(TM.tr((String)"address.type.delivery", (Object[])new Object[0]), 4), c);
                ++c.gridx;
                c.gridwidth = 0;
                this.add((Component)this.boxLivrClient, c);
                c.gridwidth = 1;
                DefaultGridBagConstraints cAdr = new DefaultGridBagConstraints();
                this.panelAdrSpec.add((Component)new JLabel(this.getLabelFor("ID_CLIENT"), 4), cAdr);
                final ElementComboBox boxClient = new ElementComboBox(true);
                cAdr.weightx = 1.0;
                ++cAdr.gridx;
                this.panelAdrSpec.add((Component)boxClient, cAdr);
                this.addView(boxClient, "ID_CLIENT");
                ++cAdr.gridy;
                cAdr.weightx = 0.0;
                cAdr.gridx = 0;
                this.panelAdrSpec.add((Component)new JLabel(TM.tr((String)"address", (Object[])new Object[0]), 4), cAdr);
                final SQLRequestComboBox boxAdr = new SQLRequestComboBox(true);
                boxAdr.uiInit(Configuration.getInstance().getDirectory().getElement(this.getTable().getTable("ADRESSE")).getComboRequest(true));
                boxClient.addModelListener("wantedID", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (boxClient.getSelectedRow() != null && !boxClient.getSelectedRow().isUndefined()) {
                            Where w = new Where((FieldRef)boxAdr.getRequest().getPrimaryTable().getField("ID_CLIENT"), "=", boxClient.getSelectedRow().getID());
                            w = w.or(new Where((FieldRef)boxAdr.getRequest().getPrimaryTable().getKey(), "=", boxClient.getSelectedRow().getInt("ID_ADRESSE")));
                            w = w.or(new Where((FieldRef)boxAdr.getRequest().getPrimaryTable().getKey(), "=", boxClient.getSelectedRow().getInt("ID_ADRESSE_F")));
                            w = w.or(new Where((FieldRef)boxAdr.getRequest().getPrimaryTable().getKey(), "=", boxClient.getSelectedRow().getInt("ID_ADRESSE_L")));
                            boxAdr.getRequest().setWhere(w);
                        } else {
                            boxAdr.getRequest().setWhere(null);
                        }
                    }
                });
                cAdr.weightx = 1.0;
                ++cAdr.gridx;
                this.panelAdrSpec.add((Component)boxAdr, cAdr);
                cAdr.gridx = 0;
                ++cAdr.gridy;
                cAdr.weightx = 0.0;
                if (this.getMode() == SQLComponent.Mode.MODIFICATION) {
                    this.panelAdrSpec.add((Component)new JLabel(this.getLabelFor("ID_ADRESSE")), cAdr);
                }
                ++cAdr.gridx;
                cAdr.gridwidth = 0;
                this.addView("ID_ADRESSE");
                this.compAdr = (DefaultElementSQLObject)this.getView("ID_ADRESSE").getComp();
                ++cAdr.gridy;
                if (this.getMode() == SQLComponent.Mode.MODIFICATION) {
                    this.panelAdrSpec.add((Component)this.compAdr, cAdr);
                }
                boxAdr.addValueListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        SQLRow row = boxAdr.getSelectedRow();
                        if (row != null && !row.isUndefined()) {
                            CommandeSQLComponent.this.compAdr.setCreated(true);
                            SQLRowValues asRowValues = new SQLRowValues(row.asRowValues());
                            CommandeSQLComponent.this.compAdr.setValue(asRowValues);
                        }
                    }
                });
                ++c.gridy;
                c.gridx = 0;
                c.gridwidth = 0;
                c.weightx = 1.0;
                this.add((Component)this.panelAdrSpec, c);
                c.gridwidth = 1;
                c.weightx = 0.0;
                this.boxLivrClient.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CommandeSQLComponent.this.panelAdrSpec.setVisible(CommandeSQLComponent.this.boxLivrClient.isSelected());
                        if (!CommandeSQLComponent.this.boxLivrClient.isSelected()) {
                            boxClient.setValue((Integer)null);
                            boxAdr.setValue((Integer)null);
                            CommandeSQLComponent.this.compAdr.setCreated(false);
                        }
                    }
                });
                this.panelAdrSpec.setVisible(false);
            }
        }
        c.gridwidth = 1;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        JPanel addP = ComptaSQLConfElement.createAdditionalPanel();
        this.setAdditionalFieldsPanel(new FormLayouter(addP, 2));
        this.add((Component)addP, c);
        ++c.gridy;
        c.gridwidth = 1;
        final ElementComboBox boxDevise = new ElementComboBox();
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            c.fill = 2;
            this.add((Component)new JLabel(this.getLabelFor("ID_DEVISE"), 4), c);
            ++c.gridx;
            c.gridwidth = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.fill = 0;
            DefaultGridBagConstraints.lockMinimumSize(boxDevise);
            this.add((Component)boxDevise, c);
            this.addView(boxDevise, "ID_DEVISE");
            this.fourn.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent arg0) {
                    if (CommandeSQLComponent.this.fourn.getSelectedRow() != null) {
                        boxDevise.setValue(CommandeSQLComponent.this.fourn.getSelectedRow().getForeignID("ID_DEVISE"));
                    } else {
                        boxDevise.setValue((SQLRowAccessor)null);
                    }
                }
            });
            if (this.getTable().contains("INCOTERM")) {
                ++c.gridx;
                c.weightx = 0.0;
                c.fill = 2;
                this.add((Component)new JLabel(this.getLabelFor("INCOTERM"), 4), c);
                ++c.gridx;
                c.gridwidth = 1;
                c.weightx = 1.0;
                c.weighty = 0.0;
                c.fill = 0;
                final ITextCombo box = new ITextCombo(ComboLockedMode.LOCKED);
                String[] stringArray = ReferenceArticleSQLElement.CONDITIONS;
                int n = ReferenceArticleSQLElement.CONDITIONS.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    box.addItem(s);
                    ++n2;
                }
                this.add((Component)box, c);
                this.addView(box, "INCOTERM", (Object)"required");
                box.addValueListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        CommandeSQLComponent.this.table.setIncoterms(box.getCurrentValue());
                    }
                });
            }
        }
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 2;
        c.anchor = 13;
        this.add((Component)new JLabel(this.getLabelFor("NOM"), 4), c);
        JTextField textNom = new JTextField();
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)textNom, c);
        String field = "ID_COMMERCIAL";
        c.weightx = 0.0;
        ++c.gridx;
        this.add((Component)new JLabel(this.getLabelFor(field), 4), c);
        ElementComboBox commSel = new ElementComboBox(false, 25);
        c.gridx = -1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        this.add((Component)commSel, c);
        this.addRequiredSQLObject(commSel, field);
        c.fill = 1;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridwidth = 4;
        this.add((Component)this.table, c);
        if (DefaultNXProps.getInstance().getBooleanValue("ArticleShowDevise", false)) {
            boxDevise.addValueListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    CommandeSQLComponent.this.table.setDevise(boxDevise.getSelectedRow());
                }
            });
        }
        this.fourn.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CommandeSQLComponent.this.table.setFournisseur(CommandeSQLComponent.this.fourn.getSelectedRow());
            }
        });
        ++c.gridy;
        c.weighty = 0.0;
        this.add((Component)this.getBottomPanel(), c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        c.anchor = 14;
        c.gridwidth = 0;
        this.panelOO = new PanelOOSQLComponent(this);
        this.add((Component)this.panelOO, c);
        this.addRequiredSQLObject(this.fourn, "ID_FOURNISSEUR");
        this.addSQLObject(textNom, "NOM");
        this.addRequiredSQLObject(this.dateCommande, "DATE");
        this.addRequiredSQLObject(this.numeroUniqueCommande, "NUMERO");
        this.addSQLObject(this.infos, "INFOS");
        this.numeroUniqueCommande.setText(NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass()));
        DefaultGridBagConstraints.lockMinimumSize(this.fourn);
        DefaultGridBagConstraints.lockMinimumSize(commSel);
    }

    protected SQLRowValues getLivraisonAdr(SQLRow rowAffaire) {
        if (rowAffaire != null) {
            SQLRow rowClient = rowAffaire.getForeignRow("ID_CLIENT");
            SQLRow rowAdrL = rowClient.getForeignRow("ID_ADRESSE_L");
            if (rowAdrL == null || rowAdrL.isUndefined()) {
                rowAdrL = rowClient.getForeignRow("ID_ADRESSE");
            }
            SQLRowValues rowVals = rowAdrL.asRowValues();
            rowVals.clearPrimaryKeys();
            return rowVals;
        }
        return new SQLRowValues(this.getTable().getTable("ADRESSE"));
    }

    private JPanel getBottomPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        c.weightx = 1.0;
        c.anchor = 17;
        c.fill = 2;
        panel.add((Component)new TitledSeparator(this.getLabelFor("INFOS")), c);
        ++c.gridy;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.fill = 1;
        JScrollPane scrollPane = new JScrollPane(this.infos);
        scrollPane.setBorder(null);
        panel.add((Component)scrollPane, c);
        DefaultProps props = DefaultNXProps.getInstance();
        Boolean b = props.getBooleanValue("ArticleShowPoids");
        final JTextField textPoidsTotal = new JTextField(8);
        JTextField poids = new JTextField();
        if (b.booleanValue()) {
            JPanel panelPoids = new JPanel(new GridBagLayout());
            DefaultGridBagConstraints cPoids = new DefaultGridBagConstraints();
            cPoids.weightx = 0.0;
            panelPoids.add((Component)new JLabel(this.getLabelFor("T_POIDS")), cPoids);
            cPoids.weightx = 1.0;
            textPoidsTotal.setEnabled(false);
            textPoidsTotal.setHorizontalAlignment(4);
            textPoidsTotal.setDisabledTextColor(Color.BLACK);
            ++cPoids.gridx;
            panelPoids.add((Component)textPoidsTotal, cPoids);
            ++c.gridx;
            c.gridy = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.gridheight = 2;
            c.fill = 0;
            c.anchor = 12;
            panel.add((Component)panelPoids, c);
            DefaultGridBagConstraints.lockMinimumSize(panelPoids);
            this.addSQLObject(textPoidsTotal, "T_POIDS");
        } else {
            this.addSQLObject(poids, "T_POIDS");
        }
        DeviseField textPortHT = new DeviseField();
        ElementComboBox comboTaxePort = new ElementComboBox(false, 10);
        if (this.getTable().contains("PORT_HT")) {
            this.addRequiredSQLObject(textPortHT, "PORT_HT");
            JPanel panelPoids = new JPanel(new GridBagLayout());
            DefaultGridBagConstraints cPort = new DefaultGridBagConstraints();
            cPort.gridx = 0;
            cPort.fill = 0;
            cPort.weightx = 0.0;
            panelPoids.add((Component)new JLabel(this.getLabelFor("PORT_HT")), cPort);
            textPortHT.setHorizontalAlignment(4);
            ++cPort.gridx;
            cPort.weightx = 1.0;
            panelPoids.add((Component)textPortHT, cPort);
            ++cPort.gridy;
            cPort.gridx = 0;
            cPort.weightx = 0.0;
            this.addRequiredSQLObject(comboTaxePort, "ID_TAXE_PORT");
            panelPoids.add((Component)new JLabel(this.getLabelFor("ID_TAXE_PORT")), cPort);
            ++cPort.gridx;
            cPort.weightx = 1.0;
            panelPoids.add((Component)comboTaxePort, cPort);
            ++c.gridx;
            c.gridy = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.gridheight = 2;
            c.fill = 0;
            c.anchor = 12;
            panel.add((Component)panelPoids, c);
            DefaultGridBagConstraints.lockMinimumSize(panelPoids);
        }
        DeviseField textRemiseHT = new DeviseField();
        DeviseField fieldHT = new DeviseField();
        DeviseField fieldEco = new DeviseField();
        DeviseField fieldTVA = new DeviseField();
        DeviseField fieldTTC = new DeviseField();
        DeviseField fieldDevise = new DeviseField();
        DeviseField fieldService = new DeviseField();
        fieldHT.setOpaque(false);
        fieldTVA.setOpaque(false);
        fieldTTC.setOpaque(false);
        fieldService.setOpaque(false);
        this.addRequiredSQLObject(fieldEco, "T_ECO_CONTRIBUTION");
        this.addRequiredSQLObject(fieldDevise, "T_DEVISE");
        this.addRequiredSQLObject(fieldHT, "T_HT");
        this.addRequiredSQLObject(fieldTVA, "T_TVA");
        this.addRequiredSQLObject(fieldTTC, "T_TTC");
        this.addRequiredSQLObject(fieldService, "T_SERVICE");
        this.allowEditable("T_ECO_CONTRIBUTION", false);
        this.allowEditable("T_HT", false);
        this.allowEditable("T_TVA", false);
        this.allowEditable("T_TTC", false);
        this.allowEditable("T_SERVICE", false);
        final TotalPanel totalTTC = new TotalPanel(this.table, fieldEco, fieldHT, fieldTVA, fieldTTC, textPortHT, textRemiseHT, fieldService, null, fieldDevise, null, null, this.getTable().contains("ID_TAXE_PORT") ? comboTaxePort : null, null);
        ++c.gridx;
        --c.gridy;
        c.gridwidth = 0;
        c.gridheight = 2;
        c.anchor = 12;
        c.fill = 1;
        c.weighty = 0.0;
        c.weightx = 0.0;
        DefaultGridBagConstraints.lockMinimumSize(totalTTC);
        panel.add((Component)totalTTC, c);
        c.gridy += 3;
        c.gridheight = 2;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)this.getModuleTotalPanel(), c);
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                textPoidsTotal.setText(String.valueOf(CommandeSQLComponent.this.table.getPoidsTotal()));
            }
        });
        textPortHT.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }
        });
        comboTaxePort.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                totalTTC.updateTotal();
            }
        });
        textRemiseHT.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                totalTTC.updateTotal();
            }
        });
        return panel;
    }

    protected JPanel getModuleTotalPanel() {
        return AutoHideListener.listen(new JPanel());
    }

    @Override
    public int insert(SQLRow order) {
        String num;
        int idCommande = this.getSelectedID();
        int attempt = 0;
        if (!this.numeroUniqueCommande.checkValidation(false)) {
            while (attempt < JUniqueTextField.RETRY_COUNT) {
                num = NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass(), this.dateCommande.getDate());
                this.numeroUniqueCommande.setText(num);
                ++attempt;
                if (this.numeroUniqueCommande.checkValidation(false)) {
                    System.err.println("ATEMPT " + attempt + " SUCCESS WITH NUMERO " + num);
                    break;
                }
                try {
                    Thread.sleep(JUniqueTextField.SLEEP_WAIT_MS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        num = this.numeroUniqueCommande.getText();
        if (attempt == JUniqueTextField.RETRY_COUNT) {
            idCommande = this.getSelectedID();
            ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de commande existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
        } else {
            idCommande = super.insert(order);
            this.table.updateField("ID_COMMANDE", idCommande);
            this.table.createArticle(idCommande, this.getElement());
            try {
                this.updateStock(idCommande);
            }
            catch (SQLException e) {
                ExceptionHandler.handle("Erreur lors de la mise \u00e0 jour du stock!", e);
            }
            CommandeXmlSheet sheet = new CommandeXmlSheet(this.getTable().getRow(idCommande));
            sheet.createDocumentAsynchronous();
            sheet.showPrintAndExportAsynchronous(this.panelOO.isVisualisationSelected(), this.panelOO.isImpressionSelected(), true);
            if (NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass()).equalsIgnoreCase(this.numeroUniqueCommande.getText().trim())) {
                SQLRowValues rowVals = new SQLRowValues(this.tableNum);
                int val = this.tableNum.getRow(2).getInt(NumerotationAutoSQLElement.getLabelNumberFor(this.getElement().getClass()));
                rowVals.put(NumerotationAutoSQLElement.getLabelNumberFor(this.getElement().getClass()), new Integer(++val));
                try {
                    rowVals.update(2);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (attempt > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(null, "Le num\u00e9ro a \u00e9t\u00e9 actualis\u00e9 en " + num);
                    }
                });
            }
        }
        return idCommande;
    }

    @Override
    public void select(SQLRowAccessor r) {
        if (!this.getTable().contains("LIVRAISON_F") && r != null && !r.isUndefined()) {
            SQLRowAccessor adr = r.getFields().contains("ID_ADRESSE") ? r.getForeign("ID_ADRESSE") : null;
            this.boxLivrClient.setSelected(adr != null && !adr.isUndefined());
            this.panelAdrSpec.setVisible(this.boxLivrClient.isSelected());
            if (!this.boxLivrClient.isSelected()) {
                this.compAdr.setCreated(false);
            }
        }
        if (this.getTable().contains("LIVRAISON_F") && this.componentPrincipaleAdr != null) {
            boolean bLivraison = r != null && r.getFields().contains("ID_ADRESSE") && !r.isForeignEmpty("ID_ADRESSE");
            this.componentPrincipaleAdr.setEditable(bLivraison ? InteractionMode.READ_WRITE : InteractionMode.DISABLED);
        }
        super.select(r);
        if (r != null) {
            this.table.insertFrom("ID_COMMANDE", r.getID());
        }
    }

    @Override
    public void update() {
        if (!this.numeroUniqueCommande.checkValidation()) {
            ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de commande client existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
            return;
        }
        super.update();
        final int id = this.getSelectedID();
        this.table.updateField("ID_COMMANDE", id);
        this.table.createArticle(id, this.getElement());
        ComptaPropsConfiguration.getInstanceCompta().getNonInteractiveSQLExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    CommandeSQLComponent.this.updateStock(id);
                }
                catch (Exception e) {
                    ExceptionHandler.handle("Update error", e);
                }
            }
        });
        CommandeXmlSheet sheet = new CommandeXmlSheet(this.getTable().getRow(id));
        sheet.createDocumentAsynchronous();
        sheet.showPrintAndExportAsynchronous(this.panelOO.isVisualisationSelected(), this.panelOO.isImpressionSelected(), true);
    }

    protected String getLibelleStock(SQLRowAccessor row, SQLRowAccessor rowElt) {
        return "Commande fournisseur N\u00b0" + row.getString("NUMERO");
    }

    private void updateStock(int id) throws SQLException {
        SQLRow row = this.getTable().getRow(id);
        StockItemsUpdater stockUpdater = new StockItemsUpdater(new StockLabel(){

            @Override
            public String getLabel(SQLRowAccessor rowOrigin, SQLRowAccessor rowElt) {
                return CommandeSQLComponent.this.getLibelleStock(rowOrigin, rowElt);
            }
        }, row, (List<? extends SQLRowAccessor>)row.getReferentRows(this.getTable().getTable("COMMANDE_ELEMENT")), StockItemsUpdater.TypeStockUpdate.VIRTUAL_RECEPT);
        stockUpdater.update();
    }

    public void setDefaults() {
        this.resetValue();
        this.numeroUniqueCommande.setText(NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass()));
        this.table.getModel().clearRows();
    }

    @Override
    protected SQLRowValues createDefaults() {
        SQLRowValues rowVals = new SQLRowValues(this.getTable());
        rowVals.put("T_POIDS", Float.valueOf(0.0f));
        rowVals.put("EN_COURS", Boolean.TRUE);
        SQLElement eltComm = Configuration.getInstance().getDirectory().getElement("COMMERCIAL");
        int idUser = UserManager.getInstance().getCurrentUser().getId();
        SQLRow rowsComm = SQLBackgroundTableCache.getInstance().getCacheForTable(eltComm.getTable()).getFirstRowContains(idUser, eltComm.getTable().getField("ID_USER_COMMON"));
        if (rowsComm != null) {
            rowVals.put("ID_COMMERCIAL", rowsComm.getID());
        }
        rowVals.put("T_HT", 0L);
        rowVals.put("T_SERVICE", 0L);
        rowVals.put("T_DEVISE", 0L);
        rowVals.put("T_TVA", 0L);
        rowVals.put("T_TTC", 0L);
        rowVals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass()));
        if (this.getTable().contains("ID_TAXE_PORT")) {
            rowVals.put("ID_TAXE_PORT", TaxeCache.getCache().getFirstTaxe().getID());
        }
        if (this.getTable().contains("LIVRAISON_F") && this.componentPrincipaleAdr != null) {
            this.componentPrincipaleAdr.setEditable(InteractionMode.DISABLED);
        }
        return rowVals;
    }

    public CommandeItemTable getRowValuesTablePanel() {
        return this.table;
    }

    @Override
    public RowValuesTable getRowValuesTable() {
        return this.table.getRowValuesTable();
    }

    public void loadCommande(int idCommande) {
        SQLElement commande = Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT");
        SQLElement commandeElt = Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT_ELEMENT");
        if (idCommande > 1) {
            SQLInjector injector = SQLInjector.getInjector(commande.getTable(), this.getTable());
            this.select(injector.createRowValuesFrom(idCommande));
        }
        this.loadItem(this.table, commande, idCommande, commandeElt);
    }

    public void loadDevis(int idDevis) {
        SQLElement devis = Configuration.getInstance().getDirectory().getElement("DEVIS");
        SQLElement devisElt = Configuration.getInstance().getDirectory().getElement("DEVIS_ELEMENT");
        if (idDevis > 1) {
            SQLInjector injector = SQLInjector.getInjector(devis.getTable(), this.getTable());
            this.select(injector.createRowValuesFrom(idDevis));
        }
        this.loadItem(this.table, devis, idDevis, devisElt);
    }

    public void loadFacture(int idFact) {
        SQLElement facture = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
        SQLElement factureElt = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE_ELEMENT");
        if (idFact > 1) {
            SQLInjector injector = SQLInjector.getInjector(facture.getTable(), this.getTable());
            this.select(injector.createRowValuesFrom(idFact));
        }
        this.loadItem(this.table, facture, idFact, factureElt);
    }

    @Override
    protected void refreshAfterSelect(SQLRowAccessor rSource) {
        if (this.dateCommande.getValue() != null) {
            this.table.setDateDevise(this.dateCommande.getValue());
        }
    }
}

