/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.quote.ui;

import com.ibm.icu.math.BigDecimal;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.AbstractArticleItemTable;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.common.ui.TotalPanel;
import org.openconcerto.erp.core.sales.quote.report.DevisXmlSheet;
import org.openconcerto.erp.core.sales.quote.ui.DevisItemTable;
import org.openconcerto.erp.panel.PanelOOSQLComponent;
import org.openconcerto.map.ui.ITextComboVilleViewer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.GroupSQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.sqlobject.JUniqueTextField;
import org.openconcerto.sql.ui.RadioButtons;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.checks.ValidState;

public class QuoteSQLComponent
extends GroupSQLComponent {
    public static final String ID = "sales.quote";
    protected DevisItemTable table = new DevisItemTable();
    private JUniqueTextField numeroUniqueDevis;
    private final SQLTable tableNum = this.getTable().getBase().getTable("NUMEROTATION_AUTO");
    private final ITextArea infos = new ITextArea();
    private final RadioButtons radioEtat = new RadioButtons("NOM");
    private JTextField textPourcentRemise;
    private JTextField textPoidsTotal;
    private DeviseField textRemiseHT;
    private DeviseField fieldHT;
    private PanelOOSQLComponent panelOO;
    final JTextField telSite = new JTextField(20);
    final ITextComboVilleViewer villeSite = new ITextComboVilleViewer();
    final JTextField faxSite = new JTextField(20);
    final JTextField telPSite = new JTextField(20);
    final JTextField mailSite = new JTextField(20);
    final JTextField contactSite = new JTextField(20);
    final JTextField desSite = new JTextField(20);
    final ITextArea adrSite = new ITextArea();
    final JTextField telDonneur = new JTextField(20);
    final JTextField sirenDonneur = new JTextField(20);
    final ITextComboVilleViewer villeDonneur = new ITextComboVilleViewer();
    final JTextField faxDonneur = new JTextField(20);
    final JTextField telPDonneur = new JTextField(20);
    final JTextField mailDonneur = new JTextField(20);
    final JTextField contactDonneur = new JTextField(20);
    final JTextField desDonneur = new JTextField(20);
    final ITextArea adrDonneur = new ITextArea();
    private ValidState validStateContact = ValidState.getTrueInstance();

    public QuoteSQLComponent(SQLElement element) {
        super(element);
    }

    @Override
    public Set<String> getPartialResetNames() {
        HashSet<String> s = new HashSet<String>();
        s.add("OBJET");
        s.add("NUMERO");
        return s;
    }

    @Override
    public JComponent createEditor(String id) {
        if (id.equals("sales.quote.number")) {
            this.numeroUniqueDevis = new JUniqueTextField(15);
            return this.numeroUniqueDevis;
        }
        if (id.equals("panel.oo")) {
            this.panelOO = new PanelOOSQLComponent(this);
            return this.panelOO;
        }
        if (id.equals("DATE")) {
            return new JDate(true);
        }
        if (id.equals("sales.quote.state")) {
            return new RadioButtons("NOM");
        }
        if (id.equals("sales.quote.items.list")) {
            return this.table;
        }
        if (id.equals("T_POIDS")) {
            return new JTextField(10);
        }
        if (id.equals("sales.quote.total.amount")) {
            AbstractArticleItemTable items = (AbstractArticleItemTable)this.getEditor("sales.quote.items.list");
            DeviseField totalHT = (DeviseField)this.getEditor("T_HT");
            DeviseField totalService = (DeviseField)this.getEditor("T_SERVICE");
            DeviseField totalSupply = this.getTable().contains("PREBILAN") ? (DeviseField)this.getEditor("PREBILAN") : (DeviseField)this.getEditor("T_HA");
            DeviseField totalDevise = (DeviseField)this.getEditor("T_DEVISE");
            JTextField totalWeight = (JTextField)this.getEditor("T_POIDS");
            DeviseField totalTTC = (DeviseField)this.getEditor("T_TTC");
            DeviseField totalTVA = (DeviseField)this.getEditor("T_TVA");
            DeviseField totalRemise = (DeviseField)this.getEditor("REMISE_HT");
            DeviseField totalPORT = (DeviseField)this.getEditor("PORT_HT");
            DeviseField totalEco = (DeviseField)this.getEditor("T_ECO_CONTRIBUTION");
            return new TotalPanel(items, totalEco, totalHT, totalTVA, totalTTC, totalRemise, totalPORT, totalService, totalSupply, totalDevise, totalWeight, null);
        }
        if (id.startsWith("T_")) {
            return new DeviseField();
        }
        if (id.equals("REMISE_HT") || id.equals("PORT_HT") || id.equals("PREBILAN")) {
            return new DeviseField();
        }
        if (id.equals("sales.quote.info.general")) {
            return new ITextArea(4, 40);
        }
        return super.createEditor(id);
    }

    @Override
    public synchronized ValidState getValidState() {
        assert (SwingUtilities.isEventDispatchThread());
        return super.getValidState().and(this.validStateContact);
    }

    private JPanel createPanelDiff(final Type_Diff type) {
        DefaultGridBagConstraints cTabSite = new DefaultGridBagConstraints();
        JPanel tabSite = new JPanel(new GridBagLayout());
        cTabSite.weightx = 1.0;
        cTabSite.fill = 2;
        cTabSite.gridwidth = 2;
        String name = type.getName();
        final JCheckBox boxSiteDiff = new JCheckBox(this.getLabelFor(String.valueOf(name) + "_DIFF"));
        tabSite.add((Component)boxSiteDiff, cTabSite);
        this.addView(boxSiteDiff, String.valueOf(name) + "_DIFF");
        String fieldSiren = "SIREN_" + name;
        if (this.getTable().contains(fieldSiren)) {
            JLabel labelSrenSite = new JLabel(this.getLabelFor(fieldSiren));
            labelSrenSite.setHorizontalAlignment(4);
            cTabSite.gridwidth = 1;
            cTabSite.gridx = 2;
            cTabSite.weightx = 0.0;
            tabSite.add((Component)labelSrenSite, cTabSite);
            ++cTabSite.gridx;
            cTabSite.weightx = 1.0;
            if (type == Type_Diff.SITE) {
                throw new IllegalArgumentException("Le siren n'est pas \u00e0 renseign\u00e9 pour le site");
            }
            JTextField siren = this.sirenDonneur;
            tabSite.add((Component)siren, cTabSite);
            this.addView(siren, fieldSiren);
            DefaultGridBagConstraints.lockMinimumSize(siren);
        }
        ++cTabSite.gridy;
        cTabSite.gridx = 0;
        cTabSite.weightx = 0.0;
        cTabSite.fill = 2;
        cTabSite.gridwidth = 1;
        JLabel labelSiteDes = new JLabel(this.getLabelFor("DESIGNATION_" + name));
        labelSiteDes.setHorizontalAlignment(4);
        tabSite.add((Component)labelSiteDes, cTabSite);
        ++cTabSite.gridx;
        cTabSite.weightx = 1.0;
        JTextField designation = type == Type_Diff.SITE ? this.desSite : this.desDonneur;
        tabSite.add((Component)designation, cTabSite);
        this.addView(designation, "DESIGNATION_" + name);
        DefaultGridBagConstraints.lockMinimumSize(designation);
        JLabel labelTelSite = new JLabel(this.getLabelFor("TEL_" + name));
        labelTelSite.setHorizontalAlignment(4);
        ++cTabSite.gridx;
        cTabSite.weightx = 0.0;
        tabSite.add((Component)labelTelSite, cTabSite);
        ++cTabSite.gridx;
        cTabSite.weightx = 1.0;
        JTextField tel = type == Type_Diff.SITE ? this.telSite : this.telDonneur;
        tabSite.add((Component)tel, cTabSite);
        this.addView(tel, "TEL_" + name);
        DefaultGridBagConstraints.lockMinimumSize(tel);
        JLabel labelSiteAdr = new JLabel(this.getLabelFor("ADRESSE_" + name));
        labelSiteAdr.setHorizontalAlignment(4);
        ++cTabSite.gridy;
        cTabSite.gridx = 0;
        cTabSite.weightx = 0.0;
        tabSite.add((Component)labelSiteAdr, cTabSite);
        ++cTabSite.gridx;
        cTabSite.weightx = 1.0;
        ITextArea adresse = type == Type_Diff.SITE ? this.adrSite : this.adrDonneur;
        tabSite.add((Component)adresse, cTabSite);
        this.addView(adresse, "ADRESSE_" + name);
        DefaultGridBagConstraints.lockMinimumSize(adresse);
        JLabel labelTelPSite = new JLabel(this.getLabelFor("TEL_P_" + name));
        labelTelPSite.setHorizontalAlignment(4);
        ++cTabSite.gridx;
        cTabSite.weightx = 0.0;
        tabSite.add((Component)labelTelPSite, cTabSite);
        ++cTabSite.gridx;
        cTabSite.weightx = 1.0;
        JTextField telP = type == Type_Diff.SITE ? this.telPSite : this.telPDonneur;
        tabSite.add((Component)telP, cTabSite);
        this.addView(telP, "TEL_P_" + name);
        ++cTabSite.gridy;
        cTabSite.gridx = 0;
        cTabSite.weightx = 0.0;
        JLabel labelVilleAdr = new JLabel(this.getLabelFor("VILLE_" + name));
        labelVilleAdr.setHorizontalAlignment(4);
        tabSite.add((Component)labelVilleAdr, cTabSite);
        ++cTabSite.gridx;
        cTabSite.weightx = 1.0;
        ITextComboVilleViewer ville = type == Type_Diff.SITE ? this.villeSite : this.villeDonneur;
        tabSite.add((Component)ville, cTabSite);
        this.addView(ville, "VILLE_" + name);
        DefaultGridBagConstraints.lockMinimumSize(ville);
        ++cTabSite.gridx;
        cTabSite.weightx = 0.0;
        JLabel labelFaxSite = new JLabel(this.getLabelFor("FAX_" + name));
        labelFaxSite.setHorizontalAlignment(4);
        tabSite.add((Component)labelFaxSite, cTabSite);
        ++cTabSite.gridx;
        cTabSite.weightx = 1.0;
        JTextField fax = type == Type_Diff.SITE ? this.faxSite : this.faxDonneur;
        tabSite.add((Component)fax, cTabSite);
        this.addView(fax, "FAX_" + name);
        DefaultGridBagConstraints.lockMinimumSize(fax);
        ++cTabSite.gridy;
        cTabSite.gridx = 0;
        cTabSite.weightx = 0.0;
        JLabel labelContactSite = new JLabel(this.getLabelFor("CONTACT_" + name));
        labelContactSite.setHorizontalAlignment(4);
        tabSite.add((Component)labelContactSite, cTabSite);
        ++cTabSite.gridx;
        cTabSite.weightx = 1.0;
        JTextField contact = type == Type_Diff.SITE ? this.contactSite : this.contactDonneur;
        tabSite.add((Component)contact, cTabSite);
        this.addView(contact, "CONTACT_" + name);
        ++cTabSite.gridx;
        cTabSite.weightx = 0.0;
        JLabel labelMailSite = new JLabel(this.getLabelFor("MAIL_" + name));
        labelMailSite.setHorizontalAlignment(4);
        tabSite.add((Component)labelMailSite, cTabSite);
        ++cTabSite.gridx;
        cTabSite.weightx = 1.0;
        JTextField mail = type == Type_Diff.SITE ? this.mailSite : this.mailDonneur;
        tabSite.add((Component)mail, cTabSite);
        this.addView(mail, "MAIL_" + name);
        boxSiteDiff.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = boxSiteDiff.isSelected();
                QuoteSQLComponent.this.setSiteEnabled(selected, type);
                if (!selected) {
                    QuoteSQLComponent.this.clearFieldDiff(type);
                }
            }
        });
        return tabSite;
    }

    private void clearFieldDiff(Type_Diff type) {
        if (type == Type_Diff.SITE) {
            this.desSite.setText("");
            this.adrSite.setText("");
            this.villeSite.setValue(null);
            this.telPSite.setText("");
            this.telSite.setText("");
            this.mailSite.setText("");
            this.contactSite.setText("");
            this.faxSite.setText("");
        } else {
            this.sirenDonneur.setText("");
            this.desDonneur.setText("");
            this.adrDonneur.setText("");
            this.villeDonneur.setValue(null);
            this.telPDonneur.setText("");
            this.telDonneur.setText("");
            this.mailDonneur.setText("");
            this.contactDonneur.setText("");
            this.faxDonneur.setText("");
        }
    }

    private void setSiteEnabled(boolean b, Type_Diff type) {
        if (type == Type_Diff.SITE) {
            this.desSite.setEditable(b);
            this.adrSite.setEditable(b);
            this.villeSite.setEnabled(b);
            this.telPSite.setEditable(b);
            this.telSite.setEditable(b);
            this.mailSite.setEditable(b);
            this.contactSite.setEditable(b);
            this.faxSite.setEditable(b);
        } else {
            b = false;
            this.sirenDonneur.setEditable(b);
            this.desDonneur.setEditable(b);
            this.adrDonneur.setEditable(b);
            this.villeDonneur.setEnabled(b);
            this.telPDonneur.setEditable(b);
            this.telDonneur.setEditable(b);
            this.mailDonneur.setEditable(b);
            this.contactDonneur.setEditable(b);
            this.faxDonneur.setEditable(b);
        }
    }

    @Override
    protected SQLRowValues createDefaults() {
        System.err.println("Create defaults");
        SQLRowValues rowVals = new SQLRowValues(this.getTable());
        rowVals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass()));
        SQLElement eltComm = Configuration.getInstance().getDirectory().getElement("COMMERCIAL");
        int idUser = UserManager.getInstance().getCurrentUser().getId();
        SQLRow rowsComm = SQLBackgroundTableCache.getInstance().getCacheForTable(eltComm.getTable()).getFirstRowContains(idUser, eltComm.getTable().getField("ID_USER_COMMON"));
        if (rowsComm != null) {
            rowVals.put("ID_COMMERCIAL", rowsComm.getID());
        }
        if (this.getTable().getUndefinedID() == -1) {
            rowVals.put("ID_ETAT_DEVIS", 2);
        } else {
            SQLRowValues foreign = UndefinedRowValuesCache.getInstance().getDefaultRowValues(this.getTable());
            if (foreign != null && !foreign.isUndefined()) {
                rowVals.put("ID_ETAT_DEVIS", foreign.getObject("ID_ETAT_DEVIS"));
            } else {
                rowVals.put("ID_ETAT_DEVIS", 2);
            }
        }
        rowVals.put("DATE", new Date());
        rowVals.put("T_ECO_CONTRIBUTION", BigDecimal.ZERO);
        rowVals.put("T_HT", 0L);
        rowVals.put("T_TVA", 0L);
        rowVals.put("T_SERVICE", 0L);
        rowVals.put("T_TTC", 0L);
        if (this.getTable().getFieldsName().contains("DATE_VALIDITE")) {
            Calendar cal = Calendar.getInstance();
            cal.add(2, 1);
            rowVals.put("DATE_VALIDITE", cal.getTime());
        }
        return rowVals;
    }

    private void calculPourcentage() {
        String remiseP = this.textPourcentRemise.getText().replace(',', '.');
        Long totalHT = this.fieldHT.getValue();
        Long remiseHT = this.textRemiseHT.getValue();
        totalHT = totalHT == null ? Long.valueOf(0L) : totalHT;
        remiseHT = remiseHT == null ? Long.valueOf(0L) : remiseHT;
        try {
            int valueRemise = Integer.valueOf(remiseP);
            long remise = (long)valueRemise * (totalHT + remiseHT) / 100L;
            if (remiseHT != remise) {
                this.textRemiseHT.setValue(remise);
            }
        }
        catch (NumberFormatException e) {
            ExceptionHandler.handle("Erreur durant le calcul de la remise", e);
        }
    }

    @Override
    protected void addViews() {
        super.addViews();
        DeviseField totalHT = (DeviseField)this.getEditor("T_HT");
        DeviseField totalEco = (DeviseField)this.getEditor("T_ECO_CONTRIBUTION");
        DeviseField totalService = (DeviseField)this.getEditor("T_SERVICE");
        DeviseField totalSupply = (DeviseField)this.getEditor("T_HA");
        DeviseField totalDevise = (DeviseField)this.getEditor("T_DEVISE");
        JTextField totalWeight = (JTextField)this.getEditor("T_POIDS");
        DeviseField totalTTC = (DeviseField)this.getEditor("T_TTC");
        DeviseField totalTVA = (DeviseField)this.getEditor("T_TVA");
        DeviseField totalRemise = (DeviseField)this.getEditor("REMISE_HT");
        DeviseField totalPORT = (DeviseField)this.getEditor("PORT_HT");
        if (this.getTable().contains("PREBILAN")) {
            this.addView(this.getEditor("PREBILAN"), "PREBILAN");
        }
        this.addView(totalPORT, "PORT_HT");
        this.addView(totalEco, "T_ECO_CONTRIBUTION");
        this.addView(totalRemise, "REMISE_HT");
        this.addView(totalTVA, "T_TVA");
        this.addView(totalTTC, "T_TTC");
        this.addView(totalWeight, "T_POIDS");
        this.addView(totalDevise, "T_DEVISE");
        this.addView(totalSupply, "T_HA");
        this.addView(totalService, "T_SERVICE");
        this.addView(totalHT, "T_HT");
    }

    @Override
    public JComponent getLabel(String id) {
        if (id.equals("sales.quote.total.amount")) {
            return new JLabel();
        }
        if (id.equals("panel.oo")) {
            return new JLabel();
        }
        return super.getLabel(id);
    }

    @Override
    public int insert(SQLRow order) {
        int idDevis;
        if (this.numeroUniqueDevis.checkValidation()) {
            idDevis = super.insert(order);
            this.table.updateField("ID_DEVIS", idDevis);
            this.table.createArticle(idDevis, this.getElement());
            try {
                DevisXmlSheet sheet = new DevisXmlSheet(this.getTable().getRow(idDevis));
                sheet.createDocumentAsynchronous();
                sheet.showPrintAndExportAsynchronous(this.panelOO.isVisualisationSelected(), this.panelOO.isImpressionSelected(), true);
            }
            catch (Exception e) {
                ExceptionHandler.handle("Impossible de cr\u00e9er le devis", e);
            }
            if (NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass()).equalsIgnoreCase(this.numeroUniqueDevis.getText().trim())) {
                SQLRowValues rowVals = new SQLRowValues(this.tableNum);
                int val = this.tableNum.getRow(2).getInt(NumerotationAutoSQLElement.getLabelNumberFor(this.getElement().getClass()));
                rowVals.put(NumerotationAutoSQLElement.getLabelNumberFor(this.getElement().getClass()), new Integer(++val));
                try {
                    rowVals.update(2);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        } else {
            idDevis = this.getSelectedID();
            ExceptionHandler.handle("Impossible d'ajouter, num\u00e9ro de devis existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
        }
        return idDevis;
    }

    @Override
    public void select(SQLRowAccessor r) {
        if (r == null || r.getIDNumber() == null) {
            super.select(r);
        } else {
            System.err.println(r);
            SQLRowValues rVals = r.asRowValues().deepCopy();
            SQLRowValues vals = new SQLRowValues(r.getTable());
            vals.load(rVals, CollectionUtils.createSet("ID_CLIENT"));
            vals.setID(rVals.getID());
            System.err.println("Select CLIENT");
            super.select(vals);
            rVals.remove("ID_CLIENT");
            super.select(rVals);
        }
        if (r != null) {
            this.table.insertFrom("ID_DEVIS", r.getID());
            if (this.getTable().contains("SITE_DIFF")) {
                this.setSiteEnabled(r.getBoolean("SITE_DIFF"), Type_Diff.SITE);
            }
            if (this.getTable().contains("DONNEUR_DIFF")) {
                this.setSiteEnabled(r.getBoolean("DONNEUR_DIFF"), Type_Diff.DONNEUR_ORDRE);
            }
        }
    }

    @Override
    public void update() {
        if (!this.numeroUniqueDevis.checkValidation()) {
            ExceptionHandler.handle("Impossible de modifier, num\u00e9ro de devis existant.");
            Component root = SwingUtilities.getRoot(this);
            if (root instanceof EditFrame) {
                EditFrame frame = (EditFrame)root;
                frame.getPanel().setAlwaysVisible(true);
            }
            return;
        }
        super.update();
        this.table.updateField("ID_DEVIS", this.getSelectedID());
        this.table.createArticle(this.getSelectedID(), this.getElement());
        try {
            DevisXmlSheet sheet = new DevisXmlSheet(this.getTable().getRow(this.getSelectedID()));
            sheet.createDocumentAsynchronous();
            sheet.showPrintAndExportAsynchronous(this.panelOO.isVisualisationSelected(), this.panelOO.isImpressionSelected(), true);
        }
        catch (Exception e) {
            ExceptionHandler.handle("Impossible de cr\u00e9er le devis", e);
        }
    }

    public void loadDevisExistant(int idDevis) {
        Collection myListItem;
        SQLElement devis = Configuration.getInstance().getDirectory().getElement("DEVIS");
        SQLElement devisElt = Configuration.getInstance().getDirectory().getElement("DEVIS_ELEMENT");
        if (idDevis > 1) {
            SQLRow row = devis.getTable().getRow(idDevis);
            SQLRowValues rowVals = new SQLRowValues(devis.getTable());
            rowVals.put("ID_CLIENT", row.getInt("ID_CLIENT"));
            rowVals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(this.getElement().getClass()));
            this.select(rowVals);
        }
        if ((myListItem = devis.getTable().getRow(idDevis).getReferentRows(devisElt.getTable())).size() != 0) {
            this.table.getModel().clearRows();
            for (SQLRow rowElt : myListItem) {
                SQLRowValues rowVals = rowElt.createUpdateRow();
                rowVals.clearPrimaryKeys();
                this.table.getModel().addRow(rowVals);
                int rowIndex = this.table.getModel().getRowCount() - 1;
                this.table.getModel().fireTableModelModified(rowIndex);
            }
        } else {
            this.table.getModel().clearRows();
        }
        this.table.getModel().fireTableDataChanged();
        this.table.repaint();
    }

    private static enum Type_Diff {
        SITE("SITE"),
        DONNEUR_ORDRE("DONNEUR");

        private final String name;

        private Type_Diff(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

