/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openconcerto.erp.core.sales.pos.POSConfiguration;
import org.openconcerto.erp.core.sales.pos.TicketPrinterConfiguration;
import org.openconcerto.erp.core.sales.pos.io.TicketPrinter;
import org.openconcerto.erp.core.sales.pos.model.Ticket;
import org.openconcerto.erp.core.sales.pos.ui.CaisseFrame;
import org.openconcerto.erp.core.sales.pos.ui.POSButton;
import org.openconcerto.erp.core.sales.pos.ui.StatusBar;
import org.openconcerto.erp.core.sales.pos.ui.TextAreaTicketPrinter;
import org.openconcerto.erp.core.sales.pos.ui.TicketCellRenderer;
import org.openconcerto.ui.DefaultListModel;
import org.openconcerto.ui.touch.ScrollableList;
import org.openconcerto.utils.ExceptionHandler;

public class ListeDesTicketsPanel
extends JPanel
implements ListSelectionListener {
    private static final String ARIAL_FONT = "Arial";
    private JList l;
    private CaisseFrame frame;
    private TextAreaTicketPrinter ticketP;
    private ScrollableList ticketList;
    private DefaultListModel ticketLlistModel;

    ListeDesTicketsPanel(CaisseFrame caisseFrame) {
        this.frame = caisseFrame;
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        StatusBar p = new StatusBar();
        p.setTitle("Liste des tickets");
        p.setLayout(new FlowLayout(2));
        POSButton bBack = new POSButton("Fermer");
        p.add(bBack);
        this.add((Component)p, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weighty = 1.0;
        c.gridheight = 2;
        this.ticketLlistModel = new DefaultListModel();
        try {
            this.ticketLlistModel.addAll(this.frame.getFiles().getLastLog().parseReceipts());
        }
        catch (Exception exn) {
            ExceptionHandler.handle(this.frame, "Impossible de charger les tickets", exn);
        }
        final Font f = new Font(ARIAL_FONT, 0, 24);
        this.ticketList = new ScrollableList(this.ticketLlistModel){

            @Override
            public void paintCell(Graphics g, Object object, int index, boolean isSelected, int posY) {
                g.setFont(f);
                if (isSelected) {
                    g.setColor(new Color(232, 242, 254));
                } else {
                    g.setColor(Color.WHITE);
                }
                g.fillRect(0, posY, this.getWidth(), this.getCellHeight());
                g.setColor(Color.GRAY);
                g.drawLine(0, posY + this.getCellHeight() - 1, this.getWidth(), posY + this.getCellHeight() - 1);
                if (isSelected) {
                    g.setColor(Color.BLACK);
                } else {
                    g.setColor(Color.GRAY);
                }
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Ticket article = (Ticket)object;
                String label = "Ticket " + article.getCode();
                String euro = String.valueOf(TicketCellRenderer.centsToString(article.getTotalInCents())) + "\u00e2\u201a\u00ac";
                int wEuro = (int)g.getFontMetrics().getStringBounds(euro, g).getWidth();
                g.drawString(label, 10, posY + 39);
                g.drawString(euro, this.getWidth() - 5 - wEuro, posY + 39);
            }
        };
        this.add((Component)this.ticketList, c);
        c.fill = 3;
        ++c.gridx;
        c.gridheight = 1;
        c.insets = new Insets(10, 10, 10, 10);
        this.ticketP = new TextAreaTicketPrinter();
        JScrollPane scrollPane = new JScrollPane(this.ticketP);
        scrollPane.setPreferredSize(new Dimension(400, 200));
        scrollPane.setMinimumSize(new Dimension(400, 200));
        this.add((Component)scrollPane, c);
        this.ticketList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Object selectedValue = ListeDesTicketsPanel.this.ticketList.getSelectedValue();
                ListeDesTicketsPanel.this.setSelectedTicket(selectedValue);
            }
        });
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 0;
        final Font font = new Font(ARIAL_FONT, 0, 46);
        this.l = new JList<String>(new String[]{"Imprimer"});
        this.l.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel l = new JLabel(value.toString()){

                    @Override
                    public void paint(Graphics g) {
                        super.paint(g);
                        g.setColor(Color.LIGHT_GRAY);
                        g.drawLine(0, 0, this.getWidth(), 0);
                    }
                };
                l.setFont(font);
                return l;
            }
        });
        this.l.setSelectionMode(0);
        this.l.getSelectionModel().addListSelectionListener(this);
        this.l.setFixedCellHeight(80);
        this.add((Component)this.l, c);
        this.setFont(new Font(ARIAL_FONT, 1, 24));
        bBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeDesTicketsPanel.this.frame.showCaisse();
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        Object selectedValue = this.ticketList.getSelectedValue();
        int selectedIndex = this.l.getSelectedIndex();
        if (selectedIndex == 0 && selectedValue != null) {
            POSConfiguration.getInstance().print((Ticket)selectedValue);
        }
        this.l.clearSelection();
    }

    public void setSelectedTicket(Object selectedValue) {
        this.ticketP.clear();
        if (selectedValue != null) {
            POSConfiguration.getInstance().print((Ticket)selectedValue, new TicketPrinterConfiguration(){

                @Override
                public TicketPrinter createTicketPrinter() {
                    return ListeDesTicketsPanel.this.ticketP;
                }

                @Override
                public int getCopyCount() {
                    return 1;
                }

                @Override
                public boolean isValid() {
                    return true;
                }
            });
            try {
                this.ticketP.printBuffer();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        this.ticketList.setSelectedValue(selectedValue, true);
    }
}

