/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.JPanel;
import org.openconcerto.erp.core.sales.pos.POSConfiguration;
import org.openconcerto.erp.core.sales.pos.model.RegisterLog;
import org.openconcerto.erp.core.sales.pos.ui.CaisseFrame;
import org.openconcerto.erp.core.sales.pos.ui.POSButton;
import org.openconcerto.task.config.ComptaBasePropsConfiguration;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.JImage;

public class CaisseMenuPanel
extends JPanel {
    private CaisseFrame frame;

    CaisseMenuPanel(final CaisseFrame caisseFrame) {
        this.frame = caisseFrame;
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 10;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(20, 20, 30, 20);
        JImage image = new JImage(ComptaBasePropsConfiguration.class.getResource("logo.png"));
        this.add((Component)image, c);
        ++c.gridx;
        POSButton bTickets = new POSButton("Liste des tickets");
        this.add((Component)bTickets, c);
        ++c.gridy;
        POSButton bCloture = new POSButton("Cl\u00f4turer");
        this.add((Component)bCloture, c);
        ++c.gridy;
        c.insets = new Insets(20, 20, 20, 20);
        c.fill = 0;
        c.anchor = 13;
        POSButton bQuit = new POSButton("Quitter");
        bQuit.setBackground(Color.decode("#AD1457"));
        this.add((Component)bQuit, c);
        bTickets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CaisseMenuPanel.this.frame.showTickets(null);
                }
                catch (Exception ex) {
                    ExceptionHandler.handle("Erreur", ex);
                }
            }
        });
        bCloture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CaisseMenuPanel.this.frame.getControler().setLCD("Cloture", "En cours...", 0);
                    int userID = POSConfiguration.getInstance().getUserID();
                    RegisterLog newLog = caisseFrame.getFiles().close(userID);
                    caisseFrame.getDB().close(userID, newLog);
                    CaisseMenuPanel.this.frame.getControler().setLCD("Cloture", "Terminee", 0);
                    CaisseMenuPanel.this.quit();
                }
                catch (Exception ex) {
                    ExceptionHandler.handle("Erreur", ex);
                }
            }
        });
        bQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CaisseMenuPanel.this.quit();
                }
                catch (Exception ex) {
                    ExceptionHandler.handle("Erreur", ex);
                }
            }
        });
    }

    private void quit() {
        POSConfiguration.getInstance().closeConnexion();
        this.frame.getControler().setLCD("   CAISSE FERMEE    ", "", 0);
        this.frame.dispose();
        Frame[] l = Frame.getFrames();
        int i = 0;
        while (i < l.length) {
            Frame f = l[i];
            System.err.println(String.valueOf(f.getName()) + " " + f + " Displayable: " + f.isDisplayable() + " Valid: " + f.isValid() + " Active: " + f.isActive());
            ++i;
        }
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        for (Thread thread : threadSet) {
            if (thread.isDaemon()) continue;
            System.err.println(String.valueOf(thread.getName()) + " " + thread.getId() + " not daemon");
        }
    }
}

