/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.Categorie;
import org.openconcerto.erp.core.sales.pos.ui.ArticleSelector;
import org.openconcerto.erp.core.sales.pos.ui.CaisseControler;
import org.openconcerto.erp.core.sales.pos.ui.CaisseListener;
import org.openconcerto.erp.core.sales.pos.ui.CaissePanel;
import org.openconcerto.erp.core.sales.pos.ui.FilteredListModel;
import org.openconcerto.erp.core.sales.pos.ui.POSButton;
import org.openconcerto.erp.core.sales.pos.ui.StatusBar;
import org.openconcerto.ui.touch.ScrollableList;

public class ArticleSearchPanel
extends JPanel
implements ListSelectionListener,
CaisseListener {
    private final ScrollableList list;
    private final CaisseControler controler;
    private Map<Categorie, String> categoryCache = new HashMap<Categorie, String>();

    public ArticleSearchPanel(final CaisseControler controler) {
        this.controler = controler;
        this.controler.addCaisseListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        final FilteredListModel model = new FilteredListModel();
        final Font f1 = new Font("Arial", 0, 24);
        final Font f2 = new Font("Arial", 0, 16);
        this.setBackground(CaissePanel.LIGHT_BLUE);
        this.list = new ScrollableList(model){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                g.setColor(CaissePanel.LIGHT_BLUE);
                g.drawLine(0, 0, 0, this.getHeight());
            }

            @Override
            public void paintCell(Graphics g, Object object, int index, boolean isSelected, int posY) {
                if (object instanceof Article) {
                    Article article = (Article)object;
                    ArticleSelector.paintArticle(f1, g, article, isSelected, posY, this.getWidth(), this.getCellHeight(), 36, 10);
                } else if (object instanceof Categorie) {
                    Categorie c = (Categorie)object;
                    ArticleSearchPanel.this.paintCategorie(f1, f2, g, c, isSelected, posY, this.getWidth(), this.getCellHeight());
                }
            }
        };
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        StatusBar bar = new StatusBar();
        POSButton bSwitch = new POSButton("-");
        bSwitch.setForeground(Color.WHITE);
        bSwitch.setBackground(CaissePanel.DARK_BLUE);
        bar.setLayout(new FlowLayout(0));
        bar.add(bSwitch);
        bSwitch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                controler.switchListMode();
            }
        });
        bar.setTitle("Articles");
        c.fill = 1;
        c.gridwidth = 2;
        this.add((Component)bar, c);
        c.weighty = 1.0;
        ++c.gridy;
        this.add((Component)this.list, c);
        c.weighty = 0.0;
        ++c.gridy;
        this.add((Component)new JSeparator(0), c);
        c.weighty = 0.0;
        ++c.gridy;
        c.insets = new Insets(3, 3, 3, 3);
        JLabel label = new JLabel(new ImageIcon(this.getClass().getResource("search.png")));
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.add((Component)label, c);
        final JTextField textField = new JTextField();
        textField.setBorder(BorderFactory.createLineBorder(CaissePanel.DARK_BLUE, 1));
        textField.setFont(f1);
        c.weightx = 1.0;
        ++c.gridx;
        textField.setFont(f1);
        this.add((Component)textField, c);
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                model.setFilter(textField.getText());
            }
        });
        this.list.addListSelectionListener(this);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Object sel;
                int nb = e.getClickCount();
                if (nb > 1 && (sel = ArticleSearchPanel.this.list.getSelectedValue()) != null) {
                    Article article = (Article)sel;
                    controler.incrementArticle(article);
                    controler.setArticleSelected(article);
                }
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object sel = this.list.getSelectedValue();
        if (sel != null && !e.getValueIsAdjusting() && sel instanceof Article) {
            Article article = (Article)sel;
            this.controler.setArticleSelected(article);
            this.controler.addArticle(article);
        }
    }

    public void paintCategorie(Font f, Font f2, Graphics g, Categorie c, boolean isSelected, int posY, int cellWidth, int cellHeight) {
        String label2;
        g.setFont(f);
        g.setColor(Color.WHITE);
        g.fillRect(0, posY, cellWidth, cellHeight);
        g.setColor(Color.GRAY);
        g.drawLine(0, posY + cellHeight - 1, cellWidth, posY + cellHeight - 1);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        String label = c.getName();
        int MAX_WIDTH = 36;
        int MAX_WIDTH2 = 48;
        if (label.length() > 72) {
            label = String.valueOf(label.substring(0, 72)) + "...";
        }
        if ((label2 = this.getCategoriePath(c)) != null && label2.length() > 48) {
            label2 = String.valueOf(label2.substring(0, 48)) + "...";
        }
        g.setColor(Color.BLACK);
        if (label2 == null) {
            g.drawString(label, 10, posY + 39);
        } else {
            g.drawString(label, 10, posY + 26);
            g.setColor(Color.DARK_GRAY);
            g.setFont(f2);
            g.drawString(label2, 10, posY + 52);
        }
    }

    private String getCategoriePath(Categorie c) {
        if (c.getParent() == null) {
            return null;
        }
        String storedString = this.categoryCache.get(c);
        if (storedString != null) {
            return storedString;
        }
        Categorie parent = c.getParent();
        String s = "";
        HashSet<Categorie> set = new HashSet<Categorie>();
        set.add(c);
        while (parent != null) {
            if (set.contains(parent)) {
                System.err.println("ArticleSearchPanel.getCategoriePath() loop detected for category " + c + " " + parent + " already in " + set);
                break;
            }
            set.add(parent);
            s = s.length() > 0 ? String.valueOf(parent.getName()) + " / " + s : parent.getName();
            parent = c.getParent();
        }
        this.categoryCache.put(c, s);
        return s;
    }

    @Override
    public void caisseStateChanged() {
        Article articleSelected = this.controler.getArticleSelected();
        if (articleSelected == null) {
            return;
        }
        Object selectedValue = null;
        try {
            selectedValue = this.list.getSelectedValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (articleSelected != null && !articleSelected.equals(selectedValue)) {
            this.list.setSelectedValue(articleSelected, true);
        }
    }
}

