/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.model;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.openconcerto.erp.core.sales.pos.model.DBState;
import org.openconcerto.erp.core.sales.pos.model.ReceiptCode;
import org.openconcerto.erp.core.sales.pos.model.RegisterDB;
import org.openconcerto.erp.core.sales.pos.model.RegisterLog;
import org.openconcerto.erp.core.sales.pos.model.RegisterLogEntry;
import org.openconcerto.erp.core.sales.pos.model.RegisterState;
import org.openconcerto.erp.core.sales.pos.model.Ticket;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.MessageDigestUtils;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.cc.ExnTransformer;
import org.openconcerto.utils.checks.ValidState;

public class RegisterFiles {
    private static final String REGISTER_DIRNAME = "register";
    public static final String STRUCT_VERSION_2013 = "v20131206";
    public static final String STRUCT_VERSION = "v20171220";
    private static final String LOG_FILENAME = "log.xml";
    static final String HASH_SUFFIX = ".hash";
    private static final String LOG_HASH_FILENAME = "log.xml.hash";
    private static final Comparator<Path> FILENAME_COMPARATOR = new Comparator<Path>(){

        @Override
        public int compare(Path p1, Path p2) {
            return p1.getFileName().toString().compareTo(p2.getFileName().toString());
        }
    };
    private static final Comparator<Path> PATH_COMPARATOR = new Comparator<Path>(){

        @Override
        public int compare(Path p1, Path p2) {
            return p1.toString().compareTo(p2.toString());
        }
    };
    private static final Pattern DIGITS_PATTERN = Pattern.compile("[0-9]+");
    private final Path rootDir;
    private final boolean useHardLinks;
    private final int posID;
    private final ThreadLocal<Boolean> hasLock = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    private static final Path getGreatestSubDir(Path dir) throws IOException {
        Path res = null;
        if (dir != null && Files.exists(dir, LinkOption.NOFOLLOW_LINKS)) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (DirectoryStream<Path> subdirs = Files.newDirectoryStream(dir, FileUtils.DIR_PATH_FILTER);){
                for (Path subdir : subdirs) {
                    if (res != null && FILENAME_COMPARATOR.compare(subdir, res) <= 0) continue;
                    res = subdir;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return res;
    }

    private static final ValidState canReadFile(Path f, String missingString, String missingPermString) throws IOException {
        if (!Files.isRegularFile(f, new LinkOption[0])) {
            return ValidState.createCached(false, missingString);
        }
        if (!Files.isReadable(f)) {
            return ValidState.createCached(false, missingPermString);
        }
        return ValidState.getTrueInstance();
    }

    public static final byte[] save(Document doc, Path f) throws IOException {
        byte[] res;
        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
        Throwable throwable = null;
        Object var5_5 = null;
        try (DigestOutputStream digestStream = new DigestOutputStream(Files.newOutputStream(f, new OpenOption[0]), MessageDigestUtils.getSHA256());){
            out.output(doc, (OutputStream)digestStream);
            res = digestStream.getMessageDigest().digest();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Files.write(f.resolveSibling(f.getFileName() + HASH_SUFFIX), MessageDigestUtils.asHex(res).getBytes(StringUtils.UTF8), new OpenOption[0]);
        return res;
    }

    public static final Document parse(Path f) throws IOException, JDOMException {
        return RegisterFiles.parse(f, HashMode.REQUIRED);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final Document parse(Path f, HashMode hashMode) throws IOException, JDOMException {
        byte[] hash;
        Path logHashFile = f.resolveSibling(f.getFileName() + HASH_SUFFIX);
        if (Files.isRegularFile(logHashFile, new LinkOption[0])) {
            String hashString = Files.readAllLines(logHashFile, StringUtils.UTF8).get(0);
            if (hashMode.hashRequired != null && !hashString.equals(hashMode.hashRequired)) {
                throw new IllegalStateException("Required hash doesn't match recorded hash");
            }
            hash = MessageDigestUtils.fromHex(hashString);
            assert (hash != null);
        } else {
            if (hashMode.hashFileRequired) {
                throw new IllegalStateException("Missing required hash file for " + f);
            }
            hash = null;
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            Document doc;
            BufferedInputStream ins = new BufferedInputStream(Files.newInputStream(f, LinkOption.NOFOLLOW_LINKS));
            try {
                try (DigestInputStream dIns = new DigestInputStream(ins, MessageDigestUtils.getSHA256());){
                    doc = new SAXBuilder().build(dIns);
                    if (hash != null && !Arrays.equals(hash, dIns.getMessageDigest().digest())) {
                        throw new IOException("File hash doesn't match recorded hash for " + f);
                    }
                }
                if (ins == null) return doc;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (ins == null) throw throwable;
                ((InputStream)ins).close();
                throw throwable;
            }
            ((InputStream)ins).close();
            return doc;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static final List<RegisterFiles> scan(Path rootDir) throws IOException {
        Path registersDir = rootDir.resolve(REGISTER_DIRNAME);
        if (!Files.exists(registersDir, new LinkOption[0])) {
            return Collections.emptyList();
        }
        ArrayList<RegisterFiles> res = new ArrayList<RegisterFiles>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(registersDir, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                return DIGITS_PATTERN.matcher(entry.getFileName().toString()).matches();
            }
        });){
            for (Path registerDir : stream) {
                if (!Files.isDirectory(registerDir.resolve(STRUCT_VERSION), new LinkOption[0])) continue;
                res.add(new RegisterFiles(rootDir, true, Integer.parseInt(registerDir.getFileName().toString())));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return res;
    }

    public RegisterFiles(Path rootDir, boolean useHardLinks, int caisse) {
        this.rootDir = rootDir.resolve(REGISTER_DIRNAME).resolve(Integer.toString(caisse));
        this.useHardLinks = useHardLinks;
        this.posID = caisse;
    }

    private final Path getRootDir() {
        return this.rootDir;
    }

    public final Path getVersionDir() {
        return this.getRootDir().resolve(STRUCT_VERSION);
    }

    public final Path getDayDir(Calendar day, boolean create) {
        return ReceiptCode.getDayDir(this.getVersionDir().toFile(), day, create).toPath();
    }

    public final Path getReceiptFile(ReceiptCode code) throws IOException {
        Path dayDirToUse = this.getDayDirToUse(this.getDayDir(code.getDay(), false));
        return dayDirToUse == null ? null : dayDirToUse.resolve(code.getFileName());
    }

    public final int getPosID() {
        return this.posID;
    }

    public <T, Exn extends Exception> T doWithLock(final ExnTransformer<RegisterFiles, T, Exn> transf) throws IOException, Exn {
        if (this.hasLock.get().booleanValue()) {
            throw new IllegalStateException("Already locked");
        }
        this.hasLock.set(Boolean.TRUE);
        try {
            Object t = FileUtils.doWithLock(this.getRootDir().resolve("lockFile").toFile(), new ExnTransformer<RandomAccessFile, T, Exn>(){

                @Override
                public T transformChecked(RandomAccessFile input) throws Exception {
                    return transf.transformChecked(RegisterFiles.this);
                }
            });
            return t;
        }
        finally {
            this.hasLock.set(Boolean.FALSE);
        }
    }

    public final RegisterLog getLastLog() throws IOException, JDOMException {
        Path lastLogFile = this.findLastLogFile();
        if (lastLogFile == null) {
            return null;
        }
        return new RegisterLog(lastLogFile).parse();
    }

    public final Path findLastLogFile() throws IOException {
        Path versionDir = this.getVersionDir();
        Path yearDir = RegisterFiles.getGreatestSubDir(versionDir);
        Path monthDir = RegisterFiles.getGreatestSubDir(yearDir);
        if (monthDir != null) {
            TreeSet<Path> sortedDays = new TreeSet<Path>(Collections.reverseOrder(FILENAME_COMPARATOR));
            Throwable throwable = null;
            Object var6_7 = null;
            try (DirectoryStream<Path> dayDirs = Files.newDirectoryStream(monthDir, FileUtils.DIR_PATH_FILTER);){
                for (Path dayDir : dayDirs) {
                    sortedDays.add(dayDir);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            Path logToUse = this.getLogToUse(sortedDays);
            if (logToUse != null) {
                return logToUse;
            }
            logToUse = this.getLogToUse(this.getSortedDays(false));
            if (logToUse != null) {
                return logToUse;
            }
        }
        return null;
    }

    private SortedSet<Path> getSortedDays(boolean chronological) throws IOException {
        final Path versionDir = this.getVersionDir();
        final TreeSet<Path> sortedPaths = new TreeSet<Path>(chronological ? PATH_COMPARATOR : Collections.reverseOrder(PATH_COMPARATOR));
        if (Files.exists(versionDir, new LinkOption[0])) {
            Files.walkFileTree(versionDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Path dateDir = versionDir.relativize(dir);
                    if (dateDir.getNameCount() == 3) {
                        sortedPaths.add(dir);
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return sortedPaths;
    }

    private Path getLogToUse(SortedSet<Path> sortedDays) throws IOException {
        for (Path dayDir : sortedDays) {
            Path dayDirToUse = this.getDayDirToUse(dayDir);
            if (dayDirToUse == null) continue;
            return dayDirToUse.resolve(LOG_FILENAME);
        }
        return null;
    }

    public final List<Path> findLogFiles() throws IOException {
        ArrayList<Path> res = new ArrayList<Path>();
        for (Path dayDir : this.getSortedDays(true)) {
            Path dayDirToUse = this.getDayDirToUse(dayDir);
            if (dayDirToUse == null) continue;
            res.add(dayDirToUse.resolve(LOG_FILENAME));
        }
        return res;
    }

    private final Path getDayDirToUse(Path dayDir) throws IOException {
        Path[] pathArray = new Path[]{dayDir.resolve("current"), dayDir.resolve("previous")};
        int n = pathArray.length;
        int n2 = 0;
        while (n2 < n) {
            Path subdir = pathArray[n2];
            if (Files.exists(subdir, new LinkOption[0])) {
                ValidState validity = this.getDayDirValidity(subdir);
                if (validity.isValid()) {
                    return subdir;
                }
                throw new IOException("Invalid " + subdir + " : " + validity.getValidationText());
            }
            ++n2;
        }
        return null;
    }

    private final ValidState getDayDirValidity(Path dayDir) throws IOException {
        if (!Files.isDirectory(dayDir, new LinkOption[0])) {
            return ValidState.createCached(false, "Not a directory");
        }
        ValidState canReadLog = RegisterFiles.canReadFile(dayDir.resolve(LOG_FILENAME), "Missing log file", "Unreadable log file");
        if (!canReadLog.isValid()) {
            return canReadLog;
        }
        ValidState canReadLogHash = RegisterFiles.canReadFile(dayDir.resolve(LOG_HASH_FILENAME), "Missing log hash file", "Unreadable log hash file");
        if (!canReadLogHash.isValid()) {
            return canReadLogHash;
        }
        return ValidState.getTrueInstance();
    }

    public final RegisterLog open(int userID, DBState dbState) throws IOException {
        if (!this.hasLock.get().booleanValue()) {
            throw new IllegalStateException("Not locked");
        }
        return RegisterFiles.createOpen(userID, null, dbState).transformChecked(this);
    }

    public final RegisterLog open(int userID, RegisterDB registerDB) throws IOException {
        return this.doWithLock(RegisterFiles.createOpen(userID, registerDB, null));
    }

    private static final ExnTransformer<RegisterFiles, RegisterLog, IOException> createOpen(final int userID, final RegisterDB registerDB, final DBState passedDBState) throws IOException {
        return new ExnTransformer<RegisterFiles, RegisterLog, IOException>(){

            @Override
            public RegisterLog transformChecked(RegisterFiles input) throws IOException {
                DBState dbState;
                String lastLocalHash;
                RegisterLog lastLog = input.checkStatus(true);
                if (lastLog == null) {
                    lastLocalHash = null;
                } else {
                    try {
                        lastLocalHash = lastLog.getLastReceiptHash();
                    }
                    catch (ParseException e) {
                        throw new IOException("Couldn't parse last receipt of log", e);
                    }
                }
                if (passedDBState == null) {
                    try {
                        dbState = registerDB.open(lastLocalHash, userID);
                    }
                    catch (SQLException e) {
                        throw new IOException("Couldn't open the register in the DB", e);
                    }
                } else {
                    dbState = passedDBState;
                }
                if (dbState.getRegisterState().getStatus() != RegisterState.Status.OPEN) {
                    throw new IllegalArgumentException("DB not open : " + dbState);
                }
                Calendar cal = dbState.getLastEntry().getDate("DATE");
                Path dayDir = input.getDayDir(cal, true);
                Path dayDirToUse = input.getDayDirToUse(dayDir);
                if (dayDirToUse != null) {
                    throw new IllegalStateException(cal.getTime() + " already open");
                }
                Path stagingDir = dayDir.resolve("staging");
                Path currentDir = stagingDir.resolveSibling("current");
                Path prevDir = stagingDir.resolveSibling("previous");
                FileUtils.rm_R(stagingDir);
                FileUtils.rm_R(currentDir);
                FileUtils.rm_R(prevDir);
                Files.createDirectory(stagingDir, new FileAttribute[0]);
                Element rootElem = new Element("registerLog");
                rootElem.addContent(new RegisterLogEntry.RegisterEntry(RegisterLog.EventType.REGISTER_OPENING, cal.getTime(), userID, input.getPosID(), lastLocalHash).toXML());
                RegisterFiles.save(new Document(rootElem), stagingDir.resolve(RegisterFiles.LOG_FILENAME));
                Files.move(stagingDir, currentDir, StandardCopyOption.ATOMIC_MOVE);
                try {
                    return new RegisterLog(currentDir.resolve(RegisterFiles.LOG_FILENAME)).parse();
                }
                catch (JDOMException e) {
                    throw new IOException("Couldn't parse new log");
                }
            }
        };
    }

    private final RegisterLog checkStatus(boolean needsClosed) throws IOException {
        RegisterLog lastLog;
        try {
            boolean closed;
            lastLog = this.getLastLog();
            boolean bl = closed = lastLog == null || lastLog.getLastRegisterEvent().getType() != RegisterLog.EventType.REGISTER_OPENING;
            if (closed != needsClosed) {
                throw new IllegalStateException(needsClosed ? "Not closed" : "Not open");
            }
        }
        catch (ParseException | JDOMException e) {
            throw new IOException(e);
        }
        return lastLog;
    }

    public final RegisterLog close(final int userID) throws IOException {
        return this.doWithLock(new UpdateDir<Object, RegisterLog>(this){

            @Override
            protected boolean needsClosed() {
                return false;
            }

            @Override
            protected Object updateDir(Path stagingDir, RegisterLog lastLog) throws IOException {
                String lastHash;
                try {
                    RegisterLogEntry.ReceiptEntry lastReceiptCreationEvent = lastLog.getLastReceiptCreationEvent();
                    lastHash = lastReceiptCreationEvent != null ? lastReceiptCreationEvent.getFileHash() : lastLog.getFirstRegisterEvent().getLastReceiptHash();
                }
                catch (ParseException e) {
                    throw new IOException("Couldn't find last receipt hash", e);
                }
                Document doc = lastLog.getDocument().clone();
                doc.getRootElement().addContent(new RegisterLogEntry.RegisterEntry(RegisterLog.EventType.REGISTER_CLOSURE, new Date(), userID, this.getPosID(), lastHash).toXML());
                RegisterFiles.save(doc, stagingDir.resolve(RegisterFiles.LOG_FILENAME));
                return null;
            }

            @Override
            protected RegisterLog createResult(Path currentDir, Object intermediateRes) throws IOException {
                try {
                    return new RegisterLog(currentDir.resolve(RegisterFiles.LOG_FILENAME)).parse();
                }
                catch (JDOMException e) {
                    throw new IOException("Couldn't parse new log");
                }
            }
        });
    }

    public final String save(final Ticket t) throws IOException, SQLException {
        return this.doWithLock(new UpdateDir<String, String>(this){

            @Override
            protected boolean needsClosed() {
                return false;
            }

            @Override
            protected String updateDir(Path stagingDir, RegisterLog lastLog) throws IOException {
                try {
                    RegisterLogEntry.ReceiptEntry lastReceipt = lastLog.getLastReceiptCreationEvent();
                    String expectedHash = lastLog.getLastReceiptHash();
                    int expectedIndex = lastReceipt == null ? 1 : lastReceipt.getCode().getDayIndex() + 1;
                    if (t.getReceiptCode().getDayIndex() != expectedIndex) {
                        throw new IllegalStateException("Non consecutive number");
                    }
                    if (!CompareUtils.equals(expectedHash, t.getPreviousHash())) {
                        throw new IllegalStateException("Previous hash mismatch, expected " + expectedHash + " but previous of receipt was " + t.getPreviousHash());
                    }
                }
                catch (ParseException e) {
                    throw new IOException("Couldn't parse last receipt of log", e);
                }
                String fileHash = MessageDigestUtils.asHex(t.saveToFile(stagingDir.resolve(t.getReceiptCode().getFileName())));
                Document doc = lastLog.getDocument().clone();
                doc.getRootElement().addContent(new RegisterLogEntry.ReceiptEntry(t.getCreationDate(), t.getReceiptCode(), fileHash).toXML());
                RegisterFiles.save(doc, stagingDir.resolve(RegisterFiles.LOG_FILENAME));
                return fileHash;
            }

            @Override
            protected String createResult(Path currentDir, String intermediateRes) {
                return intermediateRes;
            }
        });
    }

    public static final class HashMode {
        public static final HashMode NOT_REQUIRED = new HashMode(false, null);
        public static final HashMode REQUIRED = new HashMode(true, null);
        private final boolean hashFileRequired;
        private final String hashRequired;

        public static final HashMode equalTo(String hashRequired) {
            return new HashMode(true, hashRequired);
        }

        private HashMode(boolean hashFileRequired, String hashRequired) {
            this.hashFileRequired = hashFileRequired;
            this.hashRequired = hashRequired;
        }
    }

    private abstract class UpdateDir<I, T>
    extends ExnTransformer<RegisterFiles, T, IOException> {
        private UpdateDir() {
        }

        @Override
        public T transformChecked(RegisterFiles input) throws IOException {
            RegisterLog lastLog = RegisterFiles.this.checkStatus(this.needsClosed());
            Path toUse = lastLog.getLogFile().getParent();
            Path stagingDir = toUse.resolveSibling("staging");
            Path currentDir = stagingDir.resolveSibling("current");
            Path prevDir = stagingDir.resolveSibling("previous");
            FileUtils.rm_R(stagingDir);
            FileUtils.copyDirectory(toUse, stagingDir, input.useHardLinks, StandardCopyOption.COPY_ATTRIBUTES);
            I intermediateRes = this.updateDir(stagingDir, lastLog);
            if (Files.exists(currentDir, new LinkOption[0])) {
                FileUtils.rm_R(prevDir);
                Files.move(currentDir, prevDir, StandardCopyOption.ATOMIC_MOVE);
            }
            assert (!Files.exists(currentDir, new LinkOption[0]));
            Files.move(stagingDir, currentDir, StandardCopyOption.ATOMIC_MOVE);
            assert (Files.isDirectory(currentDir, new LinkOption[0]));
            try {
                FileUtils.rm_R(prevDir);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.createResult(currentDir, intermediateRes);
        }

        protected abstract boolean needsClosed();

        protected abstract I updateDir(Path var1, RegisterLog var2) throws IOException;

        protected abstract T createResult(Path var1, I var2) throws IOException;
    }
}

