/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.model;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.openconcerto.erp.core.sales.pos.POSConfiguration;
import org.openconcerto.erp.core.sales.pos.element.CaisseJournalSQLElement;
import org.openconcerto.erp.core.sales.pos.element.CaisseTicketSQLElement;
import org.openconcerto.erp.core.sales.pos.element.Cl\u00f4tureCaisseSQLElement;
import org.openconcerto.erp.core.sales.pos.element.TicketCaisseSQLElement;
import org.openconcerto.erp.core.sales.pos.model.DBState;
import org.openconcerto.erp.core.sales.pos.model.RegisterLog;
import org.openconcerto.erp.core.sales.pos.model.RegisterLogEntry;
import org.openconcerto.erp.core.sales.pos.model.RegisterState;
import org.openconcerto.erp.core.sales.pos.model.Ticket;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.Order;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.model.graph.PathBuilder;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.ProductInfo;
import org.openconcerto.utils.TimeUtils;
import org.openconcerto.utils.cc.ITransformer;

public class RegisterDB {
    private final ProductInfo productInfo;
    private final CaisseTicketSQLElement registerElem;
    private final TicketCaisseSQLElement receiptElem;
    private final CaisseJournalSQLElement logElem;
    private final Cl\u00f4tureCaisseSQLElement closureElem;
    private final int posID;

    public RegisterDB(SQLElementDirectory dir, ProductInfo productInfo, int caisse) {
        this.productInfo = productInfo;
        this.registerElem = dir.getElement(CaisseTicketSQLElement.class);
        this.receiptElem = dir.getElement(TicketCaisseSQLElement.class);
        this.logElem = dir.getElement(CaisseJournalSQLElement.class);
        this.closureElem = dir.getElement(Cl\u00f4tureCaisseSQLElement.class);
        this.posID = caisse;
    }

    public final SQLTable getRegisterTable() {
        return this.registerElem.getTable();
    }

    public final TicketCaisseSQLElement getReceiptElement() {
        return this.receiptElem;
    }

    public final CaisseJournalSQLElement getLogElement() {
        return this.logElem;
    }

    public final Cl\u00f4tureCaisseSQLElement getClosureElement() {
        return this.closureElem;
    }

    public final int getPosID() {
        return this.posID;
    }

    protected final Path getRegisterToLastClosureEntry() {
        return ((PathBuilder)((PathBuilder)new PathBuilder(this.getRegisterTable()).addForeignField("ID_DERNIERE_CLOTURE")).addForeignField("ID_ENTREE_JOURNAL")).build();
    }

    public final DBState fetchRegisterState() throws SQLException {
        return this.fetchRegisterState(SQLSelect.LockStrength.SHARE);
    }

    private final DBState fetchRegisterState(final SQLSelect.LockStrength lockStrength) throws SQLException {
        final SQLRowValues registerVals = new SQLRowValues(this.getRegisterTable());
        registerVals.setAllToNull();
        registerVals.putRowValues("ID_DERNIERE_ENTREE_JOURNAL").setAllToNull();
        registerVals.assurePath(this.getRegisterToLastClosureEntry()).setAllToNull();
        final SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(registerVals);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                input.setLockStrength(lockStrength);
                input.addLockedTable(registerVals.getTable().getName());
                return input;
            }
        });
        final SQLSelect selLastReceipt = new SQLSelect();
        selLastReceipt.addSelectStar(this.receiptElem.getTable());
        selLastReceipt.setWhere(new Where((FieldRef)this.receiptElem.getTable().getField("ID_CAISSE"), "=", this.getPosID()));
        selLastReceipt.addFieldOrder(this.receiptElem.getTable().getField("DATE"), Order.desc());
        selLastReceipt.setLimit(1);
        SQLRowValues registerR = SQLUtils.executeAtomic(this.getRegisterTable().getDBSystemRoot().getDataSource(), new SQLUtils.SQLFactory<SQLRowValues>(){

            @Override
            public SQLRowValues create() throws SQLException {
                SQLRowValues res = fetcher.fetchOne(RegisterDB.this.getPosID());
                if (res == null) {
                    throw new IllegalStateException("Register not found : " + RegisterDB.this.getPosID());
                }
                List<SQLRow> receipts = SQLRowListRSH.execute(selLastReceipt);
                if (receipts.size() == 1) {
                    receipts.get(0).asRowValues().put("ID_CAISSE", (Object)res);
                }
                res.getGraph().freeze();
                return res;
            }
        });
        return new DBState(this, registerR);
    }

    public final DBState open(final String lastLocalHash, final int userID) throws SQLException {
        return SQLUtils.executeAtomic(this.getRegisterTable().getDBSystemRoot().getDataSource(), new SQLUtils.SQLFactory<DBState>(){

            @Override
            public DBState create() throws SQLException {
                DBState fetchedState = RegisterDB.this.fetchRegisterState(SQLSelect.LockStrength.UPDATE);
                RegisterDB.this.checkStatus(fetchedState, RegisterState.Status.CLOSED);
                RegisterDB.this.checkHashes(fetchedState, lastLocalHash);
                Date openDay = new Date();
                RegisterDB.this.createUpdateVals(fetchedState, userID, RegisterState.Status.OPEN, openDay).commit();
                return RegisterDB.this.fetchRegisterState();
            }
        });
    }

    private final void checkStatus(DBState fetchedState, RegisterState.Status expected) {
        if (!fetchedState.getRegisterState().getStatus().equals((Object)expected)) {
            throw new IllegalStateException("DB is currently " + fetchedState.getRegisterState());
        }
    }

    private final void checkHashes(DBState fetchedState, String lastLocalHash) {
        String lastDBHash;
        SQLRowValues lastReceipt = fetchedState.getLastReceiptRow();
        String string = lastDBHash = lastReceipt == null ? null : lastReceipt.getString("FILE_HASH");
        if (!CompareUtils.equals(lastLocalHash, lastDBHash)) {
            throw new IllegalStateException("last DB receipt (" + lastDBHash + ") doesn't match last local receipt (" + lastLocalHash + ")");
        }
    }

    private final void checkDate(DBState fetchedState, Date date, boolean sameDayAllowed) {
        SQLRowValues lastEntry = fetchedState.getLastEntry();
        if (lastEntry == null) {
            return;
        }
        Calendar previousEntryCal = lastEntry.getDate("DATE");
        Date previousEntryDate = previousEntryCal.getTime();
        if (previousEntryDate.compareTo(date) >= 0) {
            throw new IllegalStateException("Previous date is after state to be created : " + previousEntryDate + " >= " + date);
        }
        if (!sameDayAllowed) {
            Calendar previousEntryDay = (Calendar)previousEntryCal.clone();
            Calendar newEntryDay = (Calendar)previousEntryCal.clone();
            newEntryDay.clear();
            newEntryDay.setTime(date);
            TimeUtils.clearTime(previousEntryDay);
            TimeUtils.clearTime(newEntryDay);
            if (previousEntryDay.compareTo(newEntryDay) == 0) {
                throw new IllegalStateException("The state to be created would be in the same day as the previous : " + previousEntryDate + " ; " + date);
            }
        }
    }

    private final SQLRowValues createUpdateVals(DBState fetchedState, int userID, RegisterState.Status newStatus, Date date) {
        this.checkDate(fetchedState, date, newStatus != RegisterState.Status.OPEN);
        SQLRowValues registerVals = new SQLRowValues(this.getRegisterTable());
        registerVals.setPrimaryKey(fetchedState.getRegisterRow());
        SQLRowValues logVals = registerVals.putRowValues("ID_DERNIERE_ENTREE_JOURNAL");
        logVals.put("ID_CAISSE", this.getPosID());
        logVals.put("DATE", date);
        logVals.put("ID_USER", userID);
        logVals.put("EVT", newStatus.name());
        logVals.put("CREATOR", this.productInfo.getFullID());
        logVals.put("CREATOR_VERSION", this.productInfo.getVersion());
        return registerVals;
    }

    public final DBState close(final int userID, final RegisterLog log) throws SQLException, ParseException {
        final List<RegisterLogEntry.ReceiptEntry> receiptEvents = log.getReceiptEvents();
        final RegisterLogEntry.RegisterEntry closureEntry = log.getLastRegisterEvent();
        if (closureEntry.getType() != RegisterLog.EventType.REGISTER_CLOSURE) {
            throw new IllegalArgumentException("Log not closed");
        }
        final List<Ticket> receipts = log.parseReceipts();
        return SQLUtils.executeAtomic(this.getRegisterTable().getDBSystemRoot().getDataSource(), new SQLUtils.SQLFactory<DBState>(){

            @Override
            public DBState create() throws SQLException {
                DBState fetchedState = RegisterDB.this.fetchRegisterState(SQLSelect.LockStrength.UPDATE);
                RegisterDB.this.checkStatus(fetchedState, RegisterState.Status.OPEN);
                RegisterDB.this.checkHashes(fetchedState, ((Ticket)receipts.get(0)).getPreviousHash());
                Date ourDate = closureEntry.getDate();
                POSConfiguration.getInstance().importReceipts(receipts, receiptEvents);
                SQLRowValues registerVals = RegisterDB.this.createUpdateVals(fetchedState, userID, RegisterState.Status.CLOSED, ourDate);
                SQLRowValues newLogEntry = (SQLRowValues)registerVals.getObject("ID_DERNIERE_ENTREE_JOURNAL");
                if (newLogEntry == null) {
                    throw new IllegalStateException("Missing log entry in " + registerVals);
                }
                SQLRowValues closureVals = registerVals.putRowValues("ID_DERNIERE_CLOTURE");
                closureVals.put("ID_ENTREE_JOURNAL", (Object)newLogEntry);
                closureVals.put("PERIODE", "journali\u00e8re");
                closureVals.put("DEBUT", log.getFirstRegisterEvent().getDate());
                closureVals.put("FIN", ourDate);
                RegisterDB.fillRow(closureVals, receiptEvents, receipts);
                registerVals.commit();
                return RegisterDB.this.fetchRegisterState();
            }
        });
    }

    static SQLRowValues fillRow(SQLRowValues closureVals, List<RegisterLogEntry.ReceiptEntry> receiptEvents, List<Ticket> receipts) {
        BigDecimal totalTTC = BigDecimal.ZERO;
        for (Ticket t : receipts) {
            totalTTC.add(BigDecimal.valueOf(t.getPaidTotal()).movePointLeft(2));
        }
        closureVals.put("TOTAL_TTC", totalTTC);
        if (!receiptEvents.isEmpty()) {
            closureVals.put("PREMIER_TICKET", receiptEvents.get(0).getCodeString());
            closureVals.put("PREMIER_TICKET_HASH", receiptEvents.get(0).getFileHash());
            RegisterLogEntry.ReceiptEntry lastReceiptEntry = receiptEvents.get(receiptEvents.size() - 1);
            closureVals.put("DERNIER_TICKET", lastReceiptEntry.getCodeString());
            closureVals.put("DERNIER_TICKET_HASH", lastReceiptEntry.getFileHash());
        }
        return closureVals;
    }
}

