/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.io;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import org.openconcerto.erp.core.sales.pos.io.AbstractESCPrinter;

public class ESCSerialPrinter
extends AbstractESCPrinter {
    private String port;

    public ESCSerialPrinter(String port) {
        port = port.trim();
        if (port.endsWith(":")) {
            port = port.substring(0, port.length() - 1);
        }
        this.port = port;
    }

    @Override
    public synchronized void openDrawer() throws Exception {
        SerialPort serialPort = this.getSerialPort();
        OutputStream out = serialPort.getOutputStream();
        boolean useESCP = false;
        if (useESCP) {
            out.write(27);
            out.write(112);
            out.write(0);
            out.write(100);
            out.write(100);
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            out.write(27);
            out.write(112);
            out.write(1);
            out.write(100);
            out.write(100);
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        out.write(16);
        out.write(20);
        out.write(1);
        out.write(0);
        out.write(2);
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        out.write(16);
        out.write(20);
        out.write(1);
        out.write(1);
        out.write(2);
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        out.close();
        serialPort.close();
    }

    @Override
    public synchronized void printBuffer() throws Exception {
        byte[] byteArray = this.getPrintBufferBytes();
        SerialPort serialPort = this.getSerialPort();
        OutputStream out = serialPort.getOutputStream();
        out.write(byteArray);
        out.close();
        serialPort.close();
    }

    private SerialPort getSerialPort() throws Exception {
        if (this.port == null || this.port.length() == 0) {
            throw new IllegalStateException("Invalid serial port name: " + this.port);
        }
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier(this.port);
        if (portIdentifier.isCurrentlyOwned()) {
            throw new IllegalAccessError("Port " + this.port + " is currently in use");
        }
        int timeOutMs = 2000;
        CommPort commPort = portIdentifier.open("ESCSerialPrinter", 2000);
        if (!(commPort instanceof SerialPort)) {
            throw new IllegalStateException("Invalid serial port: " + this.port);
        }
        SerialPort serialPort = (SerialPort)commPort;
        serialPort.setSerialPortParams(9600, 8, 1, 0);
        return serialPort;
    }

    public static void main(String[] args) {
        ESCSerialPrinter.listPorts();
        ESCSerialPrinter prt = new ESCSerialPrinter("COM1");
        prt.setPort(ESCSerialPrinter.getSerialPortNames().get(0));
        int col = 42;
        prt.addToBuffer("ILM INFORMATIQUE", 2);
        prt.addToBuffer("");
        prt.addToBuffer("22 place de la liberation");
        prt.addToBuffer("80100 ABBEVILLE");
        prt.addToBuffer("T\u00e9l: 00 00 00 00 00");
        prt.addToBuffer("Fax: 00 00 00 00 00");
        prt.addToBuffer("");
        SimpleDateFormat df = new SimpleDateFormat("EEEE d MMMM yyyy \u00e0 HH:mm");
        prt.addToBuffer(ESCSerialPrinter.formatRight(42, "Le " + df.format(Calendar.getInstance().getTime())));
        prt.addToBuffer("");
        prt.addToBuffer(String.valueOf(ESCSerialPrinter.formatRight(5, "3")) + " " + ESCSerialPrinter.formatLeft(col - 6 - 9, "ILM Informatique") + " " + ESCSerialPrinter.formatRight(8, "3.00"));
        prt.addToBuffer(ESCSerialPrinter.formatLeft(col, "      ======================================="));
        prt.addToBuffer(String.valueOf(ESCSerialPrinter.formatRight(col - 8, "Total")) + ESCSerialPrinter.formatRight(8, "3.00"), 1);
        prt.addToBuffer("");
        prt.addToBuffer("Merci de votre visite, \u00e0 bient\u00f4t.");
        prt.addToBuffer("");
        prt.addToBuffer("01 05042010 00002", 10);
        try {
            prt.printBuffer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setPort(String string) {
        this.port = string;
    }

    public static void listPorts() {
        Enumeration portEnum = CommPortIdentifier.getPortIdentifiers();
        while (portEnum.hasMoreElements()) {
            CommPortIdentifier portIdentifier = (CommPortIdentifier)portEnum.nextElement();
            System.out.println("Port: " + portIdentifier.getName() + " Type: " + ESCSerialPrinter.getPortTypeName(portIdentifier.getPortType()));
        }
    }

    public static List<String> getSerialPortNames() {
        ArrayList<String> r = new ArrayList<String>();
        Enumeration portEnum = CommPortIdentifier.getPortIdentifiers();
        while (portEnum.hasMoreElements()) {
            CommPortIdentifier portIdentifier = (CommPortIdentifier)portEnum.nextElement();
            System.out.println("Port: " + portIdentifier.getName() + " Type: " + ESCSerialPrinter.getPortTypeName(portIdentifier.getPortType()));
            if (portIdentifier.getPortType() != 1) continue;
            r.add(portIdentifier.getName());
        }
        return r;
    }

    private static String getPortTypeName(int portType) {
        switch (portType) {
            case 3: {
                return "I2C";
            }
            case 2: {
                return "Parallel";
            }
            case 5: {
                return "Raw";
            }
            case 4: {
                return "RS485";
            }
            case 1: {
                return "Serial";
            }
        }
        return "unknown type";
    }
}

