/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos;

import org.openconcerto.erp.core.sales.pos.io.DefaultTicketPrinter;
import org.openconcerto.erp.core.sales.pos.io.ESCSerialPrinter;
import org.openconcerto.erp.core.sales.pos.io.ESCStandardPrinter;
import org.openconcerto.erp.core.sales.pos.io.JPOSTicketPrinter;
import org.openconcerto.erp.core.sales.pos.io.TicketPrinter;

public class TicketPrinterConfiguration {
    public static final String STANDARD_PRINTER = "std";
    public static final String SERIAL_PRINTER = "serial";
    public static final String JPOS_PRINTER = "jpos";
    private String type = "std";
    private int ticketWidth = 42;
    private int copyCount = 2;
    private String name = "";
    private String folder = "";

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (!(STANDARD_PRINTER.equals(type) || SERIAL_PRINTER.equals(type) || JPOS_PRINTER.equals(type))) {
            throw new IllegalArgumentException("Unknown type " + type);
        }
        this.type = type;
    }

    public int getTicketWidth() {
        return this.ticketWidth;
    }

    public void setTicketWidth(int ticketWidth) {
        if (ticketWidth < 10) {
            throw new IllegalArgumentException("Invalid " + ticketWidth);
        }
        this.ticketWidth = ticketWidth;
    }

    public int getCopyCount() {
        return this.copyCount;
    }

    public void setCopyCount(int copyCount) {
        if (copyCount < 0) {
            throw new IllegalArgumentException("Negative copy count " + copyCount);
        }
        this.copyCount = copyCount;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public TicketPrinter createTicketPrinter() {
        DefaultTicketPrinter prt;
        if (STANDARD_PRINTER.equals(this.getType())) {
            prt = new ESCStandardPrinter(this.getName());
        } else if (SERIAL_PRINTER.equals(this.getType())) {
            prt = new ESCSerialPrinter(this.getName());
        } else if (JPOS_PRINTER.equals(this.getType())) {
            prt = new JPOSTicketPrinter(this.getName());
        } else {
            throw new IllegalStateException("Unknown type " + this.getType());
        }
        return prt;
    }

    public boolean isValid() {
        return this.getName() != null && !this.getName().isEmpty();
    }
}

