/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.action;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.table.TableColumn;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.erp.core.common.ui.IListTotalPanel;
import org.openconcerto.erp.core.finance.accounting.ui.ListeGestCommEltPanel;
import org.openconcerto.erp.core.sales.invoice.ui.DateEnvoiRenderer;
import org.openconcerto.erp.core.sales.invoice.ui.DateReglementRenderer;
import org.openconcerto.erp.core.sales.invoice.ui.ListeFactureRenderer;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelColumnPath;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.table.TimestampTableCellEditor;
import org.openconcerto.utils.cc.IClosure;

public class ListeSaisieVenteFactureAction
extends CreateFrameAbstractAction {
    private IListFrame frame;
    private ListeGestCommEltPanel listeAddPanel;
    private boolean filterOnCurrentYear = false;
    private boolean reglementEditable = true;

    public ListeSaisieVenteFactureAction() {
        this(false, true);
    }

    public ListeSaisieVenteFactureAction(boolean filterOnCurrentYear, boolean reglementEditable) {
        this.putValue("Name", "Liste des factures");
        this.filterOnCurrentYear = filterOnCurrentYear;
        this.reglementEditable = reglementEditable;
    }

    @Override
    public JFrame createFrame() {
        SQLElement eltFacture = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
        SQLTableModelSourceOnline src = eltFacture.getTableSource(true);
        for (SQLTableModelColumn column : src.getColumns()) {
            column.setRenderer(ListeFactureRenderer.UTILS.getRenderer(column.getRenderer()));
            if (!column.getClass().isAssignableFrom(SQLTableModelColumnPath.class)) continue;
            ((SQLTableModelColumnPath)column).setEditable(false);
        }
        SQLTableModelColumn dateEnvoiCol = src.getColumn(eltFacture.getTable().getField("DATE_ENVOI"));
        if (dateEnvoiCol != null) {
            ((SQLTableModelColumnPath)dateEnvoiCol).setEditable(this.reglementEditable);
            dateEnvoiCol.setColumnInstaller(new IClosure<TableColumn>(){

                @Override
                public void executeChecked(TableColumn columnDateEnvoi) {
                    columnDateEnvoi.setCellEditor(new TimestampTableCellEditor());
                    columnDateEnvoi.setCellRenderer(new DateEnvoiRenderer());
                }
            });
        }
        SQLTableModelColumn dateReglCol = src.getColumn(eltFacture.getTable().getField("DATE_REGLEMENT"));
        ((SQLTableModelColumnPath)dateReglCol).setEditable(this.reglementEditable);
        dateReglCol.setColumnInstaller(new IClosure<TableColumn>(){

            @Override
            public void executeChecked(TableColumn columnDateReglement) {
                columnDateReglement.setCellEditor(new TimestampTableCellEditor());
                columnDateReglement.setCellRenderer(new DateReglementRenderer());
            }
        });
        this.listeAddPanel = new ListeGestCommEltPanel(eltFacture, new IListe(src)){

            @Override
            protected GridBagConstraints createConstraints() {
                GridBagConstraints c = super.createConstraints();
                ++c.gridy;
                return c;
            }
        };
        this.listeAddPanel.setAddVisible(true);
        this.listeAddPanel.getListe().getModel().setEditable(true);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 0;
        c.fill = 0;
        c.anchor = 13;
        c.weightx = 1.0;
        c.gridy = 4;
        JPanel panelTotal = new JPanel(new FlowLayout());
        String sfe = DefaultNXProps.getInstance().getStringProperty("ArticleSFE");
        Boolean bSfe = Boolean.valueOf(sfe);
        boolean isSFE = bSfe != null && bSfe != false;
        ArrayList<SQLField> fields = new ArrayList<SQLField>(2);
        if (isSFE) {
            fields.add(eltFacture.getTable().getField("T_HA"));
        }
        fields.add(eltFacture.getTable().getField("T_HT"));
        fields.add(eltFacture.getTable().getField("T_TTC"));
        IListTotalPanel totalPanel = new IListTotalPanel(this.listeAddPanel.getListe(), IListTotalPanel.initListe(this.listeAddPanel.getListe(), fields), null, "Total Global");
        panelTotal.add(totalPanel);
        this.listeAddPanel.add((Component)panelTotal, c);
        IListFilterDatePanel datePanel = new IListFilterDatePanel(this.listeAddPanel.getListe(), eltFacture.getTable().getField("DATE"), IListFilterDatePanel.getDefaultMap());
        ++c.gridy;
        c.anchor = 10;
        this.listeAddPanel.add((Component)datePanel, c);
        if (this.filterOnCurrentYear) {
            datePanel.setFilterOnDefault();
        }
        this.frame = new IListFrame(this.listeAddPanel);
        return this.frame;
    }

    public List<Integer> getListId() {
        IListe liste = this.listeAddPanel.getListe();
        if (liste != null) {
            ArrayList<Integer> listeIds = new ArrayList<Integer>(liste.getRowCount());
            int i = 0;
            while (i < liste.getRowCount()) {
                listeIds.add(liste.idFromIndex(i));
                ++i;
            }
            return listeIds;
        }
        return null;
    }

    private JPanel getPanelLegende() {
        JPanel panelLegende = new JPanel();
        JLabel labelLeg = new JLabel("L\u00e9gende : ");
        labelLeg.setOpaque(true);
        panelLegende.add(labelLeg);
        JLabel labelAcompte = new JLabel("  Acompte ");
        labelAcompte.setOpaque(true);
        labelAcompte.setBackground(ListeFactureRenderer.acompte);
        Border lineBorder = BorderFactory.createEtchedBorder();
        labelAcompte.setBorder(lineBorder);
        panelLegende.add(labelAcompte);
        JLabel labelCompl = new JLabel("  Compl\u00e9ment ");
        labelCompl.setOpaque(true);
        labelCompl.setBackground(ListeFactureRenderer.complement);
        labelCompl.setBorder(lineBorder);
        panelLegende.add(labelCompl);
        JLabel labelPrev = new JLabel("  Pr\u00e9visionnelle ");
        labelPrev.setOpaque(true);
        labelPrev.setBackground(ListeFactureRenderer.prev);
        labelPrev.setBorder(lineBorder);
        panelLegende.add(labelPrev);
        return panelLegende;
    }
}

