/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.report;

import java.util.Calendar;
import org.openconcerto.erp.generationDoc.AbstractSheetXMLWithDate;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;

public class FichePayeSheetXML
extends AbstractSheetXMLWithDate {
    public static final String TEMPLATE_ID = "FichePaye";
    public static final String TEMPLATE_PROPERTY_NAME = "LocationFichePaye";

    public FichePayeSheetXML(SQLRow row) {
        super(row);
        this.printer = PrinterNXProps.getInstance().getStringProperty("FichePayePrinter");
        this.elt = Configuration.getInstance().getDirectory().getElement("FICHE_PAYE");
    }

    @Override
    public String getDefaultTemplateId() {
        return TEMPLATE_ID;
    }

    @Override
    public String getName() {
        SQLRow rowSal = this.row.getForeign("ID_SALARIE");
        SQLRow rowMois = this.row.getForeign("ID_MOIS");
        Calendar du = this.row.getDate("DU");
        String suffix = "";
        if (du != null && du.get(5) != 1) {
            suffix = "_" + du.get(5);
        }
        return "FichePaye_" + rowSal.getString("CODE") + suffix + "_" + rowMois.getString("NOM") + "_" + this.row.getString("ANNEE");
    }
}

