/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.tree.TreePath;
import org.openconcerto.erp.core.common.ui.JNiceButton;
import org.openconcerto.erp.core.humanresources.payroll.component.VariableRowTreeNode;
import org.openconcerto.erp.core.humanresources.payroll.ui.ProfilPayeModel;
import org.openconcerto.erp.model.RubriquePayeTree;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.ConfSQLElement;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.table.AlternateTableCellRenderer;
import org.openconcerto.utils.ListMap;

public class ProfilPayeSQLElement
extends ConfSQLElement {
    public ProfilPayeSQLElement() {
        super("PROFIL_PAYE", "un profil de paye", "profils de paye");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        return l;
    }

    @Override
    public ListMap<String, String> getShowAs() {
        return ListMap.singleton(null, "NOM");
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            private ProfilPayeModel model;
            private JTextField nom;

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                JLabel labelNom = new JLabel(this.getLabelFor("NOM"));
                labelNom.setHorizontalAlignment(4);
                this.add((Component)labelNom, c);
                this.nom = new JTextField();
                ++c.gridx;
                this.add((Component)this.nom, c);
                final RubriquePayeTree treeRubrique = new RubriquePayeTree();
                JPanel panelLeft = new JPanel();
                panelLeft.setLayout(new GridBagLayout());
                c.gridx = 0;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.fill = 1;
                c.gridheight = 0;
                panelLeft.add((Component)new JScrollPane(treeRubrique), c);
                JPanel panelRight = new JPanel();
                panelRight.setLayout(new GridBagLayout());
                c.fill = 2;
                c.gridheight = 1;
                c.weightx = 0.0;
                c.weighty = 0.0;
                c.gridx = 0;
                c.gridy = 0;
                JLabelBold labelContenu = new JLabelBold("Contenu du profil");
                panelRight.add((Component)labelContenu, c);
                c.fill = 0;
                JNiceButton boutonUp = new JNiceButton(IListFrame.class.getResource("fleche_haut.png"));
                ++c.gridx;
                panelRight.add((Component)boutonUp, c);
                JNiceButton boutonDown = new JNiceButton(IListFrame.class.getResource("fleche_bas.png"));
                ++c.gridx;
                panelRight.add((Component)boutonDown, c);
                JNiceButton boutonSuppr = new JNiceButton(ConfSQLElement.class.getResource("delete.png"));
                ++c.gridx;
                panelRight.add((Component)boutonSuppr, c);
                c.fill = 2;
                this.model = new ProfilPayeModel(this.getSelectedID());
                final JTable tableProfil = new JTable(this.model);
                tableProfil.setDefaultRenderer(String.class, AlternateTableCellRenderer.createDefault());
                ++c.gridy;
                c.gridx = 0;
                c.gridwidth = 0;
                c.fill = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                panelRight.add((Component)new JScrollPane(tableProfil), c);
                c.gridx = 0;
                c.gridy = 1;
                c.gridwidth = 0;
                c.fill = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                this.add((Component)new JSplitPane(1, panelLeft, panelRight), c);
                treeRubrique.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent mE) {
                        if (mE.getClickCount() == 2 && mE.getButton() == 1) {
                            TreePath path = treeRubrique.getClosestPathForLocation(mE.getPoint().x, mE.getPoint().y);
                            Object obj = path.getLastPathComponent();
                            if (obj == null) {
                                return;
                            }
                            if (obj instanceof VariableRowTreeNode) {
                                model.addRowAt(((VariableRowTreeNode)obj).getRow(), tableProfil.getSelectedRow());
                            } else {
                                return;
                            }
                        }
                    }
                });
                boutonUp.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int selectRow = model.upRow(tableProfil.getSelectedRow());
                        if (selectRow > 0) {
                            tableProfil.setRowSelectionInterval(selectRow, selectRow);
                        }
                    }
                });
                boutonDown.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int selectRow = model.downRow(tableProfil.getSelectedRow());
                        if (selectRow > 0) {
                            tableProfil.setRowSelectionInterval(selectRow, selectRow);
                        }
                    }
                });
                boutonSuppr.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        model.removeRow(tableProfil.getSelectedRow());
                    }
                });
                this.addRequiredSQLObject(this.nom, "NOM");
            }

            @Override
            public int insert(SQLRow order) {
                int id = super.insert(order);
                this.model.updateFields(id);
                return id;
            }

            @Override
            public void update() {
                this.model.updateFields(this.getSelectedID());
                super.update();
            }

            @Override
            public void select(SQLRowAccessor r) {
                super.select(r);
                if (r != null) {
                    this.model.selectID(r.getID());
                }
            }
        };
    }

    @Override
    protected String createCode() {
        return "humanresources.payroll.template";
    }
}

