/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.edm;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.openconcerto.erp.core.common.ui.ScrollablePanel;
import org.openconcerto.erp.core.edm.AttachmentUtils;
import org.openconcerto.erp.core.edm.FilePanel;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.SwingThreadUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;

public class AttachmentPanel
extends JPanel {
    private final SQLRowAccessor rowSource;
    private List<ListDataListener> listeners = new ArrayList<ListDataListener>();

    public AttachmentPanel(SQLRowAccessor rowSource) {
        this.rowSource = rowSource;
        this.setLayout(new GridBagLayout());
        this.initUI();
        this.setFocusable(true);
    }

    public void addListener(ListDataListener l) {
        this.listeners.add(l);
    }

    public void removeListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    public void fireDataChanged() {
        for (ListDataListener listDataListener : this.listeners) {
            listDataListener.contentsChanged(new ListDataEvent(this, 0, 0, 0));
        }
    }

    public void initUI() {
        this.invalidate();
        this.removeAll();
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        SQLTable tableAttachment = this.rowSource.getTable().getTable("ATTACHMENT");
        SQLRowValues rowVals = new SQLRowValues(tableAttachment);
        rowVals.putNulls(tableAttachment.getFieldsName());
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowVals);
        Where where = new Where((FieldRef)tableAttachment.getField("SOURCE_TABLE"), "=", (Object)this.rowSource.getTable().getName());
        where = where.and(new Where((FieldRef)tableAttachment.getField("SOURCE_ID"), "=", this.rowSource.getID()));
        List<SQLRowValues> attachments = fetcher.fetch(where);
        JButton addButton = new JButton("Ajouter un fichier");
        this.add((Component)addButton, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        JProgressBar progressBar = new JProgressBar(0, 100);
        progressBar.setValue(100);
        progressBar.setStringPainted(true);
        progressBar.setVisible(false);
        this.add((Component)progressBar, c);
        c.fill = 1;
        c.gridx = 0;
        ++c.gridy;
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Frame frame = SwingThreadUtils.getAncestorOrSelf(Frame.class, (Component)e.getSource());
                FileDialog fd = new FileDialog(frame, "Ajouter un fichier", 0);
                fd.setVisible(true);
                String fileName = fd.getFile();
                if (fileName != null) {
                    File inFile = new File(fd.getDirectory(), fileName);
                    AttachmentUtils utils = new AttachmentUtils();
                    utils.uploadFile(inFile, AttachmentPanel.this.rowSource);
                    AttachmentPanel.this.initUI();
                }
            }
        });
        ScrollablePanel files = new ScrollablePanel(){

            @Override
            public Dimension getPreferredSize() {
                int nbRow;
                int w = this.getSize().width;
                int nbPerRow = (w - 5) / 133;
                if (nbPerRow < 1) {
                    nbPerRow = 1;
                }
                if ((nbRow = 1 + this.getComponentCount() / nbPerRow) < 1) {
                    nbRow = 1;
                }
                return new Dimension(w, 5 + nbRow * 85);
            }
        };
        files.setOpaque(true);
        files.setBackground(Color.WHITE);
        files.setScrollableWidth(ScrollablePanel.ScrollableSizeHint.FIT);
        files.setScrollableHeight(ScrollablePanel.ScrollableSizeHint.NONE);
        files.setLayout(new FlowLayout(0, 5, 5));
        for (final SQLRowValues sqlRowValues : attachments) {
            FilePanel filePanel = new FilePanel(sqlRowValues, this);
            filePanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        Thread t = new Thread(){

                            @Override
                            public void run() {
                                AttachmentUtils utils = new AttachmentUtils();
                                File f = utils.getFile(sqlRowValues);
                                if (f == null) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            JOptionPane.showMessageDialog(null, "Impossible de r\u00e9cup\u00e9rer le fichier.", "Erreur", 0);
                                        }
                                    });
                                    System.err.println("Impossible de r\u00e9cup\u00e9rer le fichier.");
                                } else {
                                    try {
                                        FileUtils.openFile(f);
                                    }
                                    catch (IOException e1) {
                                        ExceptionHandler.handle("Erreur lors de l'ouverture du fichier.", e1);
                                    }
                                }
                            }
                        };
                        t.start();
                    }
                }
            });
            files.add(filePanel);
        }
        c.gridwidth = 2;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JScrollPane scroll = new JScrollPane(files);
        scroll.setHorizontalScrollBarPolicy(31);
        scroll.setVerticalScrollBarPolicy(22);
        scroll.setMinimumSize(new Dimension(647, 400));
        scroll.setPreferredSize(new Dimension(647, 400));
        scroll.setBackground(Color.WHITE);
        scroll.getViewport().setBackground(Color.WHITE);
        this.add((Component)scroll, c);
        this.validate();
        this.repaint();
        DropTarget dt = new DropTarget(){

            @Override
            public synchronized void drop(DropTargetDropEvent dtde) {
                dtde.acceptDrop(3);
                Transferable t = dtde.getTransferable();
                try {
                    if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        List fileList = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                        AttachmentUtils utils = new AttachmentUtils();
                        boolean cancelledByUser = false;
                        for (File f : fileList) {
                            if (cancelledByUser) break;
                            utils.uploadFile(f, AttachmentPanel.this.rowSource);
                        }
                        AttachmentPanel.this.initUI();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        files.setDropTarget(dt);
        scroll.getViewport().setDropTarget(dt);
        this.fireDataChanged();
    }
}

