/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.ui.state.ListenerXMLStateManager;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.Tuple2;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class IListFilterDateStateManager
extends ListenerXMLStateManager<IListFilterDatePanel, PropertyChangeListener> {
    DateFormat format = DateFormat.getDateInstance(0);

    public IListFilterDateStateManager(IListFilterDatePanel p, File f) {
        this(p, f, true);
    }

    public IListFilterDateStateManager(IListFilterDatePanel p, File f, boolean autosave) {
        super(p, f, autosave);
    }

    @Override
    protected void addListener(PropertyChangeListener l) {
        ((IListFilterDatePanel)this.getSrc()).addValueListener(l);
    }

    @Override
    protected PropertyChangeListener createListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                IListFilterDateStateManager.this.save();
            }
        };
    }

    @Override
    protected void rmListener(PropertyChangeListener l) {
        ((IListFilterDatePanel)this.getSrc()).rmValueListener(l);
    }

    protected final void save() {
        try {
            this.saveState();
        }
        catch (IOException exn) {
            ExceptionHandler.handle((Component)this.getSrc(), "Impossible de sauvegarder l'\u00e9tat du filtre de p\u00e9riode.", exn);
        }
    }

    @Override
    protected void writeState(BufferedWriter out) throws IOException {
        out.write("<filter>\n");
        out.write("<value");
        Date fromValue = ((IListFilterDatePanel)this.getSrc()).getFromValue();
        out.write(" from=\"" + (fromValue == null ? "" : this.format.format(fromValue)) + "\"");
        Date toValue = ((IListFilterDatePanel)this.getSrc()).getToValue();
        out.write(" to=\"" + (toValue == null ? "" : this.format.format(toValue)) + "\"");
        out.write("/>\n");
        out.write("</filter>\n");
    }

    @Override
    protected boolean readState(Document doc) {
        Tuple2<Date, Date> period;
        try {
            period = this.getPeriod(doc);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
        ((IListFilterDatePanel)this.getSrc()).setPeriode(period);
        return true;
    }

    private Tuple2<Date, Date> getPeriod(Document doc) throws ParseException {
        Node filter = doc.getElementsByTagName("value").item(0);
        String sDate1 = filter.getAttributes().getNamedItem("from").getNodeValue();
        Date d1 = sDate1 == null || sDate1.trim().length() == 0 ? null : this.format.parse(sDate1);
        String sDate2 = filter.getAttributes().getNamedItem("to").getNodeValue();
        Date d2 = sDate2 == null || sDate2.trim().length() == 0 ? null : this.format.parse(sDate2);
        return Tuple2.create(d1, d2);
    }
}

