/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.math.BigDecimal;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.openconcerto.erp.core.common.ui.Acompte;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.sqlobject.itemview.RowItemViewComponent;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.doc.Documented;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class AcompteField
extends JTextField
implements RowItemViewComponent,
ValueWrapper<Acompte>,
Documented {
    private SQLField field;
    private BigDecimal total;
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);
    private boolean gained = false;
    private boolean mousePressed;
    private String initialText;

    public AcompteField() {
        this(15);
    }

    private AcompteField(int columns) {
        super(columns);
        this.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                AcompteField.this.textModified();
            }
        });
        this.init();
    }

    public void setTotal(BigDecimal total) {
        this.total = total;
    }

    public BigDecimal getTotal() {
        return this.total;
    }

    protected void textModified() {
        this.supp.firePropertyChange("value", null, this.getValue());
    }

    @Override
    public void init(SQLRowItemView v) {
        this.field = v.getFields().get(0);
    }

    private void init() {
        AcompteField.addFilteringKeyListener(this);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AcompteField.this.gained = true;
                AcompteField.this.initialText = AcompteField.this.getText();
                if (!AcompteField.this.mousePressed) {
                    AcompteField.this.selectAll();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                AcompteField.this.mousePressed = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (AcompteField.this.gained && AcompteField.this.getSelectedText() == null) {
                    AcompteField.this.selectAll();
                }
                AcompteField.this.gained = false;
                AcompteField.this.mousePressed = false;
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\u001b') {
                    AcompteField.this.setValue(AcompteField.this.initialText);
                    AcompteField.this.selectAll();
                }
            }
        });
    }

    public static void addFilteringKeyListener(AcompteField textField) {
        textField.addKeyListener(new KeyAdapter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void keyTyped(KeyEvent keyEvent) {
                char keychar = keyEvent.getKeyChar();
                if (keychar == '\b') {
                    return;
                }
                int pointPosition = AcompteField.this.getText().indexOf(46);
                if (Character.isDigit(keychar)) {
                    if (pointPosition <= -1) return;
                    if (AcompteField.this.getSelectedText() != null) return;
                    if (AcompteField.this.getCaretPosition() <= pointPosition) {
                        return;
                    }
                    if (AcompteField.this.getText().substring(pointPosition).length() <= 6) {
                        return;
                    }
                }
                if (keychar == '.' && AcompteField.this.getText().indexOf(46) < 0) {
                    return;
                }
                if (keychar == '%' && AcompteField.this.getText().indexOf(37) < 0 && AcompteField.this.getCaretPosition() > 0 && AcompteField.this.getCaretPosition() == AcompteField.this.getText().length()) {
                    return;
                }
                keyEvent.consume();
            }
        });
    }

    @Override
    public final void resetValue() {
        this.setValue((Acompte)null);
    }

    @Override
    public void setValue(Acompte val) {
        this.setValue(val == null ? "" : val.toString());
    }

    @Override
    private final void setValue(String val) {
        if (!this.getText().equals(val)) {
            this.setText(val);
        }
    }

    public void setBold() {
        this.setFont(this.getFont().deriveFont(1));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Acompte getValue() {
        return Acompte.fromString(this.getText().trim());
    }

    @Override
    public void addValueListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(l);
    }

    @Override
    public void rmValueListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(l);
    }

    public SQLField getField() {
        return this.field;
    }

    @Override
    public ValidState getValidState() {
        return ValidState.getTrueInstance();
    }

    @Override
    public void addValidListener(ValidListener l) {
    }

    @Override
    public void removeValidListener(ValidListener l) {
    }

    @Override
    public JComponent getComp() {
        return this;
    }

    @Override
    public String getDocId() {
        return "ACOMPTE";
    }

    @Override
    public String getGenericDoc() {
        return "";
    }

    @Override
    public boolean onScreen() {
        return true;
    }

    @Override
    public boolean isDocTransversable() {
        return false;
    }
}

