/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.AbstractArticleItemTable;
import org.openconcerto.erp.core.common.ui.Acompte;
import org.openconcerto.erp.core.common.ui.AcompteCellEditor;
import org.openconcerto.erp.core.common.ui.DeviseNumericCellEditor;
import org.openconcerto.erp.core.common.ui.DeviseNumericHTConvertorCellEditor;
import org.openconcerto.erp.core.common.ui.DeviseTableCellRenderer;
import org.openconcerto.erp.core.common.ui.NiveauTableCellEditor;
import org.openconcerto.erp.core.common.ui.NiveauTableCellRender;
import org.openconcerto.erp.core.common.ui.QteCellEditor;
import org.openconcerto.erp.core.common.ui.Remise;
import org.openconcerto.erp.core.finance.accounting.model.CurrencyConverter;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.pos.io.BarcodeReader;
import org.openconcerto.erp.core.sales.pos.ui.BarcodeListener;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.sales.product.model.ProductComponent;
import org.openconcerto.erp.core.sales.product.model.ProductHelper;
import org.openconcerto.erp.core.sales.product.ui.ArticleRowValuesRenderer;
import org.openconcerto.erp.core.sales.product.ui.CurrencyWithSymbolRenderer;
import org.openconcerto.erp.core.sales.product.ui.QteMultipleRowValuesRenderer;
import org.openconcerto.erp.core.sales.product.ui.QteUnitRowValuesRenderer;
import org.openconcerto.erp.importer.ArrayTableModel;
import org.openconcerto.erp.importer.DataImporter;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.sqlobject.ITextArticleWithCompletionCellEditor;
import org.openconcerto.sql.users.rights.UserRights;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.list.AutoCompletionManager;
import org.openconcerto.sql.view.list.CellDynamicModifier;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.sql.view.list.SQLTextComboTableCellEditor;
import org.openconcerto.sql.view.list.ValidStateChecker;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.Tuple3;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.i18n.TranslationManager;

public abstract class AbstractVenteArticleItemTable
extends AbstractArticleItemTable {
    public static final String ARTICLE_SHOW_DEVISE = "ArticleShowDevise";
    public static final String ARTICLE_SERVICE = "ArticleService";
    public static final String EDIT_PRIX_VENTE_CODE = "CORPS_EDITER_PRIX_VENTE";
    public static final String SHOW_PRIX_ACHAT_CODE = "CORPS_VOIR_PRIX_ACHAT";
    public static final String LOCK_PRIX_MIN_VENTE_CODE = "CORPS_VERROU_PRIX_MIN_VENTE";
    SQLTableElement tableElementFacturable;
    protected SQLTableElement tableElementRemise;
    private static Map<String, Boolean> visibilityMap = new HashMap<String, Boolean>();
    private SQLTable tableArticleTarif = Configuration.getInstance().getBase().getTable("ARTICLE_TARIF");
    private SQLTable tableArticle = Configuration.getInstance().getBase().getTable("ARTICLE");

    public AbstractVenteArticleItemTable() {
    }

    public AbstractVenteArticleItemTable(List<JButton> buttons) {
        super(buttons);
    }

    protected boolean isCellNiveauEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
        RowValuesTableModel model = this.getModel();
        int niveau = vals.getInt("NIVEAU");
        return rowIndex + 1 == model.getRowCount() || niveau >= model.getRowValuesAt(rowIndex + 1).getInt("NIVEAU");
    }

    public void calculPourcentage(final Acompte a, final TypeCalcul type) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SQLTableElement tableElement = type == TypeCalcul.CALCUL_FACTURABLE ? (this).AbstractVenteArticleItemTable.this.tableElementFacturable : (this).AbstractVenteArticleItemTable.this.tableElementRemise;
                        RowValuesTableModel model = AbstractVenteArticleItemTable.this.getModel();
                        if (a == null) {
                            int i = 0;
                            while (i < model.getRowCount()) {
                                model.putValue(null, i, type.getFieldMontant());
                                model.putValue(null, i, type.getFieldPourcent());
                                tableElement.fireModification(model.getRowValuesAt(i));
                                ++i;
                            }
                        } else if (a.getPercent() != null) {
                            int i = 0;
                            while (i < model.getRowCount()) {
                                model.putValue(a.getPercent(), i, type.getFieldPourcent());
                                model.putValue(null, i, type.getFieldMontant());
                                tableElement.fireModification(model.getRowValuesAt(i));
                                ++i;
                            }
                        } else {
                            Remise remise;
                            BigDecimal acompteMontant;
                            BigDecimal acomptePercent;
                            BigDecimal totalLine;
                            BigDecimal pU;
                            BigDecimal qteU;
                            int qte;
                            BigDecimal totalHT = BigDecimal.ZERO;
                            for (SQLRowValues rowVals : AbstractVenteArticleItemTable.this.getRowValuesAtLevel(1)) {
                                qte = rowVals.getInt("QTE");
                                qteU = rowVals.getBigDecimal("QTE_UNITAIRE");
                                pU = rowVals.getBigDecimal("PV_HT");
                                totalLine = pU.multiply(qteU, DecimalUtils.HIGH_PRECISION).multiply(new BigDecimal(qte), DecimalUtils.HIGH_PRECISION).setScale(2, RoundingMode.HALF_UP);
                                if (type == TypeCalcul.CALCUL_FACTURABLE && rowVals.getTable().getFieldsName().contains("MONTANT_REMISE")) {
                                    acomptePercent = rowVals.getBigDecimal("POURCENT_REMISE");
                                    acompteMontant = rowVals.getBigDecimal("MONTANT_REMISE");
                                    remise = new Remise(acomptePercent, acompteMontant);
                                    totalLine = remise.getResultFrom(totalLine);
                                }
                                totalHT = totalHT.add(totalLine);
                            }
                            int i = 0;
                            while (i < model.getRowCount()) {
                                if (model.getRowValuesAt(i).getInt("NIVEAU") == 1) {
                                    model.putValue(null, i, type.getFieldPourcent());
                                    SQLRowValues rowVals = model.getRowValuesAt(i);
                                    qte = rowVals.getInt("QTE");
                                    qteU = rowVals.getBigDecimal("QTE_UNITAIRE");
                                    pU = rowVals.getBigDecimal("PV_HT");
                                    totalLine = pU.multiply(qteU, DecimalUtils.HIGH_PRECISION).multiply(new BigDecimal(qte), DecimalUtils.HIGH_PRECISION).setScale(2, RoundingMode.HALF_UP);
                                    if (rowVals.getTable().getFieldsName().contains("MONTANT_REMISE")) {
                                        acomptePercent = rowVals.getBigDecimal("POURCENT_REMISE");
                                        acompteMontant = rowVals.getBigDecimal("MONTANT_REMISE");
                                        remise = new Remise(acomptePercent, acompteMontant);
                                        totalLine = remise.getResultFrom(totalLine);
                                    }
                                    BigDecimal percent = totalHT.signum() != 0 ? totalLine.divide(totalHT, DecimalUtils.HIGH_PRECISION) : BigDecimal.ZERO;
                                    model.putValue(a.getMontant().multiply(percent, DecimalUtils.HIGH_PRECISION).setScale(6, RoundingMode.HALF_UP), i, type.getFieldMontant());
                                    tableElement.fireModification(model.getRowValuesAt(i));
                                }
                                ++i;
                            }
                        }
                        model.fireTableDataChanged();
                    }
                });
            }
        };
        this.getModel().submit(r);
    }

    public static Map<String, Boolean> getVisibilityMap() {
        return visibilityMap;
    }

    @Override
    protected void init() {
        BarcodeReader barcodeReader;
        SQLTableElement marge;
        SQLPreferences prefs = SQLPreferences.getMemCached(this.getSQLElement().getTable().getDBRoot());
        boolean selectArticle = prefs.getBoolean(GestionArticleGlobalPreferencePanel.USE_CREATED_ARTICLE, false);
        final boolean filterFamilleArticle = prefs.getBoolean(GestionArticleGlobalPreferencePanel.FILTER_BY_FAMILY, false);
        boolean createAuto = prefs.getBoolean(GestionArticleGlobalPreferencePanel.CREATE_ARTICLE_AUTO, true);
        boolean showEco = prefs.getBoolean(SHOW_ECO_CONTRIBUTION_COLUMNS, false);
        UserRights rights = UserRightsManager.getCurrentUserRights();
        final boolean editVTPrice = rights.haveRight(EDIT_PRIX_VENTE_CODE);
        boolean showHAPrice = rights.haveRight(SHOW_PRIX_ACHAT_CODE);
        final boolean lockVTMinPrice = rights.haveRight(LOCK_PRIX_MIN_VENTE_CODE);
        SQLElement e = this.getSQLElement();
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        SQLTableElement eNiveau = new SQLTableElement(e.getTable().getField("NIVEAU")){

            @Override
            public void setValueFrom(SQLRowValues row, Object value) {
                super.setValueFrom(row, value);
            }
        };
        eNiveau.setRenderer(new NiveauTableCellRender());
        eNiveau.setEditor(new NiveauTableCellEditor());
        list.add(eNiveau);
        list.add(new SQLTableElement(e.getTable().getField("ID_STYLE")));
        SQLTableElement tableFamille = new SQLTableElement(e.getTable().getField("ID_FAMILLE_ARTICLE"));
        list.add(tableFamille);
        SQLTableElement tableElementArticle = new SQLTableElement(e.getTable().getField("ID_ARTICLE"), true, true, true);
        list.add(tableElementArticle);
        if (e.getTable().getFieldsName().contains("ID_ECO_CONTRIBUTION")) {
            this.tableElementEcoID = new SQLTableElement(e.getTable().getField("ID_ECO_CONTRIBUTION"));
            list.add(this.tableElementEcoID);
        }
        SQLTableElement tableElementCode = new SQLTableElement(e.getTable().getField("CODE"), String.class, new ITextArticleWithCompletionCellEditor(e.getTable().getTable("ARTICLE"), e.getTable().getTable("ARTICLE_FOURNISSEUR")));
        list.add(tableElementCode);
        SQLTableElement tableElementNom = new SQLTableElement(e.getTable().getField("NOM"));
        list.add(tableElementNom);
        if (e.getTable().getFieldsName().contains("COLORIS")) {
            SQLTableElement tableElementColoris = new SQLTableElement(e.getTable().getField("COLORIS"));
            list.add(tableElementColoris);
        }
        if (e.getTable().getFieldsName().contains("DESCRIPTIF")) {
            SQLTableElement tableElementDesc = new SQLTableElement(e.getTable().getField("DESCRIPTIF"));
            list.add(tableElementDesc);
        }
        if (DefaultNXProps.getInstance().getBooleanValue(ARTICLE_SHOW_DEVISE, false)) {
            SQLTableElement tableElementCodeDouane = new SQLTableElement(e.getTable().getField("CODE_DOUANIER"));
            list.add(tableElementCodeDouane);
        }
        if (DefaultNXProps.getInstance().getBooleanValue(ARTICLE_SHOW_DEVISE, false)) {
            SQLTableElement tableElementPays = new SQLTableElement(e.getTable().getField("ID_PAYS"));
            list.add(tableElementPays);
        }
        SQLTableElement tableElement_ValeurMetrique2 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_2"), Float.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                Number modeNumber = (Number)vals.getObject("ID_MODE_VENTE_ARTICLE");
                if (modeNumber != null && (modeNumber.intValue() == 5 || modeNumber.intValue() == 4 || modeNumber.intValue() == 2)) {
                    return false;
                }
                return super.isCellEditable(vals, rowIndex, columnIndex);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new ArticleRowValuesRenderer(null);
            }
        };
        list.add(tableElement_ValeurMetrique2);
        SQLTableElement tableElement_ValeurMetrique3 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_3"), Float.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                Number modeNumber = (Number)vals.getObject("ID_MODE_VENTE_ARTICLE");
                if (modeNumber != null && modeNumber.intValue() != 4) {
                    return false;
                }
                return super.isCellEditable(vals, rowIndex, columnIndex);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new ArticleRowValuesRenderer(null);
            }
        };
        list.add(tableElement_ValeurMetrique3);
        SQLTableElement tableElement_ValeurMetrique1 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_1"), Float.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                Number modeNumber = (Number)vals.getObject("ID_MODE_VENTE_ARTICLE");
                if (modeNumber != null && (modeNumber.intValue() == 5 || modeNumber.intValue() == 4 || modeNumber.intValue() == 6)) {
                    return false;
                }
                return super.isCellEditable(vals, rowIndex, columnIndex);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new ArticleRowValuesRenderer(null);
            }
        };
        list.add(tableElement_ValeurMetrique1);
        if (e.getTable().getFieldsName().contains("PREBILAN")) {
            this.prebilan = new SQLTableElement(e.getTable().getField("PREBILAN"), BigDecimal.class){

                @Override
                protected Object getDefaultNullValue() {
                    return BigDecimal.ZERO;
                }

                @Override
                public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                    return AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
                }
            };
            this.prebilan.setRenderer(new DeviseTableCellRenderer());
            list.add(this.prebilan);
        }
        SQLTableElement tableElement_PrixMetrique1_AchatHT = new SQLTableElement(e.getTable().getField("PRIX_METRIQUE_HA_1"), BigDecimal.class){

            @Override
            protected Object getDefaultNullValue() {
                return BigDecimal.ZERO;
            }

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                return AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
            }
        };
        tableElement_PrixMetrique1_AchatHT.setRenderer(new CurrencyWithSymbolRenderer());
        list.add(tableElement_PrixMetrique1_AchatHT);
        SQLTableElement eltDevise = null;
        SQLTableElement eltUnitDevise = null;
        if (DefaultNXProps.getInstance().getBooleanValue(ARTICLE_SHOW_DEVISE, false)) {
            eltDevise = new SQLTableElement(e.getTable().getField("ID_DEVISE"));
            list.add(eltDevise);
            eltUnitDevise = new SQLTableElement(e.getTable().getField("PV_U_DEVISE"), BigDecimal.class){

                @Override
                public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                    return editVTPrice && AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
                }

                @Override
                protected Object getDefaultNullValue() {
                    return BigDecimal.ZERO;
                }
            };
            Path p = (Path)new Path(this.getSQLElement().getTable()).addForeignField("ID_DEVISE");
            eltUnitDevise.setRenderer(new CurrencyWithSymbolRenderer(new FieldPath(p, "CODE")));
            list.add(eltUnitDevise);
        }
        SQLField field = e.getTable().getField("PRIX_METRIQUE_VT_1");
        final DeviseNumericHTConvertorCellEditor editorPVHT = new DeviseNumericHTConvertorCellEditor(field);
        SQLTableElement tableElement_PrixMetrique1_VenteHT = new SQLTableElement(field, BigDecimal.class, editorPVHT){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                return editVTPrice && AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
            }
        };
        tableElement_PrixMetrique1_VenteHT.setRenderer(new CurrencyWithSymbolRenderer());
        list.add(tableElement_PrixMetrique1_VenteHT);
        if (e.getTable().getFieldsName().contains("ECO_CONTRIBUTION")) {
            this.tableElementEco = new SQLTableElement(e.getTable().getField("ECO_CONTRIBUTION"));
            list.add(this.tableElementEco);
        }
        SQLTableElement qteU = new SQLTableElement(e.getTable().getField("QTE_UNITAIRE"), BigDecimal.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                SQLRowAccessor row = vals.getForeign("ID_UNITE_VENTE");
                if (row != null && !row.isUndefined() && row.getBoolean("A_LA_PIECE").booleanValue()) {
                    return false;
                }
                return super.isCellEditable(vals, rowIndex, columnIndex);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new QteUnitRowValuesRenderer();
            }

            @Override
            protected Object getDefaultNullValue() {
                return BigDecimal.ZERO;
            }
        };
        list.add(qteU);
        SQLTableElement uniteVente = new SQLTableElement(e.getTable().getField("ID_UNITE_VENTE"));
        list.add(uniteVente);
        this.qte = new SQLTableElement(e.getTable().getField("QTE"), Integer.class, new QteCellEditor()){

            @Override
            protected Object getDefaultNullValue() {
                return 0;
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                if (AbstractVenteArticleItemTable.this.getSQLElement().getTable().getFieldsName().contains("QTE_ACHAT")) {
                    return new QteMultipleRowValuesRenderer();
                }
                return super.getTableCellRenderer();
            }
        };
        this.qte.setPreferredSize(20);
        list.add(this.qte);
        if (e.getTable().contains("RETOUR_STOCK")) {
            list.add(new SQLTableElement(e.getTable().getField("RETOUR_STOCK")));
        }
        SQLTableElement tableElement_ModeVente = new SQLTableElement(e.getTable().getField("ID_MODE_VENTE_ARTICLE"));
        list.add(tableElement_ModeVente);
        SQLField prixAchatHTField = e.getTable().getField("PA_HT");
        DeviseNumericCellEditor editorPAchatHT = new DeviseNumericCellEditor(prixAchatHTField);
        this.ha = new SQLTableElement(e.getTable().getField("PA_HT"), BigDecimal.class, editorPAchatHT){

            @Override
            protected Object getDefaultNullValue() {
                return BigDecimal.ZERO;
            }

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                return AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
            }
        };
        this.ha = new SQLTableElement(prixAchatHTField, BigDecimal.class, editorPAchatHT){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                return AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
            }
        };
        this.ha.setRenderer(new CurrencyWithSymbolRenderer());
        list.add(this.ha);
        SQLField prixVenteHTField = e.getTable().getField("PV_HT");
        DeviseNumericCellEditor editorPVenteHT = new DeviseNumericCellEditor(prixAchatHTField);
        final SQLTableElement tableElement_PrixVente_HT = new SQLTableElement(prixVenteHTField, BigDecimal.class, editorPVenteHT){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                return editVTPrice && AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
            }
        };
        tableElement_PrixVente_HT.setRenderer(new CurrencyWithSymbolRenderer());
        list.add(tableElement_PrixVente_HT);
        this.tableElementTVA = new SQLTableElement(e.getTable().getField("ID_TAXE"));
        this.tableElementTVA.setPreferredSize(20);
        list.add(this.tableElementTVA);
        SQLTableElement tableElementPoids = new SQLTableElement(e.getTable().getField("POIDS"), Float.class){

            @Override
            protected Object getDefaultNullValue() {
                return Float.valueOf(0.0f);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new QteUnitRowValuesRenderer();
            }
        };
        tableElementPoids.setPreferredSize(20);
        list.add(tableElementPoids);
        this.tableElementPoidsTotal = new SQLTableElement(e.getTable().getField("T_POIDS"), Float.class){

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new QteUnitRowValuesRenderer();
            }
        };
        this.tableElementPoidsTotal.setEditable(false);
        list.add(this.tableElementPoidsTotal);
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.ITEM_PACKAGING, false)) {
            SQLTableElement poidsColis = new SQLTableElement(e.getTable().getField("POIDS_COLIS_NET"), BigDecimal.class){

                @Override
                public TableCellRenderer getTableCellRenderer() {
                    return new QteUnitRowValuesRenderer();
                }
            };
            list.add(poidsColis);
            SQLTableElement nbColis = new SQLTableElement(e.getTable().getField("NB_COLIS"), Integer.class);
            list.add(nbColis);
            final SQLTableElement totalPoidsColis = new SQLTableElement(e.getTable().getField("T_POIDS_COLIS_NET"), BigDecimal.class){

                @Override
                public TableCellRenderer getTableCellRenderer() {
                    return new QteUnitRowValuesRenderer();
                }
            };
            list.add(totalPoidsColis);
            poidsColis.addModificationListener(totalPoidsColis);
            nbColis.addModificationListener(totalPoidsColis);
            totalPoidsColis.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                    Object o2 = row.getObject("POIDS_COLIS_NET");
                    Object o3 = row.getObject("NB_COLIS");
                    if (o2 != null && o3 != null) {
                        BigDecimal poids = (BigDecimal)o2;
                        int nb = (Integer)o3;
                        return poids.multiply(new BigDecimal(nb), DecimalUtils.HIGH_PRECISION).setScale(totalPoidsColis.getDecimalDigits(), RoundingMode.HALF_UP);
                    }
                    return row.getObject("T_POIDS_COLIS_NET");
                }
            });
        }
        if (DefaultNXProps.getInstance().getBooleanValue(ARTICLE_SERVICE, false)) {
            this.service = new SQLTableElement(e.getTable().getField("SERVICE"), Boolean.class);
            list.add(this.service);
        }
        this.totalHT = new SQLTableElement(e.getTable().getField("T_PV_HT"), BigDecimal.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                return AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
            }
        };
        this.totalHT.setRenderer(new CurrencyWithSymbolRenderer());
        this.totalHT.setEditable(false);
        if (e.getTable().getFieldsName().contains("MONTANT_FACTURABLE")) {
            this.tableElementFacturable = new SQLTableElement(e.getTable().getField("POURCENT_FACTURABLE"), Acompte.class, new AcompteCellEditor("POURCENT_FACTURABLE", "MONTANT_FACTURABLE")){

                @Override
                public void setValueFrom(SQLRowValues row, Object value) {
                    if (value != null) {
                        Acompte a = (Acompte)value;
                        row.put("MONTANT_FACTURABLE", a.getMontant());
                        row.put("POURCENT_FACTURABLE", a.getPercent());
                    } else {
                        row.put("MONTANT_FACTURABLE", null);
                        row.put("POURCENT_FACTURABLE", BigDecimal.ONE.movePointRight(2));
                    }
                    this.fireModification(row);
                }
            };
            this.tableElementFacturable.setRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    SQLRowValues rowVals = ((RowValuesTable)table).getRowValuesTableModel().getRowValuesAt(row);
                    JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    BigDecimal percent = rowVals.getBigDecimal("POURCENT_FACTURABLE");
                    BigDecimal amount = rowVals.getBigDecimal("MONTANT_FACTURABLE");
                    Acompte a = new Acompte(percent, amount);
                    label.setText(a.toPlainString(true));
                    return label;
                }
            });
            this.tableElementFacturable.addModificationListener(this.totalHT);
            list.add(this.tableElementFacturable);
        }
        SQLField fieldRemise = e.getTable().getField("POURCENT_REMISE");
        if (e.getTable().getFieldsName().contains("MONTANT_REMISE")) {
            this.tableElementRemise = new SQLTableElement(e.getTable().getField("POURCENT_REMISE"), Acompte.class, new AcompteCellEditor("POURCENT_REMISE", "MONTANT_REMISE")){

                @Override
                public void setValueFrom(SQLRowValues row, Object value) {
                    if (value != null) {
                        Acompte a = (Acompte)value;
                        row.put("MONTANT_REMISE", a.getMontant());
                        row.put("POURCENT_REMISE", a.getPercent());
                    } else {
                        row.put("MONTANT_REMISE", null);
                        row.put("POURCENT_REMISE", BigDecimal.ZERO);
                    }
                    this.fireModification(row);
                }
            };
            this.tableElementRemise.setRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    SQLRowValues rowVals = ((RowValuesTable)table).getRowValuesTableModel().getRowValuesAt(row);
                    JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    BigDecimal percent = rowVals.getBigDecimal("POURCENT_REMISE");
                    BigDecimal amount = rowVals.getBigDecimal("MONTANT_REMISE");
                    Remise a = new Remise(percent, amount);
                    label.setText(a.toPlainString(true));
                    return label;
                }
            });
        } else {
            this.tableElementRemise = new SQLTableElement(fieldRemise){

                @Override
                protected Object getDefaultNullValue() {
                    return BigDecimal.ZERO;
                }
            };
        }
        list.add(this.tableElementRemise);
        SQLTableElement tableElementRG = null;
        if (e.getTable().getFieldsName().contains("POURCENT_RG")) {
            tableElementRG = new SQLTableElement(e.getTable().getField("POURCENT_RG"));
            list.add(tableElementRG);
        }
        this.totalHA = new SQLTableElement(e.getTable().getField("T_PA_HT"), BigDecimal.class);
        this.totalHA.setRenderer(new CurrencyWithSymbolRenderer());
        this.totalHA.setEditable(false);
        list.add(this.totalHA);
        if (DefaultNXProps.getInstance().getBooleanValue(ARTICLE_SHOW_DEVISE, false)) {
            this.tableElementTotalDevise = new SQLTableElement(e.getTable().getField("PV_T_DEVISE"), BigDecimal.class){

                @Override
                public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                    return AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
                }
            };
            Path p = (Path)new Path(this.getSQLElement().getTable()).addForeignField("ID_DEVISE");
            this.tableElementTotalDevise.setRenderer(new CurrencyWithSymbolRenderer(new FieldPath(p, "CODE")));
            list.add(this.tableElementTotalDevise);
        }
        if (e.getTable().getFieldsName().contains("MARGE_HT")) {
            marge = new SQLTableElement(e.getTable().getField("MARGE_HT"), BigDecimal.class){

                @Override
                protected Object getDefaultNullValue() {
                    return BigDecimal.ZERO;
                }

                @Override
                public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                    return AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
                }
            };
            marge.setRenderer(new CurrencyWithSymbolRenderer());
            marge.setEditable(false);
            list.add(marge);
            this.totalHT.addModificationListener(marge);
            this.totalHA.addModificationListener(marge);
            marge.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                    BigDecimal vt = (BigDecimal)row.getObject("T_PV_HT");
                    BigDecimal ha = (BigDecimal)row.getObject("T_PA_HT");
                    BigDecimal acomptePercent = row.getBigDecimal("POURCENT_FACTURABLE");
                    BigDecimal acompteMontant = row.getBigDecimal("MONTANT_FACTURABLE");
                    Acompte acompte = new Acompte(acomptePercent, acompteMontant);
                    ha = acompte.getResultFrom(ha);
                    vt = acompte.getResultFrom(vt);
                    return vt.subtract(ha).setScale(marge.getDecimalDigits(), RoundingMode.HALF_UP);
                }
            });
        }
        if (e.getTable().getFieldsName().contains("MARGE_PREBILAN_HT")) {
            marge = new SQLTableElement(e.getTable().getField("MARGE_PREBILAN_HT"), BigDecimal.class){

                @Override
                protected Object getDefaultNullValue() {
                    return BigDecimal.ZERO;
                }
            };
            marge.setRenderer(new DeviseTableCellRenderer());
            marge.setEditable(false);
            list.add(marge);
            this.totalHT.addModificationListener(marge);
            this.prebilan.addModificationListener(marge);
            marge.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                    BigDecimal vt = (BigDecimal)row.getObject("T_PV_HT");
                    BigDecimal ha = row.getObject("PREBILAN") == null ? BigDecimal.ZERO : (BigDecimal)row.getObject("PREBILAN");
                    BigDecimal acomptePercent = row.getBigDecimal("POURCENT_FACTURABLE");
                    BigDecimal acompteMontant = row.getBigDecimal("MONTANT_FACTURABLE");
                    Acompte acompte = new Acompte(acomptePercent, acompteMontant);
                    ha = acompte.getResultFrom(ha);
                    vt = acompte.getResultFrom(vt);
                    return vt.subtract(ha).setScale(marge.getDecimalDigits(), RoundingMode.HALF_UP);
                }
            });
        }
        if (e.getTable().getFieldsName().contains("T_ECO_CONTRIBUTION")) {
            this.tableElementEcoTotal = new SQLTableElement(e.getTable().getField("T_ECO_CONTRIBUTION"));
            list.add(this.tableElementEcoTotal);
        }
        this.totalHT.setEditable(false);
        list.add(this.totalHT);
        this.tableElementTotalTTC = new SQLTableElement(e.getTable().getField("T_PV_TTC"), BigDecimal.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                return AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
            }
        };
        this.tableElementTotalTTC.setRenderer(new CurrencyWithSymbolRenderer());
        this.tableElementTotalTTC.setEditable(false);
        list.add(this.tableElementTotalTTC);
        this.defaultRowVals = new SQLRowValues(UndefinedRowValuesCache.getInstance().getDefaultRowValues(e.getTable()));
        this.defaultRowVals.put("ID_TAXE", TaxeCache.getCache().getFirstTaxe().getID());
        this.defaultRowVals.put("CODE", "");
        this.defaultRowVals.put("NOM", "");
        RowValuesTableModel model = new RowValuesTableModel(e, list, e.getTable().getField("NOM"), false, this.defaultRowVals);
        this.setModel(model);
        this.table = new RowValuesTable(model, this.getConfigurationFile());
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
        if (filterFamilleArticle) {
            ((SQLTextComboTableCellEditor)tableElementArticle.getTableCellEditor(this.table)).setDynamicWhere(e.getTable().getTable("ARTICLE").getField("ID_FAMILLE_ARTICLE"));
        }
        final SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
        ArrayList<String> completionField = new ArrayList<String>();
        if (e.getTable().getFieldsName().contains("ID_ECO_CONTRIBUTION")) {
            completionField.add("ID_ECO_CONTRIBUTION");
        }
        if (DefaultNXProps.getInstance().getBooleanValue(ARTICLE_SHOW_DEVISE, false)) {
            completionField.add("POURCENT_REMISE");
            completionField.add("CODE_DOUANIER");
        }
        if (DefaultNXProps.getInstance().getBooleanValue(ARTICLE_SHOW_DEVISE, false)) {
            completionField.add("ID_PAYS");
        }
        completionField.add("ID_UNITE_VENTE");
        completionField.add("PA_HT");
        completionField.add("PV_HT");
        completionField.add("ID_TAXE");
        completionField.add("POIDS");
        completionField.add("PRIX_METRIQUE_HA_1");
        completionField.add("PRIX_METRIQUE_HA_2");
        completionField.add("PRIX_METRIQUE_HA_3");
        completionField.add("VALEUR_METRIQUE_1");
        completionField.add("VALEUR_METRIQUE_2");
        completionField.add("VALEUR_METRIQUE_3");
        completionField.add("ID_MODE_VENTE_ARTICLE");
        completionField.add("PRIX_METRIQUE_VT_1");
        completionField.add("PRIX_METRIQUE_VT_2");
        completionField.add("PRIX_METRIQUE_VT_3");
        completionField.add("SERVICE");
        completionField.add("ID_FAMILLE_ARTICLE");
        if (this.getSQLElement().getTable().getFieldsName().contains("DESCRIPTIF")) {
            completionField.add("DESCRIPTIF");
        }
        if (DefaultNXProps.getInstance().getBooleanValue(ARTICLE_SHOW_DEVISE, false)) {
            completionField.add("ID_DEVISE");
        }
        if (DefaultNXProps.getInstance().getBooleanValue(ARTICLE_SHOW_DEVISE, false)) {
            completionField.add("PV_U_DEVISE");
        }
        if (this.getSQLElement().getTable().getFieldsName().contains("QTE_ACHAT") && sqlTableArticle.getTable().getFieldsName().contains("QTE_ACHAT")) {
            completionField.add("QTE_ACHAT");
        }
        final AutoCompletionManager m = new AutoCompletionManager(tableElementCode, sqlTableArticle.getField("CODE"), this.table, this.table.getRowValuesTableModel()){

            @Override
            protected Object getValueFrom(SQLRow row, String field, SQLRowAccessor rowDest) {
                Object res = AbstractVenteArticleItemTable.this.tarifCompletion(row, field, rowDest, true);
                if (res == null) {
                    return super.getValueFrom(row, field, rowDest);
                }
                return res;
            }
        };
        m.fill("NOM", "NOM");
        m.fill("ID", "ID_ARTICLE");
        for (String string : completionField) {
            m.fill(string, string);
        }
        ITransformer<SQLSelect, SQLSelect> selTrans = new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                SQLTable tableStock = sqlTableArticle.getTable("STOCK");
                input.andWhere(new Where((FieldRef)tableStock.getKey(), "=", sqlTableArticle.getField("ID_STOCK")));
                input.setExcludeUndefined(false, tableStock);
                Where w = new Where((FieldRef)sqlTableArticle.getField("OBSOLETE"), "=", (Object)Boolean.FALSE).or(new Where(input.getAlias(tableStock.getKey()), "=", tableStock.getUndefinedID())).or(new Where(input.getAlias(tableStock.getField("QTE_REEL")), ">", 0));
                if (input.getWhere() != null) {
                    input.setWhere(input.getWhere().and(w));
                } else {
                    input.setWhere(w);
                }
                input.asString();
                return input;
            }
        };
        m.setSelectTransformer(selTrans);
        this.table.setDropTarget(new DropTarget(){

            @Override
            public synchronized void drop(DropTargetDropEvent dtde) {
                AbstractVenteArticleItemTable.this.dropInTable(dtde, m);
            }
        });
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.CAN_EXPAND_NOMENCLATURE_VT, true)) {
            this.table.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.handlePopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.handlePopup(e);
                }

                public void handlePopup(MouseEvent e) {
                    final int rowindex = AbstractVenteArticleItemTable.this.table.getSelectedRow();
                    if (rowindex < 0) {
                        return;
                    }
                    if (e.isPopupTrigger() && e.getComponent() instanceof JTable) {
                        JPopupMenu popup = new JPopupMenu();
                        popup.add(new AbstractAction(TranslationManager.getInstance().getTranslationForItem("product.bom.expand")){

                            @Override
                            public void actionPerformed(ActionEvent arg0) {
                                AbstractVenteArticleItemTable.this.expandNomenclature(rowindex, m, AbstractArticleItemTable.EXPAND_TYPE.EXPAND);
                            }
                        });
                        popup.add(new AbstractAction(TranslationManager.getInstance().getTranslationForItem("product.bom.expose")){

                            @Override
                            public void actionPerformed(ActionEvent arg0) {
                                AbstractVenteArticleItemTable.this.expandNomenclature(rowindex, m, AbstractArticleItemTable.EXPAND_TYPE.VIEW_ONLY);
                            }
                        });
                        for (AbstractAction action : AbstractVenteArticleItemTable.this.getAdditionnalMouseAction(rowindex)) {
                            popup.add(action);
                        }
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
        }
        final AutoCompletionManager m2 = new AutoCompletionManager(tableElementNom, sqlTableArticle.getField("NOM"), this.table, this.table.getRowValuesTableModel()){

            @Override
            protected Object getValueFrom(SQLRow row, String field, SQLRowAccessor rowDest) {
                Object res = AbstractVenteArticleItemTable.this.tarifCompletion(row, field, rowDest, true);
                if (res == null) {
                    return super.getValueFrom(row, field, rowDest);
                }
                return res;
            }
        };
        m2.fill("CODE", "CODE");
        m2.fill("ID", "ID_ARTICLE");
        for (String string : completionField) {
            m2.fill(string, string);
        }
        m2.setSelectTransformer(selTrans);
        AutoCompletionManager m3 = new AutoCompletionManager(tableElementArticle, sqlTableArticle.getField("NOM"), this.table, this.table.getRowValuesTableModel(), 2, true, true, new ValidStateChecker()){

            @Override
            protected Object getValueFrom(SQLRow row, String field, SQLRowAccessor rowDest) {
                Object res = AbstractVenteArticleItemTable.this.tarifCompletion(row, field, rowDest, true);
                if (res == null) {
                    return super.getValueFrom(row, field, rowDest);
                }
                return res;
            }
        };
        m3.fill("CODE", "CODE");
        m3.fill("NOM", "NOM");
        for (String string : completionField) {
            m3.fill(string, string);
        }
        m3.setSelectTransformer(selTrans);
        tableFamille.addModificationListener(tableElementArticle);
        tableElementCode.addModificationListener(tableElementArticle);
        tableElementArticle.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                try {
                    SQLRowAccessor foreign;
                    if (filterFamilleArticle) {
                        if (row.isForeignEmpty("ID_FAMILLE_ARTICLE")) {
                            m.setWhere(null);
                            m2.setWhere(null);
                        } else {
                            m.setWhere(new Where((FieldRef)sqlTableArticle.getField("ID_FAMILLE_ARTICLE"), "=", row.getForeignID("ID_FAMILLE_ARTICLE")));
                            m2.setWhere(new Where((FieldRef)sqlTableArticle.getField("ID_FAMILLE_ARTICLE"), "=", row.getForeignID("ID_FAMILLE_ARTICLE")));
                        }
                    }
                    if ((foreign = row.getForeign("ID_ARTICLE")) != null && !foreign.isUndefined() && foreign.getObject("CODE") != null && foreign.getString("CODE").equals(row.getString("CODE"))) {
                        return foreign.getID();
                    }
                    return AbstractVenteArticleItemTable.this.tableArticle.getUndefinedID();
                }
                catch (Exception e) {
                    return AbstractVenteArticleItemTable.this.tableArticle.getUndefinedID();
                }
            }
        });
        if (this.tableElementEco != null && this.tableElementEcoTotal != null && this.tableElementEcoID != null) {
            this.qte.addModificationListener(this.tableElementEcoTotal);
            this.tableElementEco.addModificationListener(this.tableElementEcoTotal);
            this.tableElementEcoTotal.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                    int qte = Integer.parseInt(row.getObject("QTE").toString());
                    BigDecimal f = row.getObject("ECO_CONTRIBUTION") == null ? BigDecimal.ZERO : (BigDecimal)row.getObject("ECO_CONTRIBUTION");
                    return f.multiply(new BigDecimal(qte));
                }
            });
            this.tableElementEcoID.addModificationListener(this.tableElementEco);
            this.tableElementEco.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                    if (source != null && source.equals(AbstractVenteArticleItemTable.this.tableElementEcoID)) {
                        return row.getForeign("ID_ECO_CONTRIBUTION").getBigDecimal("TAUX");
                    }
                    return row.getObject("ECO_CONTRIBUTION");
                }
            });
        }
        this.qte.addModificationListener(tableElement_PrixMetrique1_VenteHT);
        this.qte.addModificationListener(this.totalHT);
        this.qte.addModificationListener(this.totalHA);
        qteU.addModificationListener(this.totalHT);
        qteU.addModificationListener(this.totalHA);
        if (tableElementRG != null) {
            tableElementRG.addModificationListener(this.totalHT);
        }
        this.tableElementRemise.addModificationListener(this.totalHT);
        tableElement_PrixVente_HT.addModificationListener(this.totalHT);
        this.ha.addModificationListener(this.totalHA);
        this.totalHT.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                BigDecimal acompteMontant;
                BigDecimal acomptePercent;
                Object o3;
                BigDecimal lremise = BigDecimal.ZERO;
                if (row.getTable().getFieldsName().contains("POURCENT_RG") && (o3 = row.getObject("POURCENT_RG")) != null) {
                    lremise = lremise.add((BigDecimal)o3);
                }
                int qte = row.getObject("QTE") == null ? 0 : Integer.parseInt(row.getObject("QTE").toString());
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                BigDecimal f = (BigDecimal)row.getObject("PV_HT");
                BigDecimal r = b.multiply(f.multiply(BigDecimal.valueOf(qte), DecimalUtils.HIGH_PRECISION), DecimalUtils.HIGH_PRECISION);
                if (lremise.compareTo(BigDecimal.ZERO) > 0 && lremise.compareTo(BigDecimal.valueOf(100L)) < 100) {
                    r = r.multiply(BigDecimal.valueOf(100L).subtract(lremise), DecimalUtils.HIGH_PRECISION).movePointLeft(2);
                }
                if (row.getTable().getFieldsName().contains("MONTANT_REMISE")) {
                    acomptePercent = row.getBigDecimal("POURCENT_REMISE");
                    acompteMontant = row.getBigDecimal("MONTANT_REMISE");
                    Remise remise = new Remise(acomptePercent, acompteMontant);
                    r = remise.getResultFrom(r);
                }
                if (row.getTable().getFieldsName().contains("POURCENT_FACTURABLE")) {
                    acomptePercent = row.getBigDecimal("POURCENT_FACTURABLE");
                    acompteMontant = row.getBigDecimal("MONTANT_FACTURABLE");
                    Acompte acompte = new Acompte(acomptePercent, acompteMontant);
                    r = acompte.getResultFrom(r);
                }
                return r.setScale(AbstractVenteArticleItemTable.this.totalHT.getDecimalDigits(), 4);
            }
        });
        this.totalHA.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                int qte = Integer.parseInt(row.getObject("QTE").toString());
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                BigDecimal f = (BigDecimal)row.getObject("PA_HT");
                BigDecimal rHA = b.multiply(new BigDecimal(qte), DecimalUtils.HIGH_PRECISION).multiply(f, DecimalUtils.HIGH_PRECISION).setScale(6, 4);
                if (row.getTable().getFieldsName().contains("POURCENT_FACTURABLE")) {
                    BigDecimal acomptePercent = row.getBigDecimal("POURCENT_FACTURABLE");
                    BigDecimal acompteMontant = row.getBigDecimal("MONTANT_FACTURABLE");
                    if (acomptePercent != null || acompteMontant != null) {
                        if (acomptePercent != null) {
                            rHA = rHA.multiply(acomptePercent.movePointLeft(2), DecimalUtils.HIGH_PRECISION);
                        } else {
                            Object o3;
                            BigDecimal lremise = BigDecimal.ZERO;
                            if (row.getTable().getFieldsName().contains("POURCENT_RG") && (o3 = row.getObject("POURCENT_RG")) != null) {
                                lremise = lremise.add((BigDecimal)o3);
                            }
                            BigDecimal fVT = (BigDecimal)row.getObject("PV_HT");
                            BigDecimal r = b.multiply(fVT.multiply(BigDecimal.valueOf(qte), DecimalUtils.HIGH_PRECISION), DecimalUtils.HIGH_PRECISION);
                            if (lremise.compareTo(BigDecimal.ZERO) > 0 && lremise.compareTo(BigDecimal.valueOf(100L)) < 100) {
                                r = r.multiply(BigDecimal.valueOf(100L).subtract(lremise), DecimalUtils.HIGH_PRECISION).movePointLeft(2);
                            }
                            if (row.getTable().getFieldsName().contains("MONTANT_REMISE")) {
                                BigDecimal acomptePercentR = row.getBigDecimal("POURCENT_REMISE");
                                BigDecimal acompteMontantR = row.getBigDecimal("MONTANT_REMISE");
                                Remise remise = new Remise(acomptePercentR, acompteMontantR);
                                r = remise.getResultFrom(r);
                            }
                            if (r.signum() != 0) {
                                rHA = rHA.multiply(acompteMontant.divide(r, DecimalUtils.HIGH_PRECISION), DecimalUtils.HIGH_PRECISION);
                            }
                        }
                    }
                }
                return rHA.setScale(AbstractVenteArticleItemTable.this.totalHA.getDecimalDigits(), 4);
            }

            @Override
            public void setValueFrom(SQLRowValues row, Object value) {
                super.setValueFrom(row, value);
            }
        });
        if (DefaultNXProps.getInstance().getBooleanValue(ARTICLE_SHOW_DEVISE, false)) {
            this.qte.addModificationListener(this.tableElementTotalDevise);
            qteU.addModificationListener(this.tableElementTotalDevise);
            if (eltUnitDevise != null) {
                eltUnitDevise.addModificationListener(this.tableElementTotalDevise);
            }
            this.tableElementRemise.addModificationListener(this.tableElementTotalDevise);
            this.tableElementTotalDevise.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                    int qte = row.getInt("QTE");
                    BigDecimal prixDeVenteUnitaireDevise = row.getObject("PV_U_DEVISE") == null ? BigDecimal.ZERO : (BigDecimal)row.getObject("PV_U_DEVISE");
                    BigDecimal qUnitaire = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                    BigDecimal prixVente = qUnitaire.multiply(prixDeVenteUnitaireDevise.multiply(BigDecimal.valueOf(qte), DecimalUtils.HIGH_PRECISION), DecimalUtils.HIGH_PRECISION);
                    if (row.getTable().getFieldsName().contains("MONTANT_REMISE")) {
                        BigDecimal acomptePercent = row.getBigDecimal("POURCENT_REMISE");
                        BigDecimal acompteMontant = row.getBigDecimal("MONTANT_REMISE");
                        Remise remise = new Remise(acomptePercent, acompteMontant);
                        prixVente = remise.getResultFrom(prixVente);
                    }
                    return prixVente.setScale(AbstractVenteArticleItemTable.this.tableElementTotalDevise.getDecimalDigits(), 4);
                }
            });
        }
        this.totalHT.addModificationListener(this.tableElementTotalTTC);
        this.tableElementTVA.addModificationListener(this.tableElementTotalTTC);
        this.tableElementTotalTTC.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                Collection minPrices;
                BigDecimal ht = (BigDecimal)row.getObject("T_PV_HT");
                int idTaux = row.getForeignID("ID_TAXE");
                Float resultTaux = TaxeCache.getCache().getTauxFromId(idTaux);
                if (resultTaux == null) {
                    SQLRow rowTax = TaxeCache.getCache().getFirstTaxe();
                    row.put("ID_TAXE", rowTax.getID());
                    resultTaux = Float.valueOf(rowTax.getFloat("TAUX"));
                }
                float taux = resultTaux == null ? 0.0f : resultTaux.floatValue();
                editorPVHT.setTaxe(taux);
                editorPVHT.setMin(null);
                if (!row.isForeignEmpty("ID_ARTICLE") && AbstractVenteArticleItemTable.this.getSQLElement().getTable().getDBRoot().contains("ARTICLE_PRIX_MIN_VENTE") && !lockVTMinPrice && (minPrices = row.getForeign("ID_ARTICLE").asRow().getReferentRows(row.getTable().getTable("ARTICLE_PRIX_MIN_VENTE"))).size() > 0) {
                    editorPVHT.setMin(((SQLRow)minPrices.get(0)).getBigDecimal("PRIX"));
                }
                BigDecimal r = ht.multiply(BigDecimal.valueOf(taux).movePointLeft(2).add(BigDecimal.ONE), DecimalUtils.HIGH_PRECISION);
                BigDecimal resultTTC = r.setScale(AbstractVenteArticleItemTable.this.tableElementTotalTTC.getDecimalDigits(), 4);
                return resultTTC;
            }

            @Override
            public void setValueFrom(SQLRowValues row, Object value) {
                super.setValueFrom(row, value);
            }
        });
        tableElement_ValeurMetrique1.addModificationListener(tableElementPoids);
        tableElement_ValeurMetrique2.addModificationListener(tableElementPoids);
        tableElement_ValeurMetrique3.addModificationListener(tableElementPoids);
        tableElementPoids.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                return new Float(ReferenceArticleSQLElement.getPoidsFromDetails(row));
            }
        });
        tableElementPoids.addModificationListener(this.tableElementPoidsTotal);
        qteU.addModificationListener(this.tableElementPoidsTotal);
        this.qte.addModificationListener(this.tableElementPoidsTotal);
        this.tableElementPoidsTotal.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                Number f = (Number)row.getObject("POIDS");
                if (f == null) {
                    f = 0;
                }
                int qte = Integer.parseInt(row.getObject("QTE").toString());
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                return Float.valueOf(b.multiply(new BigDecimal(f.floatValue() * (float)qte)).floatValue());
            }
        });
        uniteVente.addModificationListener(qteU);
        qteU.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                SQLRowAccessor rowUnite = row.getForeign("ID_UNITE_VENTE");
                if (rowUnite != null && !rowUnite.isUndefined() && rowUnite.getBoolean("A_LA_PIECE").booleanValue()) {
                    return BigDecimal.ONE;
                }
                return row.getObject("QTE_UNITAIRE");
            }
        });
        tableElement_PrixMetrique1_VenteHT.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                if (source != null && source.getField().getName().equals("PRIX_METRIQUE_VT_1")) {
                    return row.getObject("PRIX_METRIQUE_VT_1");
                }
                if (source != null && source.getField().getName().equals("PV_U_DEVISE")) {
                    if (!row.isForeignEmpty("ID_DEVISE")) {
                        String devCode = row.getForeign("ID_DEVISE").getString("CODE");
                        CurrencyConverter c = new CurrencyConverter();
                        BigDecimal prixDeVenteUnitaireDevise = row.getObject("PV_U_DEVISE") == null ? BigDecimal.ZERO : (BigDecimal)row.getObject("PV_U_DEVISE");
                        BigDecimal result = c.convert(prixDeVenteUnitaireDevise, devCode, c.getCompanyCurrencyCode(), AbstractVenteArticleItemTable.this.getDateDevise(), AbstractVenteArticleItemTable.this.isUsedBiasedDevise());
                        if (result == null) {
                            result = prixDeVenteUnitaireDevise;
                        }
                        return result.setScale((int)row.getTable().getField("PRIX_METRIQUE_VT_1").getType().getDecimalDigits(), RoundingMode.HALF_UP);
                    }
                    return row.getObject("PRIX_METRIQUE_VT_1");
                }
                return AbstractVenteArticleItemTable.this.tarifCompletion(row.getForeign("ID_ARTICLE"), "PRIX_METRIQUE_VT_1", row);
            }
        });
        if (DefaultNXProps.getInstance().getBooleanValue(ARTICLE_SHOW_DEVISE, false)) {
            if (eltUnitDevise != null) {
                eltUnitDevise.addModificationListener(tableElement_PrixMetrique1_VenteHT);
            }
            if (eltUnitDevise != null) {
                tableElement_PrixMetrique1_VenteHT.addModificationListener(eltUnitDevise);
                eltDevise.addModificationListener(eltUnitDevise);
                eltUnitDevise.setModifier(new CellDynamicModifier(){

                    @Override
                    public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                        if (source != null && source.getField().getName().equals("PV_U_DEVISE")) {
                            BigDecimal prixDeVenteUnitaireDevise = row.getObject("PV_U_DEVISE") == null ? BigDecimal.ZERO : (BigDecimal)row.getObject("PV_U_DEVISE");
                            return prixDeVenteUnitaireDevise;
                        }
                        if (!row.isForeignEmpty("ID_DEVISE")) {
                            String devCode = row.getForeign("ID_DEVISE").getString("CODE");
                            CurrencyConverter c = new CurrencyConverter();
                            BigDecimal bigDecimal = (BigDecimal)row.getObject("PRIX_METRIQUE_VT_1");
                            BigDecimal result = c.convert(bigDecimal, c.getCompanyCurrencyCode(), devCode, AbstractVenteArticleItemTable.this.getDateDevise(), AbstractVenteArticleItemTable.this.isUsedBiasedDevise());
                            if (result == null) {
                                result = bigDecimal;
                            }
                            return result.setScale((int)row.getTable().getField("PRIX_METRIQUE_VT_1").getType().getDecimalDigits(), RoundingMode.HALF_UP);
                        }
                        if (source != null && source.getField().getName().equalsIgnoreCase("PRIX_METRIQUE_VT_1")) {
                            return row.getObject("PRIX_METRIQUE_VT_1");
                        }
                        BigDecimal prixDeVenteUnitaireDevise = row.getObject("PV_U_DEVISE") == null ? BigDecimal.ZERO : (BigDecimal)row.getObject("PV_U_DEVISE");
                        return prixDeVenteUnitaireDevise;
                    }
                });
            }
        }
        tableElement_ValeurMetrique1.addModificationListener(tableElement_PrixVente_HT);
        tableElement_ValeurMetrique2.addModificationListener(tableElement_PrixVente_HT);
        tableElement_ValeurMetrique3.addModificationListener(tableElement_PrixVente_HT);
        tableElement_PrixMetrique1_VenteHT.addModificationListener(tableElement_PrixVente_HT);
        tableElement_PrixVente_HT.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                if (row.isForeignEmpty("ID_MODE_VENTE_ARTICLE") || row.getInt("ID_MODE_VENTE_ARTICLE") == 5) {
                    return row.getObject("PRIX_METRIQUE_VT_1");
                }
                BigDecimal prixVTFromDetails = ReferenceArticleSQLElement.getPrixVTFromDetails(row);
                return prixVTFromDetails.setScale(tableElement_PrixVente_HT.getDecimalDigits(), RoundingMode.HALF_UP);
            }
        });
        tableElement_ValeurMetrique1.addModificationListener(this.ha);
        tableElement_ValeurMetrique2.addModificationListener(this.ha);
        tableElement_ValeurMetrique3.addModificationListener(this.ha);
        tableElement_PrixMetrique1_AchatHT.addModificationListener(this.ha);
        this.ha.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                if (row.isForeignEmpty("ID_MODE_VENTE_ARTICLE") || row.getInt("ID_MODE_VENTE_ARTICLE") == 5) {
                    return row.getObject("PRIX_METRIQUE_HA_1");
                }
                BigDecimal prixHAFromDetails = ReferenceArticleSQLElement.getPrixHAFromDetails(row);
                return prixHAFromDetails.setScale(AbstractVenteArticleItemTable.this.ha.getDecimalDigits(), RoundingMode.HALF_UP);
            }
        });
        this.table.readState();
        this.setColumnVisible(model.getColumnForField("T_PA_HT"), true);
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.ITEM_PACKAGING, false)) {
            this.setColumnVisible(model.getColumnForField("T_POIDS_COLIS_NET"), false);
        }
        boolean modeAvance = DefaultNXProps.getInstance().getBooleanValue("ArticleModeVenteAvance", false);
        this.setColumnVisible(model.getColumnForField("VALEUR_METRIQUE_1"), modeAvance);
        this.setColumnVisible(model.getColumnForField("VALEUR_METRIQUE_2"), modeAvance);
        this.setColumnVisible(model.getColumnForField("VALEUR_METRIQUE_3"), modeAvance);
        this.setColumnVisible(model.getColumnForField("PV_HT"), modeAvance);
        this.setColumnVisible(model.getColumnForField("PA_HT"), modeAvance);
        this.setColumnVisible(model.getColumnForField("ID_MODE_VENTE_ARTICLE"), modeAvance);
        if (this.tableElementEco != null && this.tableElementEcoTotal != null && this.tableElementEcoID != null) {
            this.setColumnVisible(model.getColumnForField("ID_ECO_CONTRIBUTION"), showEco);
            this.setColumnVisible(model.getColumnForField("ECO_CONTRIBUTION"), showEco);
            this.setColumnVisible(model.getColumnForField("T_ECO_CONTRIBUTION"), showEco);
        }
        boolean gestionUV = prefs.getBoolean(GestionArticleGlobalPreferencePanel.UNITE_VENTE, true);
        this.setColumnVisible(model.getColumnForField("QTE_UNITAIRE"), gestionUV);
        this.setColumnVisible(model.getColumnForField("ID_UNITE_VENTE"), gestionUV);
        this.setColumnVisible(model.getColumnForField("ID_ARTICLE"), selectArticle);
        this.setColumnVisible(model.getColumnForField("CODE"), !selectArticle || selectArticle && createAuto);
        this.setColumnVisible(model.getColumnForField("NOM"), !selectArticle || selectArticle && createAuto);
        boolean showPoids = DefaultNXProps.getInstance().getBooleanValue("ArticleShowPoids", false);
        this.setColumnVisible(model.getColumnForField("POIDS"), showPoids);
        this.setColumnVisible(model.getColumnForField("T_POIDS"), showPoids);
        this.setColumnVisible(model.getColumnForField("ID_STYLE"), DefaultNXProps.getInstance().getBooleanValue("ArticleShowStyle", true));
        this.setColumnVisible(model.getColumnForField("POURCENT_FACTURABLE"), false);
        this.setColumnVisible(this.getModel().getColumnForField("ID_FAMILLE_ARTICLE"), filterFamilleArticle);
        this.setColumnVisible(model.getColumnForField("PRIX_METRIQUE_HA_1"), showHAPrice);
        this.setColumnVisible(model.getColumnForField("T_PA_HT"), showHAPrice);
        for (String string : visibilityMap.keySet()) {
            this.setColumnVisible(model.getColumnForField(string), visibilityMap.get(string));
        }
        Map<String, Boolean> mapCustom = this.getCustomVisibilityMap();
        if (mapCustom != null) {
            for (String string : mapCustom.keySet()) {
                this.setColumnVisible(model.getColumnForField(string), mapCustom.get(string));
            }
        }
        if ((barcodeReader = ComptaPropsConfiguration.getInstanceCompta().getBarcodeReader()) != null) {
            final BarcodeListener l = new BarcodeListener(){

                @Override
                public void keyReceived(KeyEvent ee) {
                }

                @Override
                public void barcodeRead(String code) {
                    if (((JFrame)SwingUtilities.getRoot(AbstractVenteArticleItemTable.this.getRowValuesTable())).isActive()) {
                        SQLSelect selArticle = new SQLSelect();
                        SQLTable tableArticle = AbstractVenteArticleItemTable.this.getSQLElement().getForeignElement("ID_ARTICLE").getTable();
                        selArticle.addSelectStar(tableArticle);
                        Where w = new Where((FieldRef)tableArticle.getField("OBSOLETE"), "=", (Object)Boolean.FALSE);
                        w = w.and(new Where((FieldRef)tableArticle.getField("CODE_BARRE"), "=", (Object)code));
                        selArticle.setWhere(w);
                        List<SQLRow> l2 = SQLRowListRSH.execute(selArticle);
                        if (l2.size() > 0) {
                            System.err.println("ARTICLE " + l2.get(0).getString("NOM"));
                            Tuple3<Double, String, String> art = Tuple3.create(1.0, l2.get(0).getString("CODE"), l2.get(0).getString("NOM"));
                            ArrayList<Tuple3<Double, String, String>> l = new ArrayList<Tuple3<Double, String, String>>();
                            l.add(art);
                            AbstractVenteArticleItemTable.this.insertFromDrop(l, m);
                        } else {
                            System.err.println("ARTICLE NOT FOUND !");
                        }
                    }
                }
            };
            this.getRowValuesTable().addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 2L) != 0L) {
                        if (AbstractVenteArticleItemTable.this.getRowValuesTable().isDisplayable()) {
                            barcodeReader.addBarcodeListener(l);
                        } else {
                            barcodeReader.removeBarcodeListener(l);
                        }
                    }
                }
            });
        }
        this.table.writeState();
    }

    @Override
    protected void refreshDeviseAmount() {
        int count = this.getRowValuesTable().getRowCount();
        int columnForField = this.getRowValuesTable().getRowValuesTableModel().getColumnForField("PV_U_DEVISE");
        if (columnForField >= 0) {
            SQLTableElement eltDevise = this.getRowValuesTable().getRowValuesTableModel().getSQLTableElementAt(columnForField);
            int i = 0;
            while (i < count) {
                SQLRowValues rowVals = this.getRowValuesTable().getRowValuesTableModel().getRowValuesAt(i);
                BigDecimal prixDeVenteUnitaireDevise = rowVals.getObject("PV_U_DEVISE") == null ? BigDecimal.ZERO : (BigDecimal)rowVals.getObject("PV_U_DEVISE");
                eltDevise.setValueFrom(rowVals, prixDeVenteUnitaireDevise);
                this.getRowValuesTable().getRowValuesTableModel().fireTableChanged(new TableModelEvent(this.getRowValuesTable().getRowValuesTableModel(), i, i, columnForField));
                ++i;
            }
        }
    }

    protected Map<String, Boolean> getCustomVisibilityMap() {
        return null;
    }

    protected Object tarifCompletion(SQLRowAccessor row, String field, SQLRowAccessor rowDest) {
        return this.tarifCompletion(row, field, rowDest, false);
    }

    protected Object tarifCompletion(SQLRowAccessor row, String field, SQLRowAccessor rowDest, boolean fromCompletion) {
        if (row != null && !row.isUndefined() && this.getSQLElement().getTable().getDBRoot().contains("ARTICLE_PRIX_REVIENT") && (field.equalsIgnoreCase("PRIX_METRIQUE_HA_1") || field.equalsIgnoreCase("PA_HT"))) {
            BigDecimal prc;
            if (row.getBoolean("AUTO_PRIX_REVIENT_NOMENCLATURE").booleanValue()) {
                ProductHelper helper = new ProductHelper(row.getTable().getDBRoot());
                prc = helper.getBomPriceForQuantity(1, row.getReferentRows(row.getTable().getTable("ARTICLE_ELEMENT").getField("ID_ARTICLE_PARENT")), ProductHelper.TypePrice.ARTICLE_PRIX_REVIENT);
            } else {
                ProductComponent productComp = new ProductComponent(row, BigDecimal.ONE);
                prc = productComp.getPRC(new Date());
            }
            if (prc == null) {
                return BigDecimal.ZERO;
            }
            return prc;
        }
        if (this.getTarif() != null && !this.getTarif().isUndefined()) {
            Collection<? extends SQLRowAccessor> rows = row.getReferentRows(this.tableArticleTarif);
            int quantite = 0;
            BigDecimal b = rowDest.getBigDecimal("QTE_UNITAIRE");
            int q = rowDest.getInt("QTE");
            BigDecimal qteTotal = b.multiply(new BigDecimal(q), DecimalUtils.HIGH_PRECISION);
            SQLRowAccessor rowTarif = null;
            for (SQLRowAccessor sQLRowAccessor : rows) {
                if (sQLRowAccessor.getTable().contains("OBSOLETE") && sQLRowAccessor.getBoolean("OBSOLETE").booleanValue()) continue;
                int qteTarif = sQLRowAccessor.getInt("QTE");
                if (sQLRowAccessor.getForeignID("ID_TARIF") != this.getTarif().getID() || CompareUtils.compare(qteTarif, qteTotal) > 0 || CompareUtils.compare(qteTarif, quantite) <= 0) continue;
                quantite = qteTarif;
                rowTarif = sQLRowAccessor;
            }
            if (rowTarif == null) {
                if (!this.getTarif().isForeignEmpty("ID_DEVISE")) {
                    if (field.equalsIgnoreCase("ID_DEVISE")) {
                        return this.getTarif().getObject("ID_DEVISE");
                    }
                    if (field.equalsIgnoreCase("PV_U_DEVISE")) {
                        return this.getQtyTarifPvM1(rowDest, fromCompletion);
                    }
                }
                if (field.equalsIgnoreCase("ID_TAXE") && !this.getTarif().isForeignEmpty("ID_TAXE")) {
                    return this.getTarif().getForeignID("ID_TAXE");
                }
            } else {
                if (field.equalsIgnoreCase("PRIX_METRIQUE_VT_1")) {
                    if (rowTarif.isForeignEmpty("ID_DEVISE")) {
                        return rowTarif.getObject(field);
                    }
                    String string = this.getTarif().getForeign("ID_DEVISE").getString("CODE");
                    CurrencyConverter c = new CurrencyConverter();
                    BigDecimal result = c.convert(rowTarif.getBigDecimal(field), string, c.getCompanyCurrencyCode(), new Date(), true);
                    return result.setScale((int)row.getTable().getField(field).getType().getDecimalDigits(), RoundingMode.HALF_UP);
                }
                if (field.equalsIgnoreCase("ID_DEVISE")) {
                    return rowTarif.getObject("ID_DEVISE");
                }
                if (field.equalsIgnoreCase("PV_U_DEVISE")) {
                    return rowTarif.getObject("PRIX_METRIQUE_VT_1");
                }
                if (field.equalsIgnoreCase("ID_TAXE")) {
                    if (!rowTarif.isForeignEmpty("ID_TAXE")) {
                        return rowTarif.getObject("ID_TAXE");
                    }
                } else if (field.equalsIgnoreCase("POURCENT_REMISE")) {
                    Acompte acompte = new Acompte(rowTarif.getBigDecimal("POURCENT_REMISE"), BigDecimal.ZERO);
                    return acompte;
                }
            }
        }
        if (field.equalsIgnoreCase("POURCENT_REMISE")) {
            return new Acompte(BigDecimal.ZERO, BigDecimal.ZERO);
        }
        if (field.equalsIgnoreCase("PRIX_METRIQUE_VT_1")) {
            return this.getQtyTarifPvM1(rowDest, fromCompletion);
        }
        return null;
    }

    @Override
    public void setTarif(SQLRowAccessor rowValuesTarif, boolean ask) {
        if (rowValuesTarif == null || this.getTarif() == null || rowValuesTarif.getID() != this.getTarif().getID()) {
            super.setTarif(rowValuesTarif, ask);
            if (ask && this.getRowValuesTable().getRowCount() > 0 && JOptionPane.showConfirmDialog(null, "Appliquer les tarifs associ\u00e9s au client sur les lignes d\u00e9j\u00e0 pr\u00e9sentes?") == 0) {
                int nbRows = this.table.getRowCount();
                int i = 0;
                while (i < nbRows) {
                    SQLRowValues rowVals = this.getRowValuesTable().getRowValuesTableModel().getRowValuesAt(i);
                    if (!rowVals.isForeignEmpty("ID_ARTICLE")) {
                        Object deviseValue;
                        SQLRowAccessor rowValsArt = rowVals.getForeign("ID_ARTICLE");
                        Object taxeValue = this.tarifCompletion(rowValsArt, "ID_TAXE", rowVals);
                        if (taxeValue != null) {
                            this.getRowValuesTable().getRowValuesTableModel().putValue(taxeValue, i, "ID_TAXE");
                        }
                        if ((deviseValue = this.tarifCompletion(rowValsArt, "ID_DEVISE", rowVals)) != null) {
                            this.getRowValuesTable().getRowValuesTableModel().putValue(deviseValue, i, "ID_DEVISE");
                        }
                        this.getRowValuesTable().getRowValuesTableModel().putValue(this.tarifCompletion(rowValsArt, "PV_U_DEVISE", rowVals), i, "PV_U_DEVISE");
                        this.getRowValuesTable().getRowValuesTableModel().putValue(this.tarifCompletion(rowValsArt, "PRIX_METRIQUE_VT_1", rowVals), i, "PRIX_METRIQUE_VT_1");
                    }
                    ++i;
                }
            }
        }
    }

    protected Object getQtyTarifPvM1(SQLRowAccessor row, boolean fromCompletion) {
        BigDecimal qteTotal;
        int q;
        BigDecimal b;
        int quantite;
        Collection<? extends SQLRowAccessor> col;
        SQLRowAccessor rowA = row.getForeign("ID_ARTICLE");
        if (rowA != null && !rowA.isUndefined() && rowA.getTable().contains("AUTO_PRIX_MIN_VENTE_NOMENCLATURE") && rowA.getBoolean("AUTO_PRIX_MIN_VENTE_NOMENCLATURE").booleanValue()) {
            BigDecimal b2 = row.getBigDecimal("QTE_UNITAIRE");
            int q2 = row.getInt("QTE");
            BigDecimal qteTotal2 = b2.multiply(new BigDecimal(q2), DecimalUtils.HIGH_PRECISION);
            ProductHelper helper = new ProductHelper(rowA.getTable().getDBRoot());
            return helper.getBomPriceForQuantity(qteTotal2.setScale(0, RoundingMode.HALF_UP).intValue(), rowA.getReferentRows(rowA.getTable().getTable("ARTICLE_ELEMENT").getField("ID_ARTICLE_PARENT")), ProductHelper.TypePrice.ARTICLE_PRIX_PUBLIC);
        }
        BigDecimal result = null;
        if (rowA != null && !rowA.isUndefined() && rowA.getTable().getDBRoot().contains("ARTICLE_PRIX_PUBLIC")) {
            col = rowA.getReferentRows(rowA.getTable().getTable("ARTICLE_PRIX_PUBLIC"));
            quantite = 0;
            b = row.getBigDecimal("QTE_UNITAIRE");
            q = row.getInt("QTE");
            qteTotal = b.multiply(new BigDecimal(q), DecimalUtils.HIGH_PRECISION);
            for (SQLRowAccessor sQLRowAccessor : col) {
                int qtePublic = sQLRowAccessor.getInt("QTE");
                if (CompareUtils.compare(qtePublic, qteTotal) > 0 || CompareUtils.compare(qtePublic, quantite) <= 0) continue;
                quantite = qtePublic;
                if (sQLRowAccessor.getBigDecimal("PRIX") == null) continue;
                result = sQLRowAccessor.getBigDecimal("PRIX");
            }
        }
        if (result == null && rowA != null && !rowA.isUndefined() && rowA.getTable().getDBRoot().contains("ARTICLE_PRIX_MIN_VENTE")) {
            col = rowA.getReferentRows(rowA.getTable().getTable("ARTICLE_PRIX_MIN_VENTE"));
            quantite = 0;
            b = row.getBigDecimal("QTE_UNITAIRE");
            q = row.getInt("QTE");
            qteTotal = b.multiply(new BigDecimal(q), DecimalUtils.HIGH_PRECISION);
            for (SQLRowAccessor sQLRowAccessor : col) {
                int qteMinVente = sQLRowAccessor.getInt("QTE");
                if (CompareUtils.compare(qteMinVente, qteTotal) > 0 || CompareUtils.compare(qteMinVente, quantite) <= 0) continue;
                quantite = qteMinVente;
                if (sQLRowAccessor.getBigDecimal("PRIX") == null) continue;
                result = sQLRowAccessor.getBigDecimal("PRIX");
            }
        }
        BigDecimal remise = null;
        if (rowA != null && !rowA.isUndefined() && rowA.getTable().getDBRoot().contains("TARIF_QUANTITE")) {
            Collection<? extends SQLRowAccessor> col2 = rowA.getReferentRows(rowA.getTable().getTable("TARIF_QUANTITE"));
            BigDecimal quantite2 = BigDecimal.ZERO;
            BigDecimal b3 = row.getBigDecimal("QTE_UNITAIRE");
            int q3 = row.getInt("QTE");
            BigDecimal bigDecimal = b3.multiply(new BigDecimal(q3), DecimalUtils.HIGH_PRECISION);
            for (SQLRowAccessor sQLRowAccessor : col2) {
                BigDecimal bigDecimal2 = sQLRowAccessor.getBigDecimal("QUANTITE");
                if (CompareUtils.compare(bigDecimal2, bigDecimal) > 0 || CompareUtils.compare(bigDecimal2, quantite2) <= 0) continue;
                quantite2 = bigDecimal2;
                if (sQLRowAccessor.getBigDecimal("PRIX_METRIQUE_VT_1") != null) {
                    result = sQLRowAccessor.getBigDecimal("PRIX_METRIQUE_VT_1");
                    remise = null;
                    continue;
                }
                result = null;
                remise = sQLRowAccessor.getBigDecimal("POURCENT_REMISE");
            }
            if (!col2.isEmpty() && result == null && remise == null) {
                result = rowA.getBigDecimal("PRIX_METRIQUE_VT_1");
            }
        }
        int index = this.getRowValuesTable().getRowValuesTableModel().row2index(row);
        if (result == null && remise == null) {
            return fromCompletion ? null : row.getObject("PRIX_METRIQUE_VT_1");
        }
        if (result != null) {
            return result;
        }
        this.getRowValuesTable().getRowValuesTableModel().putValue(remise, index, "POURCENT_REMISE");
        return row.getBigDecimal("PRIX_METRIQUE_VT_1");
    }

    @Override
    protected void setModel(RowValuesTableModel model) {
        super.setModel(model);
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                AbstractVenteArticleItemTable.this.calculTarifNomenclature();
            }
        });
    }

    private void dropInTable(DropTargetDropEvent dtde, AutoCompletionManager autoM) {
        dtde.acceptDrop(3);
        Transferable t = dtde.getTransferable();
        try {
            ArrayList<Tuple3<Double, String, String>> articles = new ArrayList<Tuple3<Double, String, String>>();
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List list = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                DataImporter importer = new DataImporter(this.getSQLElement().getTable());
                File file = (File)list.get(0);
                if (file.getName().endsWith(".ods") || file.getName().endsWith(".xls")) {
                    ArrayTableModel m = importer.createModelFrom(file);
                    int i = 0;
                    while (i < m.getRowCount()) {
                        List l = m.getLineValuesAt(i);
                        if (l.size() > 1) {
                            if (l.get(0) == null || l.get(0).toString().length() == 0) break;
                            Double qte = ((Number)l.get(1)).doubleValue();
                            String code = "";
                            code = l.get(0) instanceof Number ? String.valueOf(((Number)l.get(0)).intValue()) : l.get(0).toString();
                            String nom = "";
                            if (l.size() > 2) {
                                nom = (String)l.get(2);
                            }
                            if (qte > 0.0) {
                                articles.add(Tuple3.create(qte, code, nom));
                            }
                        }
                        ++i;
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Les formats de fichiers pris en charge sont ods et xls!");
                }
            } else if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String string = (String)t.getTransferData(DataFlavor.stringFlavor);
                List<String> l = StringUtils.fastSplitTrimmed(string, '\n');
                for (String string2 : l) {
                    List<String> line = StringUtils.fastSplitTrimmed(string2, '\t');
                    if (line.size() >= 2) {
                        Double qte = Double.valueOf(line.get(1));
                        String code = line.get(0) == null ? "" : line.get(0).toString();
                        String nom = "";
                        if (line.size() > 2) {
                            nom = line.get(2);
                        }
                        if (!(qte > 0.0)) continue;
                        articles.add(Tuple3.create(qte, code, nom));
                        continue;
                    }
                    break;
                }
            }
            if (articles.size() > 0) {
                this.insertFromDrop(articles, autoM);
                for (Tuple3 tuple3 : articles) {
                    System.err.println("ADD LINE " + tuple3);
                }
            }
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void insertFromDrop(List<Tuple3<Double, String, String>> articles, AutoCompletionManager m) {
        ArrayList<String> code = new ArrayList<String>(articles.size());
        int i = articles.size() - 1;
        while (i >= 0) {
            Tuple3<Double, String, String> tuple = articles.get(i);
            code.add((String)tuple.get1());
            --i;
        }
        SQLSelect sel = new SQLSelect();
        SQLTable articleTable = this.getSQLElement().getTable().getForeignTable("ID_ARTICLE");
        sel.addSelectStar(articleTable);
        sel.setWhere(new Where(articleTable.getField("CODE"), code));
        List<SQLRow> matchCode = SQLRowListRSH.execute(sel);
        HashMap<String, SQLRow> mapCode = new HashMap<String, SQLRow>();
        for (SQLRow sqlRow : matchCode) {
            mapCode.put(sqlRow.getString("CODE"), sqlRow);
        }
        int rowCount = this.getRowValuesTable().getRowValuesTableModel().getRowCount();
        HashMap<Integer, Integer> mapRows = new HashMap<Integer, Integer>();
        int i2 = 0;
        while (i2 < rowCount) {
            SQLRowValues rowVals = this.getRowValuesTable().getRowValuesTableModel().getRowValuesAt(i2);
            if (rowVals.getObject("ID_ARTICLE") != null && !rowVals.isForeignEmpty("ID_ARTICLE")) {
                mapRows.put(rowVals.getForeignID("ID_ARTICLE"), i2);
            }
            ++i2;
        }
        Set<String> fieldsFrom = m.getFieldsFrom();
        fieldsFrom.remove("POURCENT_REMISE");
        int i3 = articles.size() - 1;
        while (i3 >= 0) {
            Tuple3<Double, String, String> tuple = articles.get(i3);
            SQLRow article = (SQLRow)mapCode.get(tuple.get1());
            String fieldQte = "QTE";
            if (article != null && mapRows.containsKey(article.getID())) {
                Integer index = (Integer)mapRows.get(article.getID());
                SQLRowValues rowVals = this.getRowValuesTable().getRowValuesTableModel().getRowValuesAt(index);
                if (rowVals.getTable().getName().equals("BON_DE_LIVRAISON_ELEMENT")) {
                    fieldQte = "QTE_LIVREE";
                }
                this.getRowValuesTable().getRowValuesTableModel().putValue(rowVals.getInt(fieldQte) + 1, index, fieldQte);
            } else {
                SQLRowValues row2Insert = new SQLRowValues(this.getRowValuesTable().getRowValuesTableModel().getDefaultRowValues());
                if (article != null) {
                    m.fillRowValues(article, fieldsFrom, row2Insert);
                    row2Insert.put("ID_ARTICLE", article.getID());
                    row2Insert.put("CODE", article.getObject("CODE"));
                    row2Insert.put("NOM", article.getObject("NOM"));
                } else {
                    row2Insert.put("CODE", tuple.get1());
                    row2Insert.put("NOM", tuple.get2());
                }
                row2Insert.put(fieldQte, Math.round(((Double)tuple.get0()).floatValue()));
                if (row2Insert.getTable().getName().equals("BON_DE_LIVRAISON_ELEMENT")) {
                    row2Insert.put("QTE_LIVREE", Math.round(((Double)tuple.get0()).floatValue()));
                }
                row2Insert.put("POURCENT_REMISE", BigDecimal.ZERO);
                row2Insert.put("MONTANT_REMISE", BigDecimal.ZERO);
                row2Insert.put("PV_HT", row2Insert.getObject("PRIX_METRIQUE_VT_1"));
                BigDecimal resultTotalHT = row2Insert.getBigDecimal("PV_HT").multiply(new BigDecimal(row2Insert.getInt(fieldQte)));
                row2Insert.put("T_PV_HT", resultTotalHT);
                Float resultTaux = TaxeCache.getCache().getTauxFromId(row2Insert.getForeignID("ID_TAXE"));
                if (resultTaux == null) {
                    SQLRow rowTax = TaxeCache.getCache().getFirstTaxe();
                    resultTaux = Float.valueOf(rowTax.getFloat("TAUX"));
                }
                float taux = resultTaux == null ? 0.0f : resultTaux.floatValue();
                BigDecimal r = resultTotalHT.multiply(BigDecimal.valueOf(taux).movePointLeft(2).add(BigDecimal.ONE), DecimalUtils.HIGH_PRECISION);
                row2Insert.put("T_PV_TTC", r);
                this.getRowValuesTable().getRowValuesTableModel().addRowAt(0, row2Insert);
            }
            --i3;
        }
    }

    public static enum TypeCalcul {
        CALCUL_FACTURABLE("MONTANT_FACTURABLE", "POURCENT_FACTURABLE"),
        CALCUL_REMISE("MONTANT_REMISE", "POURCENT_REMISE");

        String fieldMontant;
        String fieldPourcent;

        private TypeCalcul(String fieldMontant, String fieldPourcent) {
            this.fieldMontant = fieldMontant;
            this.fieldPourcent = fieldPourcent;
        }

        public String getFieldMontant() {
            return this.fieldMontant;
        }

        public String getFieldPourcent() {
            return this.fieldPourcent;
        }
    }
}

