/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.image.ImageIconWarning;
import org.openconcerto.erp.core.customerrelationship.customer.element.CourrierClientSQLElement;
import org.openconcerto.erp.core.customerrelationship.customer.element.CustomerSQLElement;
import org.openconcerto.erp.core.customerrelationship.customer.element.RelanceSQLElement;
import org.openconcerto.erp.core.humanresources.payroll.element.SalarieSQLElement;
import org.openconcerto.erp.core.sales.credit.element.AvoirClientSQLElement;
import org.openconcerto.erp.core.sales.invoice.element.SaisieVenteFactureSQLElement;
import org.openconcerto.erp.core.sales.order.element.CommandeClientSQLElement;
import org.openconcerto.erp.core.sales.quote.element.DevisSQLElement;
import org.openconcerto.erp.core.sales.shipment.element.BonDeLivraisonSQLElement;
import org.openconcerto.erp.core.supplychain.credit.element.AvoirFournisseurSQLElement;
import org.openconcerto.erp.core.supplychain.order.element.CommandeSQLElement;
import org.openconcerto.erp.core.supplychain.order.element.DemandePrixSQLElement;
import org.openconcerto.erp.core.supplychain.receipt.element.BonReceptionSQLElement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.model.Where;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class NumerotationAutoSQLElement
extends ComptaSQLConfElement {
    private static final String FORMAT = "_FORMAT";
    private static final String START = "_START";
    public static final String AUTO_MONTH = "_AUTO_MONTH";
    protected static final SQLTable TABLE_NUM = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("NUMEROTATION_AUTO");
    private static Map<Class<? extends SQLElement>, String> map = new HashMap<Class<? extends SQLElement>, String>();

    static {
        map.put(AvoirClientSQLElement.class, "AVOIR");
        map.put(SaisieVenteFactureSQLElement.class, "FACT");
        map.put(AvoirClientSQLElement.class, "AVOIR");
        map.put(AvoirFournisseurSQLElement.class, "AVOIR_F");
        map.put(DevisSQLElement.class, "DEVIS");
        map.put(DemandePrixSQLElement.class, "DMD_PRIX");
        map.put(CustomerSQLElement.class, "CLIENT");
        map.put(BonDeLivraisonSQLElement.class, "BON_L");
        map.put(BonReceptionSQLElement.class, "BON_R");
        map.put(CommandeClientSQLElement.class, "COMMANDE_CLIENT");
        map.put(CommandeSQLElement.class, "COMMANDE");
        map.put(CourrierClientSQLElement.class, "COURRIER");
        map.put(RelanceSQLElement.class, "RELANCE");
        map.put(SalarieSQLElement.class, "SALARIE");
    }

    public NumerotationAutoSQLElement() {
        super("NUMEROTATION_AUTO", "une num\u00e9rotation automatique", "num\u00e9rotations automatiques");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> list = new ArrayList<String>(2);
        list.add("NOM");
        return list;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> list = new ArrayList<String>(2);
        list.add("NOM");
        return list;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            private Icon iconWarning;
            {
                this.iconWarning = ImageIconWarning.getInstance();
            }

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                Set s = map.keySet();
                ArrayList list = new ArrayList(s);
                Collections.sort(list, new Comparator<Class<? extends SQLElement>>(){

                    @Override
                    public int compare(Class<? extends SQLElement> o1, Class<? extends SQLElement> o2) {
                        return o1.getSimpleName().toString().compareTo(o2.getSimpleName().toString());
                    }
                });
                ArrayList<String> added = new ArrayList<String>();
                for (Class class1 : list) {
                    String prefix = (String)map.get(class1);
                    if (added.contains(prefix)) continue;
                    ++c.gridy;
                    c.gridx = 0;
                    c.weightx = 0.0;
                    added.add(prefix);
                    Object elt = Configuration.getInstance().getDirectory().getElement(class1);
                    if (elt == null) {
                        throw new IllegalArgumentException("Element null for class " + class1);
                    }
                    JLabel labelAvoirFormat = new JLabel(String.valueOf(StringUtils.firstUp(((SQLElement)elt).getPluralName())) + " " + this.getLabelFor(String.valueOf(prefix) + NumerotationAutoSQLElement.FORMAT), 4);
                    this.add((Component)labelAvoirFormat, c);
                    ++c.gridx;
                    c.weightx = 1.0;
                    final JTextField fieldFormat = new JTextField();
                    this.add((Component)fieldFormat, c);
                    JLabel labelAvoirStart = new JLabel(this.getLabelFor(String.valueOf(prefix) + NumerotationAutoSQLElement.START));
                    ++c.gridx;
                    c.weightx = 0.0;
                    this.add((Component)labelAvoirStart, c);
                    ++c.gridx;
                    c.weightx = 1.0;
                    final JTextField fieldStart = new JTextField();
                    this.add((Component)fieldStart, c);
                    final JLabel labelResult = new JLabel();
                    ++c.gridx;
                    c.weightx = 0.0;
                    this.add((Component)labelResult, c);
                    if (this.getTable().getFieldsName().contains(String.valueOf(prefix) + NumerotationAutoSQLElement.AUTO_MONTH)) {
                        JCheckBox boxAuto = new JCheckBox(this.getLabelFor(String.valueOf(prefix) + NumerotationAutoSQLElement.AUTO_MONTH));
                        ++c.gridx;
                        c.weightx = 0.0;
                        this.add((Component)boxAuto, c);
                        this.addSQLObject(boxAuto, String.valueOf(prefix) + NumerotationAutoSQLElement.AUTO_MONTH);
                    }
                    SimpleDocumentListener listener = new SimpleDocumentListener(){

                        @Override
                        public void update(DocumentEvent e) {
                            this.updateLabel(fieldStart, fieldFormat, labelResult);
                        }
                    };
                    fieldFormat.getDocument().addDocumentListener(listener);
                    fieldStart.getDocument().addDocumentListener(listener);
                    this.addRequiredSQLObject(fieldFormat, String.valueOf(prefix) + NumerotationAutoSQLElement.FORMAT);
                    this.addRequiredSQLObject(fieldStart, String.valueOf(prefix) + NumerotationAutoSQLElement.START);
                }
                JLabel labelExemple = new JLabel("Exemple de format : 'Fact'yyyy0000");
                ++c.gridy;
                c.gridx = 0;
                c.gridwidth = 0;
                c.weighty = 1.0;
                c.anchor = 18;
                this.add((Component)labelExemple, c);
            }

            private void updateLabel(JTextField textStart, JTextField textFormat, JLabel label) {
                block5: {
                    if (textStart.getText().trim().length() > 0) {
                        try {
                            String numProposition = NumerotationAutoSQLElement.getNextNumero(textFormat.getText(), Integer.parseInt(textStart.getText()), new Date());
                            if (numProposition != null) {
                                label.setText(" --> " + numProposition);
                                label.setIcon(null);
                                break block5;
                            }
                            label.setIcon(this.iconWarning);
                            label.setText("");
                        }
                        catch (IllegalArgumentException e) {
                            JOptionPane.showMessageDialog(null, "Le format " + textFormat.getText() + " n'est pas valide!");
                        }
                    } else {
                        label.setIcon(this.iconWarning);
                        label.setText("");
                    }
                }
            }
        };
    }

    public static final String getLabelFormatFor(Class<? extends SQLElement> clazz) {
        return String.valueOf(map.get(clazz)) + FORMAT;
    }

    public static final String getLabelNumberFor(Class<? extends SQLElement> clazz) {
        return String.valueOf(map.get(clazz)) + START;
    }

    public static final boolean isAuto(Class<? extends SQLElement> clazz, SQLRowAccessor rowNum) throws IllegalArgumentException {
        String s = NumerotationAutoSQLElement.getName(clazz);
        return TABLE_NUM.getFieldsName().contains(String.valueOf(s) + AUTO_MONTH) && rowNum.getBoolean(String.valueOf(s) + AUTO_MONTH) != false;
    }

    public static final void updateNextNumero(Class<? extends SQLElement> clazz, Date storedDate, String storedNumero) throws SQLException {
        SQLSelect sel = new SQLSelect();
        sel.addSelectStar(TABLE_NUM);
        sel.setWhere(new Where((FieldRef)TABLE_NUM.getKey(), "=", 2));
        sel.setLockStrength(SQLSelect.LockStrength.UPDATE);
        SQLRow row = CollectionUtils.getSole(SQLRowListRSH.execute(sel, false, false));
        if (NumerotationAutoSQLElement.isAuto(clazz, row)) {
            return;
        }
        if (NumerotationAutoSQLElement.getNextNumero(clazz, storedDate, row).equalsIgnoreCase(storedNumero.trim())) {
            String numberLabel = NumerotationAutoSQLElement.getLabelNumberFor(clazz);
            row.createEmptyUpdateRow().put(numberLabel, row.getInt(numberLabel) + 1).update();
        }
    }

    public static final String getNextNumero(Class<? extends SQLElement> clazz) throws IllegalArgumentException {
        return NumerotationAutoSQLElement.getNextNumero(clazz, new Date());
    }

    public static final String getNextNumero(Class<? extends SQLElement> clazz, Date d) throws IllegalArgumentException {
        return NumerotationAutoSQLElement.getNextNumero(clazz, d, null);
    }

    public static final String getNextNumero(Class<? extends SQLElement> clazz, Date d, SQLRowAccessor rowNum) throws IllegalArgumentException {
        if (rowNum == null || rowNum.isUndefined()) {
            rowNum = TABLE_NUM.getRow(2);
        }
        if (NumerotationAutoSQLElement.isAuto(clazz, rowNum)) {
            return NumerotationAutoSQLElement.getNextForMonth(clazz, d, rowNum);
        }
        String numberLabel = NumerotationAutoSQLElement.getLabelNumberFor(clazz);
        if (rowNum.getObject(numberLabel) == null) {
            return "";
        }
        String format = rowNum.getString(NumerotationAutoSQLElement.getLabelFormatFor(clazz));
        SQLSelect sel = new SQLSelect();
        sel.addSelect(rowNum.getTable().getField(numberLabel));
        sel.setWhere(rowNum.getTable().getKey(), "=", rowNum.getID());
        Number l = (Number)rowNum.getTable().getDBSystemRoot().getDataSource().execute(sel.asString(), new IResultSetHandler(SQLDataSource.SCALAR_HANDLER, false));
        int start = l.intValue();
        return NumerotationAutoSQLElement.getNextNumero(format, start, d);
    }

    private static final Tuple2<String, String> getPrefixAndSuffix(String format, Date d) {
        String prefix = "";
        String suffix = "";
        int c = format.indexOf(48);
        if (format.trim().length() > 0) {
            if (c >= 0) {
                prefix = format.substring(0, c);
                suffix = format.substring(c, format.length());
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(prefix);
                    prefix = dateFormat.format(d);
                }
                catch (IllegalArgumentException e) {
                    System.err.println("pattern incorrect");
                }
            } else {
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                    prefix = dateFormat.format(d);
                }
                catch (IllegalArgumentException e) {
                    System.err.println("pattern incorrect");
                }
            }
        }
        return Tuple2.create(prefix, suffix);
    }

    protected static final String getNextNumero(String format, Integer start, Date d) throws IllegalArgumentException {
        if (start != null && start < 0) {
            return null;
        }
        Tuple2<String, String> t = NumerotationAutoSQLElement.getPrefixAndSuffix(format, d);
        DecimalFormat decimalFormat = new DecimalFormat(t.get1());
        return String.valueOf(t.get0()) + decimalFormat.format(start);
    }

    public static final String getNextCodeLettrage() {
        SQLRow rowNum = TABLE_NUM.getRow(2);
        String string = rowNum.getString("CODE_LETTRAGE");
        String s = string == null ? "" : string.trim().toUpperCase();
        return NumerotationAutoSQLElement.getNextCodeLetrrage(s);
    }

    public static final String getNextCodeLetrrage(String code) {
        if ((code = code.trim()) == null || code.length() == 0) {
            return "AAA";
        }
        char[] charArray = code.toCharArray();
        int c = 65;
        int i = charArray.length - 1;
        while (i >= 0 && (c = charArray[i]) == 90) {
            --i;
        }
        if (i >= 0) {
            charArray[i] = c = (int)((char)(c + 1));
            int j = i + 1;
            while (j < charArray.length) {
                charArray[j] = 65;
                ++j;
            }
            code = String.valueOf(charArray);
        } else {
            StringBuffer buf = new StringBuffer(code.length() + 1);
            int nb = code.length() + 1;
            int j = 0;
            while (j < nb) {
                buf.append('A');
                ++j;
            }
            code = buf.toString();
        }
        return code;
    }

    private static boolean isNumeroExist(SQLElement element, int num) {
        if (num < 0) {
            return true;
        }
        String s = map.get(element.getClass());
        for (Class<? extends SQLElement> e : map.keySet()) {
            String prefix = map.get(e);
            if (!prefix.equals(s)) continue;
            SQLSelect sel = new SQLSelect();
            SQLElement elt = Configuration.getInstance().getDirectory().getElement(e);
            if (elt == null || !elt.getTable().getFieldsName().contains("NUMERO")) continue;
            sel.addSelect(elt.getTable().getKey());
            sel.setWhere(new Where((FieldRef)elt.getTable().getField("NUMERO"), "LIKE", (Object)NumerotationAutoSQLElement.getPattern(elt, num)));
            System.err.println("NumerotationAutoSQLElement.isNumeroExist() " + sel.asString());
            List liste = (List)Configuration.getInstance().getBase().getDataSource().execute(sel.asString(), new SQLRowListRSH(elt.getTable(), true));
            if (liste.size() <= 0) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        List<String> l = Arrays.asList("2011/05/001", "2011/05/002", "2011/05/003", "2011/05/004");
        DecimalFormat format = new DecimalFormat("'2011/05/'000");
        for (String string : l) {
            try {
                Number n = format.parse(string);
                System.err.println(n);
            }
            catch (ParseException exn) {
                exn.printStackTrace();
            }
        }
    }

    private static String getNextForMonth(Class<? extends SQLElement> clazz, Date d, SQLRowAccessor rowNum) {
        SQLTable table = Configuration.getInstance().getDirectory().getElement(clazz).getTable();
        String s = map.get(clazz);
        String pattern = rowNum.getString(String.valueOf(s) + FORMAT);
        Tuple2<String, String> prefixSuffix = NumerotationAutoSQLElement.getPrefixAndSuffix(pattern, d);
        String prefix = prefixSuffix.get0();
        String suffix = prefixSuffix.get1();
        Where w = new Where((FieldRef)table.getField("NUMERO"), "LIKE", (Object)("%" + prefix + "%"));
        SQLSelect sel = new SQLSelect();
        sel.addSelect(table.getField("NUMERO"));
        sel.addSelect(table.getKey());
        sel.setWhere(w);
        SQLDataSource source = Configuration.getInstance().getBase().getDataSource();
        ResultSetHandler createFromSelect = SQLRowListRSH.createFromSelect(sel);
        List l = (List)source.execute(sel.asString(), new IResultSetHandler(createFromSelect, false));
        String decimalPattern = "'" + prefix + "'" + suffix;
        DecimalFormat format = new DecimalFormat(decimalPattern);
        int value = 0;
        for (SQLRow sqlRow : l) {
            String numero = sqlRow.getString("NUMERO");
            try {
                Number n = format.parse(numero);
                value = Math.max(value, n.intValue());
            }
            catch (ParseException exn) {
                System.err.println("NumerotationAutoSQLElement.getNextForMonth(): warning: unable to parse " + numero + " with pattern " + decimalPattern + " row:" + sqlRow);
                exn.printStackTrace();
            }
        }
        String result = format.format(value + 1);
        System.err.println("NumerotationAutoSQLElement.getNextForMonth(): " + result);
        return result;
    }

    private static String getPattern(SQLElement elt, int num) {
        SQLRow rowNum = TABLE_NUM.getRow(2);
        String s = map.get(elt.getClass());
        String format = rowNum.getString(String.valueOf(s) + FORMAT);
        format = format.replaceAll("y|d|M", "_");
        format = format.replaceAll("'", "");
        int c = format.indexOf(48);
        String numero = "";
        if (format.trim().length() > 0) {
            if (c >= 0) {
                String prefix = format.substring(0, c);
                String suffix = format.substring(c, format.length());
                String d = prefix;
                DecimalFormat numberFormat = new DecimalFormat(suffix);
                String n = numberFormat.format(num);
                numero = String.valueOf(d) + n;
            } else {
                String d = format;
                numero = String.valueOf(d) + String.valueOf(num);
            }
        } else {
            numero = String.valueOf(num);
        }
        return numero;
    }

    public static void fixNumerotation(SQLElement elt) {
        int start;
        SQLRow rowNum = TABLE_NUM.getRow(2);
        String s = map.get(elt.getClass());
        if (!(rowNum.getTable().contains(String.valueOf(s) + AUTO_MONTH) && rowNum.getBoolean(String.valueOf(s) + AUTO_MONTH).booleanValue() || rowNum.getObject(String.valueOf(s) + START) == null || NumerotationAutoSQLElement.isNumeroExist(elt, (start = rowNum.getInt(String.valueOf(s) + START)) - 1))) {
            int i = 2;
            while (!NumerotationAutoSQLElement.isNumeroExist(elt, start - i)) {
                ++i;
            }
            if (start - i >= 0) {
                SQLRowValues rowVals = rowNum.createEmptyUpdateRow();
                rowVals.put(String.valueOf(s) + START, start - i + 1);
                try {
                    rowVals.update();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void addClass(Class<? extends SQLElement> elt, String name) {
        map.put(elt, name);
    }

    public static void removeClass(Class<? extends SQLElement> elt) {
        map.remove(elt);
    }

    private static String getName(Class<? extends SQLElement> elt) {
        return map.get(elt);
    }

    public static void addListeners() {
        for (Class<? extends SQLElement> clazz : map.keySet()) {
            final SQLElement elt = Configuration.getInstance().getDirectory().getElement(clazz);
            if (elt != null) {
                elt.getTable().addTableModifiedListener(new SQLTableModifiedListener(){

                    @Override
                    public void tableModified(SQLTableEvent evt) {
                        SQLRow row;
                        if (evt.getMode() == SQLTableEvent.Mode.ROW_UPDATED && (row = evt.getRow()) != null && row.isArchived()) {
                            NumerotationAutoSQLElement.fixNumerotation(elt);
                        }
                    }
                });
                continue;
            }
            System.err.println(clazz);
            Thread.dumpStack();
        }
    }

    @Override
    protected String createCode() {
        return "autonumbering";
    }
}

