/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUBinary;
import com.ibm.icu.text.UTF16;
import java.nio.ByteBuffer;
import java.util.Arrays;

public abstract class Trie {
    protected char[] m_index_;
    protected DataManipulate m_dataManipulate_;
    protected int m_dataOffset_;
    protected int m_dataLength_;
    private boolean m_isLatin1Linear_;
    private int m_options_;

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Trie)) {
            return false;
        }
        Trie othertrie = (Trie)other;
        return this.m_isLatin1Linear_ == othertrie.m_isLatin1Linear_ && this.m_options_ == othertrie.m_options_ && this.m_dataLength_ == othertrie.m_dataLength_ && Arrays.equals(this.m_index_, othertrie.m_index_);
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    protected Trie(ByteBuffer bytes, DataManipulate dataManipulate) {
        int signature = bytes.getInt();
        this.m_options_ = bytes.getInt();
        if (!this.checkHeader(signature)) {
            throw new IllegalArgumentException("ICU data file error: Trie header authentication failed, please check if you have the most updated ICU data file");
        }
        this.m_dataManipulate_ = dataManipulate != null ? dataManipulate : new DefaultGetFoldingOffset();
        this.m_isLatin1Linear_ = (this.m_options_ & 0x200) != 0;
        this.m_dataOffset_ = bytes.getInt();
        this.m_dataLength_ = bytes.getInt();
        this.unserialize(bytes);
    }

    protected abstract int getSurrogateOffset(char var1, char var2);

    protected final int getRawOffset(int offset, char ch) {
        return (this.m_index_[offset + (ch >> 5)] << 2) + (ch & 0x1F);
    }

    protected final int getBMPOffset(char ch) {
        return ch >= '\ud800' && ch <= '\udbff' ? this.getRawOffset(320, ch) : this.getRawOffset(0, ch);
    }

    protected final int getLeadOffset(char ch) {
        return this.getRawOffset(0, ch);
    }

    protected final int getCodePointOffset(int ch) {
        if (ch < 0) {
            return -1;
        }
        if (ch < 55296) {
            return this.getRawOffset(0, (char)ch);
        }
        if (ch < 65536) {
            return this.getBMPOffset((char)ch);
        }
        if (ch <= 0x10FFFF) {
            return this.getSurrogateOffset(UTF16.getLeadSurrogate(ch), (char)(ch & 0x3FF));
        }
        return -1;
    }

    protected void unserialize(ByteBuffer bytes) {
        this.m_index_ = ICUBinary.getChars(bytes, this.m_dataOffset_, 0);
    }

    protected final boolean isCharTrie() {
        return (this.m_options_ & 0x100) == 0;
    }

    private final boolean checkHeader(int signature) {
        if (signature != 1416784229) {
            return false;
        }
        return (this.m_options_ & 0xF) == 5 && (this.m_options_ >> 4 & 0xF) == 2;
    }

    private static class DefaultGetFoldingOffset
    implements DataManipulate {
        private DefaultGetFoldingOffset() {
        }

        public int getFoldingOffset(int value) {
            return value;
        }
    }

    public static interface DataManipulate {
        public int getFoldingOffset(int var1);
    }
}

