/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformer;

public class Extractor<T> {
    private final String name;
    private final List<String> propNames;
    private final List<String> equalityPropNames;
    private final Map<String, ITransformer<? super T, ?>> transformers;
    private final Set<String> attributes;
    private final Set<String> elements;

    public Extractor(String name, String propNames) {
        this(name, propNames, -1);
    }

    public Extractor(String name, String propNames, int equality) {
        this.name = name;
        this.propNames = Arrays.asList(propNames.split(","));
        this.equalityPropNames = this.propNames.subList(0, equality == -1 ? this.propNames.size() : equality);
        this.transformers = new HashMap();
        this.attributes = new LinkedHashSet<String>();
        this.elements = new LinkedHashSet<String>();
    }

    public Extractor<T> addAttribute(String propName, ITransformer<? super T, ?> t) {
        this.addTransformer(propName, t);
        this.attributes.add(propName);
        return this;
    }

    public Extractor<T> addElement(String propName, ITransformer<? super T, ?> t) {
        this.addTransformer(propName, t);
        this.elements.add(propName);
        return this;
    }

    private void addTransformer(String propName, ITransformer<? super T, ?> t) {
        if (!this.propNames.contains(propName)) {
            throw new IllegalArgumentException("unknown property: " + propName);
        }
        this.transformers.put(propName, t);
    }

    public XPath getXPath(T o) throws JDOMException {
        ArrayList<String> props = new ArrayList<String>(this.equalityPropNames.size());
        int i = 0;
        HashMap<String, Object> vars = new HashMap<String, Object>();
        for (String propName : this.equalityPropNames) {
            Object propValue = this.getValue(propName, o);
            String varName = "var" + i;
            if (this.attributes.contains(propName)) {
                props.add("@" + propName + "=$" + varName);
            } else if (this.elements.contains(propName)) {
                props.add("./" + propName + "=$" + varName);
            } else {
                throw new IllegalStateException(String.valueOf(propName) + " has not been added");
            }
            vars.put(varName, propValue);
            ++i;
        }
        XPath res = XPath.newInstance("./" + this.getName() + "[" + CollectionUtils.join(props, " and ") + "]");
        for (Map.Entry e : vars.entrySet()) {
            res.setVariable((String)e.getKey(), e.getValue());
        }
        return res;
    }

    private Object getValue(String propName, T o) {
        return this.transformers.get(propName).transformChecked(o);
    }

    public final String getName() {
        return this.name;
    }

    public Element createElement(T o) {
        Element res = new Element(this.getName());
        for (String propName : this.attributes) {
            res.setAttribute(propName, this.getValue(propName, o).toString());
        }
        for (String propName : this.elements) {
            res.addContent(new Element(propName).setText(this.getValue(propName, o).toString()));
        }
        return res;
    }
}

