/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.protocol;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import org.openconcerto.utils.SystemUtils;
import org.openconcerto.utils.protocol.jarjar.Handler;

public class Helper {
    private static final SystemUtils.PropertyList PL = new SystemUtils.PropertyList("java.protocol.handler.pkgs", "|");

    public static final void register() {
        PL.add(Helper.class.getPackage().getName());
    }

    public static final void setURLStreamHandlerFactory() {
        URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory(){

            @Override
            public URLStreamHandler createURLStreamHandler(String protocol) {
                if (protocol.equals("jarjar")) {
                    return new Handler();
                }
                return null;
            }
        });
    }

    public static final URL toJarJar(URL u) {
        if ("jar".equals(u.getProtocol()) && u.getPath().endsWith(".jar")) {
            try {
                return new URL("jar:jar" + u.toString().replace('!', '^') + "!/");
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Couldn't transform " + u, e);
            }
        }
        return u;
    }
}

