/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.i18n;

import java.text.Normalizer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openconcerto.utils.i18n.Grammar;
import org.openconcerto.utils.i18n.NounClass;
import org.openconcerto.utils.i18n.Phrase;
import org.openconcerto.utils.i18n.VariantKey;

public class Grammar_fr
extends Grammar {
    private static final Grammar_fr INSTANCE = new Grammar_fr();
    private static final Pattern LE_LES = Pattern.compile("(\\p{javaWhitespace}*)([Ll][Ee][Ss]?)\\p{javaWhitespace}+");

    public static Grammar_fr getInstance() {
        return INSTANCE;
    }

    private Grammar_fr() {
        this(Locale.FRENCH);
    }

    protected Grammar_fr(Locale l) {
        super(l);
    }

    @Override
    protected Collection<? extends VariantKey> createVariantKeys() {
        return Arrays.asList(SINGULAR, PLURAL, INDEFINITE_ARTICLE_SINGULAR, INDEFINITE_ARTICLE_PLURAL, DEFINITE_ARTICLE_SINGULAR, DEFINITE_ARTICLE_PLURAL, DEMONSTRATIVE_SINGULAR, DEMONSTRATIVE_PLURAL, INDEFINITE_NUMERAL, DEFINITE_NUMERAL, DEMONSTRATIVE_NUMERAL);
    }

    @Override
    protected Collection<? extends NounClass> createNounClasses() {
        return Arrays.asList(NounClass.FEMININE, NounClass.MASCULINE);
    }

    public final Phrase createPhrase(NounClass nounClass, String singular) {
        return this.createPhrase(nounClass, singular, null);
    }

    public final Phrase createPhrase(NounClass nounClass, String singular, String plural) {
        if (!this.getNounClasses().contains(nounClass)) {
            throw new IllegalArgumentException("invalid nounClass : " + nounClass);
        }
        Phrase res = new Phrase(this, singular, nounClass);
        if (plural != null) {
            res.putVariant(PLURAL, plural);
        }
        return res;
    }

    @Override
    public String getVariant(Phrase noun, VariantKey key) {
        String res = key.equals(SINGULAR) ? noun.getBase() : (key.equals(INDEFINITE_ARTICLE_SINGULAR) ? String.valueOf(noun.getNounClass() == NounClass.MASCULINE ? "un " : "une ") + this.getSingular(noun) : (key.equals(DEFINITE_ARTICLE_SINGULAR) ? String.valueOf(this.getDefiniteArticle(noun)) + this.getSingular(noun) : (key.equals(DEMONSTRATIVE_SINGULAR) ? String.valueOf(this.getCe(noun)) + this.getSingular(noun) : (key.equals(PLURAL) ? this.getPlural(noun.getBase()) : (key.equals(INDEFINITE_ARTICLE_PLURAL) ? "des " + this.getPlural(noun) : (key.equals(DEFINITE_ARTICLE_PLURAL) ? "les " + this.getPlural(noun) : (key.equals(DEMONSTRATIVE_PLURAL) ? "ces " + this.getPlural(noun) : (key.equals(INDEFINITE_NUMERAL) ? "{0, plural, =0 {auc" + this.getVariant(noun, INDEFINITE_ARTICLE_SINGULAR) + "} one {# " + this.getSingular(noun) + "} other {# " + this.getPlural(noun) + "}}" : (key.equals(DEFINITE_NUMERAL) ? "{0, plural, =0 {auc" + this.getVariant(noun, INDEFINITE_ARTICLE_SINGULAR) + "} one {" + this.getVariant(noun, DEFINITE_ARTICLE_SINGULAR) + "} other {les # " + this.getPlural(noun) + "}}" : (key.equals(DEMONSTRATIVE_NUMERAL) ? "{0, plural, =0 {auc" + this.getVariant(noun, INDEFINITE_ARTICLE_SINGULAR) + "} one {" + this.getVariant(noun, DEMONSTRATIVE_SINGULAR) + "} other {ces # " + this.getPlural(noun) + "}}" : null))))))))));
        return res;
    }

    protected String getDefiniteArticle(Phrase noun) {
        if (this.startsWithVowel(noun.getBase())) {
            return "l\u2019";
        }
        if (noun.getNounClass() == NounClass.MASCULINE) {
            return "le ";
        }
        return "la ";
    }

    protected boolean startsWithVowel(String s) {
        char char0;
        String firstLetter = s.substring(0, 1).toLowerCase(this.getLocale());
        if (firstLetter.equals("h")) {
            firstLetter = s.substring(1, 2).toLowerCase(this.getLocale());
        }
        return (char0 = Normalizer.normalize(firstLetter, Normalizer.Form.NFD).charAt(0)) == 'a' || char0 == 'e' || char0 == 'i' || char0 == 'o' || char0 == 'u' || char0 == 'y';
    }

    protected String getSingular(Phrase noun) {
        String res = noun.getVariant(SINGULAR);
        return res == null ? noun.getBase() : res;
    }

    protected String getPlural(Phrase noun) {
        String res = noun.getVariant(PLURAL);
        return res == null ? this.getPlural(noun.getBase()) : res;
    }

    protected String getPlural(String noun) {
        int l = noun.length();
        char lastChar = noun.charAt(l - 1);
        if (lastChar == 's' || lastChar == 'x' || lastChar == 'z') {
            return noun;
        }
        if (noun.endsWith("al")) {
            return String.valueOf(noun.substring(0, l - 2)) + "aux";
        }
        return String.valueOf(noun) + 's';
    }

    private String getCe(Phrase noun) {
        if (noun.getNounClass().equals(NounClass.FEMININE)) {
            return "cette ";
        }
        if (this.startsWithVowel(noun.getBase())) {
            return "cet ";
        }
        return "ce ";
    }

    public String de(String phrase) {
        Matcher matcher = LE_LES.matcher(phrase);
        if (matcher.lookingAt()) {
            char d;
            String le_les_group = matcher.group(2);
            char c = d = le_les_group.charAt(0) == 'L' ? (char)'D' : 'd';
            String de = le_les_group.length() == 3 ? String.valueOf(d) + le_les_group.substring(1) : String.valueOf(d) + (le_les_group.charAt(1) == 'E' ? "U" : "u");
            return String.valueOf(matcher.group(1)) + de + phrase.substring(matcher.end(2));
        }
        if (this.startsWithVowel(phrase.trim())) {
            return "d\u2019" + phrase;
        }
        return "de " + phrase;
    }

    public String \u00e0(String phrase) {
        Matcher matcher = LE_LES.matcher(phrase);
        if (matcher.lookingAt()) {
            String le_les_group = matcher.group(2);
            String au = String.valueOf(le_les_group.charAt(0) == 'L' ? "A" : "a") + (le_les_group.charAt(1) == 'E' ? "U" : "u");
            String de = le_les_group.length() == 3 ? String.valueOf(au) + (le_les_group.charAt(2) == 'S' ? "X" : "x") : au;
            return String.valueOf(matcher.group(1)) + de + phrase.substring(matcher.end(2));
        }
        return "\u00e0 " + phrase;
    }
}

