/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.checks;

import java.util.ArrayList;
import java.util.List;
import org.openconcerto.utils.checks.EmptyListener;
import org.openconcerto.utils.checks.EmptyObj;

public final class EmptyChangeSupport {
    private final EmptyObj target;
    private final List<EmptyListener> listeners;
    private Boolean emptyState;

    public EmptyChangeSupport(EmptyObj target) {
        this(target, null);
    }

    public EmptyChangeSupport(EmptyObj target, Boolean initialState) {
        if (target == null) {
            throw new NullPointerException("null target");
        }
        this.listeners = new ArrayList<EmptyListener>(3);
        this.target = target;
        this.emptyState = initialState;
    }

    public final void fireEmptyChange(Boolean newValue) {
        if (!newValue.equals(this.emptyState)) {
            this.emptyState = newValue;
            for (EmptyListener l : this.listeners) {
                l.emptyChange(this.target, this.emptyState);
            }
        }
    }

    public void addEmptyListener(EmptyListener l) {
        this.listeners.add(l);
    }

    public void removeEmptyListener(EmptyListener l) {
        this.listeners.remove(l);
    }
}

