/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.Comparator;
import org.apache.commons.collections.ComparatorUtils;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.cc.Transformer;

public class TransformedComparator<E, T>
implements Comparator<E> {
    private final ITransformer<E, T> transf;
    private final Comparator<T> comp;

    public static final <T> TransformedComparator<T, T> from(Comparator<T> comp) {
        return new TransformedComparator(Transformer.nopTransformer(), comp);
    }

    public TransformedComparator(ITransformer<E, T> transf) {
        this(transf, ComparatorUtils.NATURAL_COMPARATOR);
    }

    public TransformedComparator(ITransformer<E, T> transf, Comparator<T> comp) {
        this.transf = transf;
        this.comp = comp;
    }

    @Override
    public int compare(E o1, E o2) {
        return this.comp.compare(this.transf.transformChecked(o1), this.transf.transformChecked(o2));
    }
}

