/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TinyMap<K, V>
implements Map<K, V> {
    private final ArrayList<K> keys;
    private final ArrayList<V> values;

    public TinyMap() {
        this(10);
    }

    public TinyMap(int initialCapacity) {
        this.keys = new ArrayList(initialCapacity);
        this.values = new ArrayList(initialCapacity);
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keys.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.contains(value);
    }

    @Override
    public V get(Object key) {
        int size = this.keys.size();
        int i = 0;
        while (i < size) {
            if (this.keys.get(i).equals(key)) {
                return this.values.get(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        int size = this.keys.size();
        int i = 0;
        while (i < size) {
            if (this.keys.get(i).equals(key)) {
                V old = this.values.get(i);
                this.values.set(i, value);
                return old;
            }
            ++i;
        }
        this.keys.add(key);
        this.values.add(value);
        return null;
    }

    @Override
    public V remove(Object key) {
        int size = this.keys.size();
        int i = 0;
        while (i < size) {
            if (this.keys.get(i).equals(key)) {
                this.keys.remove(i);
                return this.values.remove(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        Set<K> keySet = m.keySet();
        for (K key : keySet) {
            this.put(key, m.get(key));
        }
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.values.clear();
    }

    @Override
    public Set<K> keySet() {
        return new HashSet<K>(this.keys){

            @Override
            public boolean remove(Object o) {
                TinyMap.this.remove(o);
                return super.remove(o);
            }

            @Override
            public void clear() {
                this.clear();
                super.clear();
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new ArrayList<V>(this.values()){

            @Override
            public V remove(int index) {
                TinyMap.this.keys.remove(index);
                TinyMap.this.values.remove(index);
                return super.remove(index);
            }

            @Override
            public boolean remove(Object o) {
                int index = TinyMap.this.values.indexOf(o);
                if (index >= 0) {
                    TinyMap.this.keys.remove(index);
                    TinyMap.this.values.remove(index);
                }
                return super.remove(o);
            }

            @Override
            public void clear() {
                this.clear();
                super.clear();
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet set = new HashSet<Map.Entry<K, V>>(){

            @Override
            public boolean remove(Object o) {
                Map.Entry entry = (Map.Entry)o;
                int index = TinyMap.this.values.indexOf(entry.getValue());
                if (index >= 0) {
                    TinyMap.this.keys.remove(index);
                    TinyMap.this.values.remove(index);
                }
                return super.remove(o);
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                for (Map.Entry entry : c) {
                    int index = TinyMap.this.values.indexOf(entry.getValue());
                    if (index < 0) continue;
                    TinyMap.this.keys.remove(index);
                    TinyMap.this.values.remove(index);
                }
                return super.removeAll(c);
            }

            @Override
            public void clear() {
                this.clear();
                super.clear();
            }
        };
        int size = this.keys.size();
        int i = 0;
        while (i < size) {
            set.add(new AbstractMap.SimpleImmutableEntry<K, V>(this.keys.get(i), this.values.get(i)));
            ++i;
        }
        return set;
    }
}

