/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.openconcerto.utils.PropertiesUtils;

public class ProductInfo {
    public static final String PROPERTIES_NAME = "/product.properties";
    public static final String NAME = "NAME";
    public static final String VERSION = "VERSION";
    private static ProductInfo INSTANCE;
    private final Properties props;

    public static final synchronized ProductInfo getInstance() {
        if (INSTANCE == null) {
            try {
                INSTANCE = ProductInfo.createDefault();
            }
            catch (IOException e) {
                throw new IllegalStateException("unable to load default product properties", e);
            }
        }
        return INSTANCE;
    }

    public static synchronized void setInstance(ProductInfo i) {
        INSTANCE = i;
    }

    public static final ProductInfo createDefault() throws IOException {
        Properties p = PropertiesUtils.createFromResource(ProductInfo.class, PROPERTIES_NAME);
        return p == null ? null : new ProductInfo(p);
    }

    public ProductInfo(String name) {
        this(Collections.singletonMap(NAME, name));
    }

    public ProductInfo(Map<String, String> map) {
        this(PropertiesUtils.createFromMap(map));
    }

    public ProductInfo(Properties props) {
        if (props == null) {
            throw new NullPointerException("Null properties");
        }
        if (props.getProperty(NAME) == null) {
            throw new IllegalArgumentException("Missing NAME");
        }
        this.props = props;
    }

    private final Properties getProps() {
        return this.props;
    }

    public final String getProperty(String name) {
        return this.getProps().getProperty(name);
    }

    public final String getProperty(String name, String def) {
        return this.getProps().getProperty(name, def);
    }

    public final String getName() {
        return this.getProperty(NAME, "unnamed product");
    }

    public final String getVersion() {
        return this.getProperty(VERSION);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " for " + this.getName() + " " + this.getVersion();
    }
}

