/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Nombre {
    private int nb;
    static int[] puissanceMille;
    public static int FR;
    public static int EN;
    public static int ES;
    public static int PL;
    private final NombreLocal local;

    static {
        int[] nArray = new int[4];
        nArray[1] = 1000;
        nArray[2] = 1000000;
        nArray[3] = 1000000000;
        puissanceMille = nArray;
        FR = 0;
        EN = 1;
        ES = 2;
        PL = 3;
    }

    public Nombre(int i) {
        this(i, FR);
    }

    public Nombre(int i, int language) {
        this.nb = i;
        this.local = language == EN ? new NombreLocalEN() : (language == PL ? new NombreLocalPL() : (language == ES ? new NombreLocalES() : new NombreLocalFR()));
    }

    public Nombre(int i, NombreLocal local) {
        this.nb = i;
        this.local = local;
    }

    public String getText() {
        StringBuffer result = new StringBuffer();
        if (this.nb < 0) {
            result.append(this.local.negatifLabel);
        }
        if (this.local.getNombrePredefini(this.nb) != null) {
            result.append(this.local.getNombrePredefini(this.nb));
        } else if (this.nb < 100) {
            int decimal = this.nb / 10;
            int unit = this.nb % 10;
            result.append(this.local.getDizaine(decimal));
            if (unit > 0) {
                if (this.local.separateurDizaineLabel != null && this.local.separateurDizaineLabel.length() > 0) {
                    result.append(" " + this.local.separateurDizaineLabel);
                }
                result.append(" " + this.local.getNombrePredefini(unit));
            }
        } else if (this.nb < 1000) {
            int cent = this.nb / 100;
            if (this.local.getNombrePredefini(cent * 100) != null) {
                result.append(this.local.getNombrePredefini(cent * 100));
            } else {
                result.append(String.valueOf(this.local.getNombrePredefini(cent)) + " " + this.local.getDizaine(10));
            }
            int reste = this.nb - cent * 100;
            if (reste > 0) {
                Nombre d = new Nombre(reste, this.local);
                if (this.local.separateurDizaineLabel != null && this.local.separateurDizaineLabel.length() > 0) {
                    result.append(" " + this.local.separateurDizaineLabel);
                }
                result.append(" " + d.getText());
            }
        } else {
            int longueur = new Double(Math.ceil((double)String.valueOf(this.nb).length() / 3.0)).intValue();
            int cumul = 0;
            int i = longueur - 1;
            while (i > 0) {
                int puissancei = puissanceMille[i];
                int val = (this.nb - cumul) / puissancei;
                if (val > 0) {
                    if (val > 1 && i - 1 > 0) {
                        result.append(String.valueOf(new Nombre(val, this.local).getText()) + " " + this.local.getMult(i - 1) + "s ");
                    } else {
                        result.append(String.valueOf(new Nombre(val, this.local).getText()) + " " + this.local.getMult(i - 1) + " ");
                    }
                }
                cumul += val * puissancei;
                --i;
            }
            int val = this.nb % 1000;
            if (val > 0) {
                result.append(new Nombre(val, this.local).getText());
            }
        }
        System.err.println(result.toString().trim());
        return result.toString().trim();
    }

    String getText(String r) {
        return String.valueOf(r);
    }

    public NombreLocal getLocal() {
        return this.local;
    }

    public class NombreLocal {
        protected final Map<Integer, String> nombrePredefini = new HashMap<Integer, String>();
        protected final List<String> dizaine = new ArrayList<String>();
        protected final List<String> mult = new ArrayList<String>();
        protected final String separateurLabel;
        protected final String separateurDizaineLabel;
        protected final String negatifLabel;

        public NombreLocal(String sep, String sepDizaine, String neg) {
            this.negatifLabel = neg;
            this.separateurLabel = sep;
            this.separateurDizaineLabel = sepDizaine;
        }

        public String getDizaine(int index) {
            return this.dizaine.get(index);
        }

        public String getMult(int index) {
            return this.mult.get(index);
        }

        public String getNombrePredefini(int value) {
            return this.nombrePredefini.get(value);
        }

        public String getSeparateurLabel() {
            return this.separateurLabel;
        }
    }

    private class NombreLocalEN
    extends NombreLocal {
        final String[] ref0;
        final String[] ref10;
        final String[] refmult;

        public NombreLocalEN() {
            super("and", "", "moins");
            this.ref0 = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen", "twenty"};
            this.ref10 = new String[]{"zero", "ten", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety", "hundred"};
            this.refmult = new String[]{"thousand", "million", "billion", "billion", "trillion"};
            int i = 0;
            while (i < this.ref0.length) {
                this.nombrePredefini.put(i, this.ref0[i]);
                ++i;
            }
            i = 0;
            while (i < this.ref10.length) {
                this.dizaine.add(this.ref10[i]);
                ++i;
            }
            i = 0;
            while (i < this.refmult.length) {
                this.mult.add(this.refmult[i]);
                ++i;
            }
            this.nombrePredefini.put(100, "one hundred");
        }
    }

    private class NombreLocalES
    extends NombreLocal {
        final String[] ref0;
        final String[] ref10;
        final String[] refmult;

        public NombreLocalES() {
            super("y", "y", "moins");
            this.ref0 = new String[]{"cero", "uno", "dos", "tres", "cuatro", "cinco", "seis", "siete", "ocho", "nueve", "diez", "once", "doce", "trece", "catorce", "quince", "dieciseis", "diecisiete", "dieciocho", "diecinueve", "veinte"};
            this.ref10 = new String[]{"cero", "diez", "veinte", "treinta", "cuarenta", "cincuenta", "sesenta", "setenta", "ochenta", "noventa", "cien"};
            this.refmult = new String[]{"mil", "mill\u00f3n", "millar", "bill\u00f3n", "trill\u00f3n"};
            int i = 0;
            while (i < this.ref0.length) {
                this.nombrePredefini.put(i, this.ref0[i]);
                ++i;
            }
            i = 0;
            while (i < this.ref10.length) {
                this.dizaine.add(this.ref10[i]);
                ++i;
            }
            i = 0;
            while (i < this.refmult.length) {
                this.mult.add(this.refmult[i]);
                ++i;
            }
            this.nombrePredefini.put(100, "cien");
            this.nombrePredefini.put(21, "veintiuno");
            this.nombrePredefini.put(22, "veintidos");
            this.nombrePredefini.put(23, "veintitr\u00e9s");
            this.nombrePredefini.put(24, "veinticuatro");
            this.nombrePredefini.put(25, "veinticinco");
            this.nombrePredefini.put(26, "veintis\u00e9is");
            this.nombrePredefini.put(27, "veintisiete");
            this.nombrePredefini.put(28, "veintiocho");
            this.nombrePredefini.put(29, "veintinueve");
            this.nombrePredefini.put(200, "doscientos");
            this.nombrePredefini.put(300, "trescientos");
            this.nombrePredefini.put(400, "cuatrocientos");
            this.nombrePredefini.put(500, "quinientos");
            this.nombrePredefini.put(600, "seiscientos");
            this.nombrePredefini.put(700, "setecientos");
            this.nombrePredefini.put(800, "ochocientos");
            this.nombrePredefini.put(900, "novecientos");
        }
    }

    private class NombreLocalFR
    extends NombreLocal {
        final String[] ref0;
        final String[] ref10;
        final String[] refmult;

        public NombreLocalFR() {
            super("et", "", "moins");
            this.ref0 = new String[]{"z\u00e9ro", "un", "deux", "trois", "quatre", "cinq", "six", "sept", "huit", "neuf", "dix", "onze", "douze", "treize", "quatorze", "quinze", "seize", "dix sept", "dix huit", "dix neuf", "vingt"};
            this.ref10 = new String[]{"z\u00e9ro", "dix", "vingt", "trente", "quarante", "cinquante", "soixante", "soixante", "quatre vingt", "quatre vingt", "cent"};
            this.refmult = new String[]{"mille", "million", "milliard", "billion", "trillion"};
            int i = 0;
            while (i < this.ref0.length) {
                this.nombrePredefini.put(i, this.ref0[i]);
                ++i;
            }
            i = 0;
            while (i < this.ref10.length) {
                this.dizaine.add(this.ref10[i]);
                ++i;
            }
            i = 0;
            while (i < this.refmult.length) {
                this.mult.add(this.refmult[i]);
                ++i;
            }
            this.nombrePredefini.put(21, "vingt et un");
            this.nombrePredefini.put(31, "trente et un");
            this.nombrePredefini.put(41, "quarante et un");
            this.nombrePredefini.put(51, "cinquante et un");
            this.nombrePredefini.put(61, "soixante et un");
            this.nombrePredefini.put(70, "soixante dix");
            this.nombrePredefini.put(71, "soixante et onze");
            this.nombrePredefini.put(72, "soixante douze");
            this.nombrePredefini.put(73, "soixante treize");
            this.nombrePredefini.put(74, "soixante quatorze");
            this.nombrePredefini.put(75, "soixante quinze");
            this.nombrePredefini.put(76, "soixante seize");
            this.nombrePredefini.put(77, "soixante dix sept");
            this.nombrePredefini.put(78, "soixante dix huit");
            this.nombrePredefini.put(79, "soixante dix neuf");
            this.nombrePredefini.put(90, "quatre vingt dix");
            this.nombrePredefini.put(91, "quatre vingt onze");
            this.nombrePredefini.put(92, "quatre vingt douze");
            this.nombrePredefini.put(93, "quatre vingt treize");
            this.nombrePredefini.put(94, "quatre vingt quatorze");
            this.nombrePredefini.put(95, "quatre vingt quinze");
            this.nombrePredefini.put(96, "quatre vingt seize");
            this.nombrePredefini.put(97, "quatre vingt dix sept");
            this.nombrePredefini.put(98, "quatre vingt dix huit");
            this.nombrePredefini.put(99, "quatre vingt dix neuf");
            this.nombrePredefini.put(100, "cent");
        }
    }

    private class NombreLocalPL
    extends NombreLocal {
        final String[] ref0;
        final String[] ref10;
        final String[] refmult;

        public NombreLocalPL() {
            super("i", "", "moins");
            this.ref0 = new String[]{"zero", "jeden", "dwa", "trzy", "cztery", "pi\u0119\u0107", "sze\u015b\u0107", "siedem", "osiem", "dziewi\u0119\u0107", "diesi\u0119\u0107", "jedena\u015bcie", "dwana\u015bcie", "trzyna\u015bcie", "czterna\u015bcie", "pi\u0119tna\u015bcie", "szesna\u015bcie", "siedemna\u015bcie", "osiemna\u015bcie", "dziewi\u0119tna\u015bcie", "dwadzie\u015bcia"};
            this.ref10 = new String[]{"zero", "dziesi\u0119\u0107", "dwadzie\u015bcia", "trzydzie\u015bci", "czterdzie\u015bci", "pi\u0119\u0107dziesi\u0105t", "sze\u015b\u0107dziesi\u0105t", "siedemdziesi\u0105t", "osiemdziesi\u0105t", "dziewi\u0119\u0107dziesi\u0105t", "sto"};
            this.refmult = new String[]{"tysi\u0105\u0107", "milion", "miliard", "bilion", "trilion"};
            int i = 0;
            while (i < this.ref0.length) {
                this.nombrePredefini.put(i, this.ref0[i]);
                ++i;
            }
            i = 0;
            while (i < this.ref10.length) {
                this.dizaine.add(this.ref10[i]);
                ++i;
            }
            i = 0;
            while (i < this.refmult.length) {
                this.mult.add(this.refmult[i]);
                ++i;
            }
            this.nombrePredefini.put(100, "sto");
            this.nombrePredefini.put(200, "dwiescie");
            this.nombrePredefini.put(300, "trysta");
            this.nombrePredefini.put(400, "czterysta");
            this.nombrePredefini.put(500, "pi\u0119\u0107dziesi\u0105t");
            this.nombrePredefini.put(600, "sze\u015b\u0107dziesi\u0105t");
            this.nombrePredefini.put(700, "siedemdziesi\u0105t");
            this.nombrePredefini.put(800, "osiemdziesi\u0105t");
            this.nombrePredefini.put(900, "dziewi\u0119\u0107dziesi\u0105t");
        }
    }
}

