/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class FormatGroup
extends Format {
    private final List<? extends Format> formats;
    private int formatIndex;

    public FormatGroup(Format ... formats) {
        this(Arrays.asList(formats));
    }

    public FormatGroup(List<? extends Format> formats) {
        if (formats.size() == 0) {
            throw new IllegalArgumentException("formats must not be empty");
        }
        this.formats = formats;
        this.formatIndex = 0;
    }

    public final List<? extends Format> getFormats() {
        return this.formats;
    }

    @Override
    public StringBuffer format(Object newVal, StringBuffer toAppendTo, FieldPosition pos) {
        return this.formats.get(this.formatIndex).format(newVal, toAppendTo, pos);
    }

    @Override
    public Object parseObject(String s, ParsePosition pos) {
        Object res;
        if (pos.getErrorIndex() >= 0) {
            throw new IllegalArgumentException(pos + " has en error at " + pos.getErrorIndex());
        }
        boolean success = false;
        Object tmpRes = null;
        ParsePosition tmpPos = new ParsePosition(pos.getIndex());
        Iterator<? extends Format> iter = this.formats.iterator();
        while (iter.hasNext() && !success) {
            Format f = iter.next();
            this.mutateTo(tmpPos, pos);
            tmpRes = f.parseObject(s, tmpPos);
            boolean bl = success = tmpPos.getIndex() != pos.getIndex() && tmpPos.getErrorIndex() < 0;
        }
        if (!success) {
            res = this.formats.get(this.formatIndex).parseObject(s, pos);
        } else {
            res = tmpRes;
            this.mutateTo(pos, tmpPos);
        }
        return res;
    }

    private void mutateTo(ParsePosition tmpPos, ParsePosition pos) {
        tmpPos.setIndex(pos.getIndex());
        tmpPos.setErrorIndex(pos.getErrorIndex());
    }

    public final int getFormatIndex() {
        return this.formatIndex;
    }

    public final void setFormatIndex(int formatIndex) {
        if (formatIndex < 0 || formatIndex >= this.getFormats().size()) {
            throw new IllegalArgumentException(String.valueOf(formatIndex) + " out of bounds");
        }
        this.formatIndex = formatIndex;
    }
}

