/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.awt.Color;

public class FillMode {
    public static final FillMode STRETCH = new FillMode(false);
    public static final FillMode ZOOM_CENTER = new ZoomIn(0);
    public static final FillMode ZOOM_LEADING = new ZoomIn(10);
    public static final FillMode ZOOM_TRAILING = new ZoomIn(11);
    private final boolean keepRatio;

    protected FillMode(boolean keepRatio) {
        this.keepRatio = keepRatio;
    }

    public final boolean isRatioKept() {
        return this.keepRatio;
    }

    public static class ZoomIn
    extends FillMode {
        private final int position;

        public ZoomIn(int position) {
            super(true);
            if (position != 0 && position != 10 && position != 11) {
                throw new IllegalArgumentException("Neither center, leading nor trailing");
            }
            this.position = position;
        }

        public final int getPosition() {
            return this.position;
        }

        public final int getPosition(int external, int internal) {
            int res;
            if (external < internal) {
                throw new IllegalArgumentException("External < Internal : " + external + " < " + internal);
            }
            if (this.getPosition() == 0) {
                res = (external - internal) / 2;
            } else if (this.getPosition() == 10) {
                res = 0;
            } else if (this.getPosition() == 11) {
                res = external - internal;
            } else {
                throw new IllegalStateException("Unkwown position");
            }
            return res;
        }
    }

    public static class ZoomOut
    extends FillMode {
        private final Color bg;

        public ZoomOut(Color bg) {
            super(true);
            this.bg = bg;
        }

        public final Color getBackgroundColor() {
            return this.bg;
        }
    }
}

