/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.openconcerto.utils.CollectionMap2Itf;
import org.openconcerto.utils.CopyUtils;
import org.openconcerto.utils.cc.AbstractMapDecorator;

public abstract class CollectionMap2<K, C extends Collection<V>, V>
extends AbstractMapDecorator<K, C>
implements Cloneable,
CollectionMap2Itf<K, C, V> {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected static final Mode DEFAULT_MODE = Mode.NULL_FORBIDDEN;
    private static final Boolean DEFAULT_emptyCollSameAsNoColl = null;
    private final boolean emptyCollSameAsNoColl;
    private final Mode mode;
    private transient Collection<V> allValues = null;

    private static final String toStr(Object o) {
        return o == null ? "null" : "'" + o + "'";
    }

    public CollectionMap2() {
        this(DEFAULT_MODE);
    }

    public CollectionMap2(Mode mode) {
        this(mode, DEFAULT_emptyCollSameAsNoColl);
    }

    public CollectionMap2(Map<K, C> delegate, Mode mode) {
        this(delegate, mode, DEFAULT_emptyCollSameAsNoColl);
    }

    public CollectionMap2(Mode mode, Boolean emptyCollSameAsNoColl) {
        this(16, mode, emptyCollSameAsNoColl);
    }

    public CollectionMap2(int initialCapacity) {
        this(initialCapacity, DEFAULT_MODE, DEFAULT_emptyCollSameAsNoColl);
    }

    public CollectionMap2(int initialCapacity, Mode mode, Boolean emptyCollSameAsNoColl) {
        this(new HashMap(initialCapacity), mode, emptyCollSameAsNoColl);
    }

    public CollectionMap2(Map<K, C> delegate, Mode mode, Boolean emptyCollSameAsNoColl) {
        super(delegate);
        if (mode == null) {
            throw new NullPointerException("Null mode");
        }
        this.mode = mode;
        this.emptyCollSameAsNoColl = emptyCollSameAsNoColl == null ? mode == Mode.NULL_MEANS_ALL : emptyCollSameAsNoColl;
        this.checkMode();
    }

    private final void checkMode() {
        assert (this.mode != null) : "Called too early";
        if (this.mode == Mode.NULL_FORBIDDEN && this.containsValue(null)) {
            throw new IllegalArgumentException("Null collection");
        }
    }

    public CollectionMap2(CollectionMap2<K, C, ? extends V> m) {
        this(CopyUtils.copy(m.getDelegate()), m);
    }

    public CollectionMap2(Map<? extends K, ? extends Collection<? extends V>> m) {
        this(new HashMap(m.size()), m);
    }

    public CollectionMap2(Map<K, C> delegate, Map<? extends K, ? extends Collection<? extends V>> m) {
        super(delegate);
        if (m instanceof CollectionMap2) {
            CollectionMap2 collM = (CollectionMap2)m;
            this.mode = collM.getMode();
            this.emptyCollSameAsNoColl = collM.isEmptyCollSameAsNoColl();
        } else {
            this.mode = DEFAULT_MODE;
            this.emptyCollSameAsNoColl = this.mode == Mode.NULL_MEANS_ALL;
        }
        this.clear();
        this.putAllCollections(m);
    }

    @Override
    public final Mode getMode() {
        return this.mode;
    }

    @Override
    public final boolean isEmptyCollSameAsNoColl() {
        return this.emptyCollSameAsNoColl;
    }

    public final C getNonNullIfMissing(Object key) {
        return this.get(key, false, true);
    }

    @Override
    public final C getNonNull(K key) {
        return this.get(key, false, false);
    }

    private final C getNonNullColl(C res) {
        return res == null ? this.createCollection(Collections.emptySet()) : res;
    }

    @Override
    public final C get(Object key, boolean nullIfMissing, boolean nullIfPresent) {
        if (nullIfMissing == nullIfPresent) {
            Collection res = (Collection)super.get(key);
            if (res != null || nullIfMissing && nullIfPresent) {
                return (C)res;
            }
            assert (!nullIfMissing && !nullIfPresent);
            return this.getNonNullColl(null);
        }
        if (nullIfMissing) {
            assert (!nullIfPresent);
            if (!this.containsKey(key)) {
                return null;
            }
            return (C)this.getNonNullColl((Collection)super.get(key));
        }
        assert (!nullIfMissing && nullIfPresent);
        if (this.containsKey(key)) {
            return (C)((Collection)super.get(key));
        }
        return this.getNonNullColl(null);
    }

    @Override
    public final C getCollection(Object key) {
        return this.get(key, !this.isEmptyCollSameAsNoColl(), true);
    }

    @Override
    public Collection<V> allValues() {
        if (this.allValues == null) {
            this.allValues = new AllValues();
        }
        return this.allValues;
    }

    @Override
    public Set<Map.Entry<K, C>> entrySet() {
        if (this.getMode() == Mode.NULL_FORBIDDEN) {
            return new EntrySet(super.entrySet());
        }
        return super.entrySet();
    }

    @Override
    public final C put(K key, C value) {
        return this.putCollection(key, (Collection<? extends V>)value);
    }

    @Override
    public final C putCollection(K key, Collection<? extends V> value) {
        if (value == null && this.getMode() == Mode.NULL_FORBIDDEN) {
            throw new NullPointerException("Putting null collection for " + CollectionMap2.toStr(key));
        }
        return (C)((Collection)super.put(key, value == null ? null : (Object)this.createCollection(value)));
    }

    public final C putCollection(K key, V ... value) {
        return this.putCollection(key, (Collection<? extends V>)Arrays.asList(value));
    }

    public void putAllCollections(Map<? extends K, ? extends Collection<? extends V>> m) {
        this.putAllCollections(m, false);
    }

    public void putAllCollections(Map<? extends K, ? extends Collection<? extends V>> m, boolean removeEmptyCollections) {
        for (Map.Entry<K, Collection<V>> e : m.entrySet()) {
            if (removeEmptyCollections && e.getValue().isEmpty()) continue;
            this.putCollection(e.getKey(), e.getValue());
        }
    }

    @Override
    public final boolean add(K k, V v) {
        return this.addAll(k, (Collection<? extends V>)Collections.singleton(v));
    }

    public final boolean addAll(K k, V ... v) {
        return this.addAll(k, (Collection<? extends V>)Arrays.asList(v));
    }

    @Override
    public final boolean addAll(K k, Collection<? extends V> v) {
        boolean nullIsAll;
        boolean bl = nullIsAll = this.getMode() == Mode.NULL_MEANS_ALL;
        if (v == null && !nullIsAll) {
            throw new NullPointerException("Adding null collection for " + CollectionMap2.toStr(k));
        }
        boolean containsKey = this.containsKey(k);
        if (v == null) {
            return this.putCollection(k, v) != null;
        }
        if (!containsKey) {
            this.putCollection(k, v);
            return true;
        }
        Collection currentColl = (Collection)this.get(k);
        if (nullIsAll && currentColl == null) {
            return false;
        }
        return currentColl.addAll(v);
    }

    @Override
    public final void merge(Map<? extends K, ? extends Collection<? extends V>> mm) {
        for (Map.Entry<K, Collection<V>> e : mm.entrySet()) {
            this.addAll(e.getKey(), e.getValue());
        }
    }

    @Override
    public final void mergeScalarMap(Map<? extends K, ? extends V> scalarMap) {
        for (Map.Entry<K, V> e : scalarMap.entrySet()) {
            this.add(e.getKey(), e.getValue());
        }
    }

    @Override
    public final boolean remove(K k, V v) {
        return this.removeAll(k, Collections.singleton(v));
    }

    @Override
    public final boolean removeAll(K k, Collection<? extends V> v) {
        return this.removeAll(k, v, null);
    }

    private final boolean removeAll(K k, Collection<? extends V> v, Iterator<Map.Entry<K, C>> iter) {
        boolean removeK = false;
        boolean modified = false;
        if (this.getMode() == Mode.NULL_MEANS_ALL) {
            if (v == null) {
                removeK = true;
            } else if (v.size() > 0) {
                Collection currentColl = (Collection)this.get(k);
                if (currentColl == null) {
                    throw new IllegalStateException("Cannot remove from all for " + CollectionMap2.toStr(k));
                }
                modified = currentColl.removeAll(v);
                if (currentColl.isEmpty()) {
                    removeK = true;
                }
            }
        } else if (this.containsKey(k)) {
            Collection currentColl = (Collection)this.get(k);
            if (currentColl == null && v == null) {
                assert (this.getMode() == Mode.NULL_ALLOWED);
                removeK = true;
                modified = true;
            } else {
                if (v == null) {
                    throw new NullPointerException("Removing null collection for " + CollectionMap2.toStr(k));
                }
                modified = currentColl.removeAll(v);
                if (currentColl.isEmpty()) {
                    removeK = true;
                }
            }
        }
        if (removeK) {
            if (iter == null) {
                modified |= this.containsKey(k);
                this.remove(k);
            } else {
                iter.remove();
                modified = true;
            }
        }
        return modified;
    }

    @Override
    public final boolean removeAll(Map<? extends K, ? extends Collection<? extends V>> mm) {
        boolean modified = false;
        Iterator<Map.Entry<K, C>> iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<K, C> e = iter.next();
            K key = e.getKey();
            if (!mm.containsKey(key)) continue;
            modified |= this.removeAll(key, mm.get(key), iter);
        }
        return modified;
    }

    @Override
    public final boolean removeAllScalar(Map<? extends K, ? extends V> m) {
        boolean modified = false;
        assert (m != this);
        for (Map.Entry<K, V> e : m.entrySet()) {
            modified |= this.remove(e.getKey(), e.getValue());
        }
        return modified;
    }

    public final C removeIfEmpty(K k) {
        Collection v = (Collection)this.get(k);
        if (v != null && v.isEmpty()) {
            return (C)((Collection)this.remove(k));
        }
        return null;
    }

    public final void removeIfNull(K k) {
        if (this.get(k) == null) {
            this.remove(k);
        }
    }

    @Override
    public final Set<K> removeAllEmptyCollections() {
        return this.removeAll(true);
    }

    @Override
    public final Set<K> removeAllNullCollections() {
        return this.removeAll(false);
    }

    private final Set<K> removeAll(boolean emptyOrNull) {
        HashSet<K> removed = new HashSet<K>();
        Iterator<Map.Entry<K, C>> iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<K, C> e = iter.next();
            Collection val = (Collection)e.getValue();
            if ((!emptyOrNull || val == null || !val.isEmpty()) && (emptyOrNull || val != null)) continue;
            iter.remove();
            removed.add(e.getKey());
        }
        return removed;
    }

    public abstract C createCollection(Collection<? extends V> var1);

    @Override
    public int hashCode() {
        if (this.mode == Mode.NULL_MEANS_ALL) {
            return this.hashCodeExact();
        }
        return super.hashCode();
    }

    public int hashCodeExact() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.emptyCollSameAsNoColl ? 1231 : 1237);
        result = 31 * result + this.mode.hashCode();
        return result;
    }

    @Override
    public final boolean equals(Object obj) {
        return this.equals(obj, false);
    }

    public final boolean equalsExact(Object obj) {
        return this.equals(obj, true);
    }

    private final boolean equals(Object obj, boolean forceExact) {
        CollectionMap2 other;
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        CollectionMap2 collectionMap2 = other = obj instanceof CollectionMap2 ? (CollectionMap2)obj : null;
        if (forceExact || this.mode == Mode.NULL_MEANS_ALL || other != null && other.mode == Mode.NULL_MEANS_ALL) {
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.emptyCollSameAsNoColl == other.emptyCollSameAsNoColl && this.mode == other.mode && this.getDelegate().getClass() == other.getDelegate().getClass();
        }
        return true;
    }

    @Override
    public CollectionMap2<K, C, V> clone() throws CloneNotSupportedException {
        CollectionMap2 result = (CollectionMap2)super.clone();
        result.allValues = null;
        for (Map.Entry<K, C> entry : result.entrySet()) {
            Collection coll = (Collection)entry.getValue();
            entry.setValue(this.createCollection(coll));
        }
        return result;
    }

    private final class AllValues
    extends AbstractCollection<V> {
        private AllValues() {
        }

        @Override
        public Iterator<V> iterator() {
            return new AllValuesIterator();
        }

        @Override
        public int size() {
            int compt = 0;
            for (Collection c : CollectionMap2.this.values()) {
                if (c == null) continue;
                compt += c.size();
            }
            return compt;
        }
    }

    private final class AllValuesIterator
    implements Iterator<V> {
        private final Iterator<C> mapIterator;
        private Iterator<V> tempIterator;

        private AllValuesIterator() {
            this.mapIterator = CollectionMap2.this.values().iterator();
            this.tempIterator = null;
        }

        private boolean searchNextIterator() {
            while (this.tempIterator == null || !this.tempIterator.hasNext()) {
                if (!this.mapIterator.hasNext()) {
                    return false;
                }
                Collection nextCol = (Collection)this.mapIterator.next();
                Iterator<Object> iterator = this.tempIterator = nextCol == null ? null : nextCol.iterator();
            }
            return true;
        }

        @Override
        public boolean hasNext() {
            return this.searchNextIterator();
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.tempIterator.next();
        }

        @Override
        public void remove() {
            if (this.tempIterator == null) {
                throw new IllegalStateException();
            }
            this.tempIterator.remove();
        }
    }

    private final class EntrySet
    extends AbstractCollection<Map.Entry<K, C>>
    implements Set<Map.Entry<K, C>> {
        private final Set<Map.Entry<K, C>> delegate;

        public EntrySet(Set<Map.Entry<K, C>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.delegate.remove(o);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public Iterator<Map.Entry<K, C>> iterator() {
            return new Iterator<Map.Entry<K, C>>(){
                private final Iterator<Map.Entry<K, C>> delegateIter;
                {
                    this.delegateIter = EntrySet.this.delegate.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.delegateIter.hasNext();
                }

                @Override
                public Map.Entry<K, C> next() {
                    final Map.Entry delegate = this.delegateIter.next();
                    return new Map.Entry<K, C>(){

                        @Override
                        public K getKey() {
                            return delegate.getKey();
                        }

                        @Override
                        public C getValue() {
                            return (Collection)delegate.getValue();
                        }

                        @Override
                        public C setValue(C value) {
                            if (value == null) {
                                throw new NullPointerException("Putting null collection for " + CollectionMap2.toStr(this.getKey()));
                            }
                            return (Collection)delegate.setValue(value);
                        }
                    };
                }

                @Override
                public void remove() {
                    this.delegateIter.remove();
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.delegate.removeAll(c);
        }
    }

    public static enum Mode {
        NULL_FORBIDDEN,
        NULL_ALLOWED,
        NULL_MEANS_ALL;

    }
}

