/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.valuewrapper;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.openconcerto.ui.valuewrapper.BaseValueWrapper;
import org.openconcerto.utils.checks.MutableValueObject;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidObject;
import org.openconcerto.utils.checks.ValidState;

public final class ValueWrapperFromVO<T>
extends BaseValueWrapper<T> {
    private final MutableValueObject<T> vo;

    public ValueWrapperFromVO(MutableValueObject<T> vo) {
        if (!(vo instanceof JComponent)) {
            throw new IllegalArgumentException("vo is not a JComponent: " + vo);
        }
        this.vo = vo;
        this.vo.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ValueWrapperFromVO.this.firePropertyChange();
            }
        });
        if (this.hasValidObject()) {
            this.getValidObject().addValidListener(new ValidListener(){

                @Override
                public void validChange(ValidObject src, ValidState newValue) {
                    ValueWrapperFromVO.this.firePropertyChange();
                }
            });
        }
    }

    private final ValidObject getValidObject() {
        return (ValidObject)((Object)this.vo);
    }

    private boolean hasValidObject() {
        return this.vo instanceof ValidObject;
    }

    @Override
    public final JComponent getComp() {
        return (JComponent)((Object)this.vo);
    }

    @Override
    public final T getValue() {
        return this.vo.getValue();
    }

    @Override
    public final void setValue(T val) {
        this.vo.setValue(val);
    }

    @Override
    public ValidState getValidState() {
        if (this.hasValidObject()) {
            return this.getValidObject().getValidState();
        }
        return ValidState.getTrueInstance();
    }
}

