/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.table;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.openconcerto.ui.Log;
import org.openconcerto.ui.table.TableColumnModelAdapter;
import org.openconcerto.utils.Tuple2;

public class ColumnSizeAdjustor {
    private final JTable table;
    private final PropertyChangeListener propL;
    private TableColumnModel columnModel;
    private final TableColumnModelListener columnL;
    private TableModel tableModel;
    private final TableModelListener tableL;
    private int origAutoResizeMode;
    private final PropertyChangeListener autoResizeL;
    private final List<Integer> maxWidths;
    private boolean installed;

    public ColumnSizeAdjustor(JTable table) {
        this.table = table;
        this.autoResizeL = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("autoResizeMode")) {
                    Log.get().warning(String.valueOf(evt.getPropertyName()) + " changed so uninstalling " + ColumnSizeAdjustor.this);
                    ColumnSizeAdjustor.this.uninstall();
                } else if (evt.getPropertyName().equals("model")) {
                    ColumnSizeAdjustor.this.removeTableModelListener();
                    ColumnSizeAdjustor.this.addTableModelListener();
                }
            }
        };
        this.propL = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ColumnSizeAdjustor.this.removeColModelListener();
                ColumnSizeAdjustor.this.addColModelListener();
            }
        };
        this.columnL = new TableColumnModelAdapter(){

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                TableColumnModel model = (TableColumnModel)e.getSource();
                ColumnSizeAdjustor.this.packColumn(model.getColumn(e.getToIndex()).getModelIndex(), 0, 0, -1);
            }
        };
        this.tableL = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e == null || e.getFirstRow() == -1) {
                    ColumnSizeAdjustor.this.maxWidths.clear();
                } else {
                    boolean allCols = e.getColumn() == -1;
                    int firstCol = allCols ? 0 : e.getColumn();
                    int lastCol = allCols ? ((TableModel)e.getSource()).getColumnCount() : e.getColumn() + 1;
                    int i = firstCol;
                    while (i < lastCol) {
                        ColumnSizeAdjustor.this.packColumn(i, e.getType(), e.getFirstRow(), e.getLastRow());
                        ++i;
                    }
                }
            }
        };
        this.maxWidths = new ArrayList<Integer>();
        this.installed = false;
        this.tableModel = null;
        this.install();
    }

    public final boolean isInstalled() {
        return this.installed;
    }

    public void setInstalled(boolean b) {
        if (b != this.installed) {
            if (b) {
                this.origAutoResizeMode = this.table.getAutoResizeMode();
                this.table.setAutoResizeMode(0);
                this.table.addPropertyChangeListener(this.autoResizeL);
                this.table.addPropertyChangeListener("columnModel", this.propL);
                this.addColModelListener();
                this.addTableModelListener();
                this.packColumns();
            } else {
                this.removeTableModelListener();
                this.table.removePropertyChangeListener(this.autoResizeL);
                if (this.table.getAutoResizeMode() == 0) {
                    this.table.setAutoResizeMode(this.origAutoResizeMode);
                }
                this.table.removePropertyChangeListener("columnModel", this.propL);
                this.removeColModelListener();
            }
            this.installed = b;
        }
    }

    private void addTableModelListener() {
        this.removeTableModelListener();
        assert (this.tableModel == null && this.maxWidths.isEmpty());
        this.tableModel = this.table.getModel();
        this.tableModel.addTableModelListener(this.tableL);
    }

    private void removeTableModelListener() {
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this.tableL);
            this.tableModel = null;
            this.maxWidths.clear();
        }
    }

    private void addColModelListener() {
        this.removeColModelListener();
        assert (this.columnModel == null && this.maxWidths.isEmpty());
        this.columnModel = this.table.getColumnModel();
        this.columnModel.addColumnModelListener(this.columnL);
    }

    private void removeColModelListener() {
        if (this.columnModel != null) {
            this.columnModel.removeColumnModelListener(this.columnL);
            this.columnModel = null;
            this.maxWidths.clear();
        }
    }

    public void install() {
        this.setInstalled(true);
    }

    public void uninstall() {
        this.setInstalled(false);
    }

    public void packColumns() {
        int columnCount = this.tableModel.getColumnCount();
        this.maxWidths.clear();
        this.maxWidths.addAll(Collections.nCopies(columnCount, null));
        int c = 0;
        while (c < columnCount) {
            this.packColumn(c, 0, 0, -1);
            ++c;
        }
    }

    private final void packColumn(int colModelIndex, int type, int firstModelRow, int lastModelRow) {
        if (type == -1) {
            return;
        }
        int missing = colModelIndex - this.maxWidths.size() + 1;
        if (missing > 0) {
            this.maxWidths.addAll(Collections.nCopies(missing, null));
        }
        int initialWidth = this.maxWidths.get(colModelIndex) == null ? 0 : this.maxWidths.get(colModelIndex);
        Tuple2<TableColumn, Integer> colAndWidth = this.computeMaxWidth(colModelIndex, initialWidth, firstModelRow, lastModelRow);
        Integer width = colAndWidth.get1();
        this.maxWidths.set(colModelIndex, width);
        if (width != null) {
            int margin = 2;
            colAndWidth.get0().setPreferredWidth(width + 4);
        }
    }

    private final Tuple2<TableColumn, Integer> computeMaxWidth(int colModelIndex, int initialWidth, int firstModelRow, int last) {
        int viewIndex = this.table.convertColumnIndexToView(colModelIndex);
        if (viewIndex < 0) {
            return new Tuple2<Object, Object>(null, null);
        }
        TableColumn col = this.columnModel.getColumn(viewIndex);
        int rowCount = this.table.getRowCount();
        int lastModelRow = last < 0 || last >= rowCount ? rowCount : last + 1;
        int width = firstModelRow == 0 && lastModelRow == rowCount ? 0 : initialWidth;
        TableCellRenderer renderer = col.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.table.getTableHeader().getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(this.table, col.getHeaderValue(), false, false, 0, 0);
        width = Math.max(width, comp.getPreferredSize().width);
        int r = firstModelRow;
        while (r < lastModelRow) {
            int viewRow = this.table.convertRowIndexToView(r);
            renderer = this.table.getCellRenderer(viewRow, viewIndex);
            comp = renderer.getTableCellRendererComponent(this.table, this.table.getModel().getValueAt(r, colModelIndex), false, false, viewRow, viewIndex);
            width = Math.max(width, comp.getPreferredSize().width);
            ++r;
        }
        return Tuple2.create(col, width);
    }
}

