/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.list.selection;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openconcerto.ui.Log;
import org.openconcerto.ui.list.selection.BaseListStateModel;
import org.openconcerto.ui.list.selection.ListSelection;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformer;

public final class ListSelectionState
implements ListSelection {
    private final BaseListStateModel model;
    private final ListSelectionModel selModel;
    private final SortedMap<Integer, Integer> selection;
    private final Set<Integer> userSelectedIDs;
    private final PropertyChangeListener updateListener;
    private final ListSelectionListener selectionListener;
    private final PropertyChangeSupport supp;
    private boolean updating;
    private boolean strict;

    public static ListSelectionState manage(ListSelectionModel sel, BaseListStateModel model) {
        return new ListSelectionState(model, sel).start();
    }

    private ListSelectionState(BaseListStateModel model, ListSelectionModel sel) {
        this.model = model;
        this.selModel = sel;
        this.supp = new PropertyChangeSupport(this);
        this.updating = false;
        this.strict = false;
        this.selection = new TreeMap<Integer, Integer>();
        this.userSelectedIDs = new HashSet<Integer>();
        this.updateListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propName = evt.getPropertyName();
                if (propName.equals("updating")) {
                    ListSelectionState.this.setUpdating((Boolean)evt.getNewValue());
                }
            }
        };
        this.selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionState.this.rowSelected(e);
            }
        };
        this.start();
    }

    private ListSelectionState start() {
        this.model.addListener(this.updateListener);
        this.getSelModel().addListSelectionListener(this.selectionListener);
        return this;
    }

    void stop() {
        this.model.rmListener(this.updateListener);
        this.getSelModel().removeListSelectionListener(this.selectionListener);
    }

    public final BaseListStateModel getModel() {
        return this.model;
    }

    protected final ListSelectionModel getSelModel() {
        return this.selModel;
    }

    private void rowSelected(ListSelectionEvent e) {
        HashMap<Integer, Integer> newIDs = new HashMap<Integer, Integer>(this.getSelection());
        int i = e.getFirstIndex();
        while (i <= e.getLastIndex()) {
            if (!this.getSelModel().isSelectedIndex(i)) {
                newIDs.remove(i);
            } else {
                int id = this.idFromIndex(i);
                if (id == -1) {
                    throw new IllegalStateException("selected index " + i + " has no id");
                }
                newIDs.put(i, id);
            }
            ++i;
        }
        if (!newIDs.equals(this.getSelection())) {
            this.setSelectedIDs(newIDs);
        }
        if (!this.getModel().isUpdating()) {
            this.setUserSelectedIDs(this.getSelectedIDs());
        }
    }

    public void selectID(int id) {
        this.selectIDs(Collections.singletonList(id));
    }

    public void selectIDs(Collection<Integer> idsOrig) {
        ArrayList<Integer> ids = new ArrayList<Integer>(idsOrig);
        if (!this.getModel().isUpdating()) {
            TreeSet<Integer> newIndexes = new TreeSet<Integer>();
            for (Integer id : ids) {
                int index = this.indexFromID(id);
                if (index == -1) continue;
                newIndexes.add(index);
            }
            if (!this.getSelectedIndexesFast().equals(newIndexes)) {
                List<int[]> intervals = CollectionUtils.aggregate(new ArrayList(newIndexes));
                if (this.getSelModel().getSelectionMode() != 2 && intervals.size() > 1) {
                    String msg = "need MULTIPLE_INTERVAL_SELECTION to select " + CollectionUtils.join(intervals, ", ", new ITransformer<int[], String>(){

                        @Override
                        public String transformChecked(int[] input) {
                            return Arrays.toString(input);
                        }
                    });
                    if (this.isStrict()) {
                        throw new IllegalStateException(msg);
                    }
                    int[] firstInterval = intervals.get(0);
                    intervals = Collections.singletonList(firstInterval);
                    ids.clear();
                    int index = firstInterval[0];
                    while (index <= firstInterval[1]) {
                        ids.add(this.idFromIndex(index));
                        ++index;
                    }
                    Log.get().info(msg);
                }
                if (intervals.size() == 1) {
                    int[] interval = intervals.get(0);
                    this.getSelModel().setSelectionInterval(interval[0], interval[1]);
                } else {
                    this.getSelModel().setValueIsAdjusting(true);
                    this.getSelModel().clearSelection();
                    for (int[] interval : intervals) {
                        this.getSelModel().addSelectionInterval(interval[0], interval[1]);
                    }
                    this.getSelModel().setValueIsAdjusting(false);
                }
            }
        }
        this.setUserSelectedIDs(ids);
    }

    public int idFromIndex(int rowIndex) {
        try {
            return this.getModel().idFromIndex(rowIndex);
        }
        catch (IndexOutOfBoundsException e) {
            return -1;
        }
    }

    private int indexFromID(int id) {
        return this.getModel().indexFromID(id);
    }

    private SortedMap<Integer, Integer> getSelection() {
        return this.selection;
    }

    @Override
    public final List<Integer> getSelectedIDs() {
        return new ArrayList<Integer>(this.getSelection().values());
    }

    public final Set<Integer> getSelectedIndexes() {
        return Collections.unmodifiableSet(this.getSelectedIndexesFast());
    }

    private Set<Integer> getSelectedIndexesFast() {
        return this.getSelection().keySet();
    }

    public final Integer getSelectedIndex() {
        Integer res;
        if (this.getSelection().isEmpty()) {
            res = -1;
        } else {
            Integer lead = this.getSelModel().getLeadSelectionIndex();
            res = this.getSelectedIndexesFast().contains(lead) ? lead : this.getSelectedIndexesFast().iterator().next();
        }
        return res;
    }

    @Override
    public final int getSelectedID() {
        return this.getSelection().isEmpty() ? -1 : (Integer)this.getSelection().get(this.getSelectedIndex());
    }

    @Override
    public final Set<Integer> getUserSelectedIDs() {
        return this.userSelectedIDs;
    }

    @Override
    public final int getUserSelectedID() {
        return this.getUserSelectedIDs().size() > 0 ? this.getUserSelectedIDs().iterator().next() : -1;
    }

    private void setSelectedIDs(Map<Integer, Integer> selectedIDs) {
        this.selection.clear();
        this.selection.putAll(selectedIDs);
        this.supp.firePropertyChange("selectedIDs", null, this.getSelectedIDs());
        this.supp.firePropertyChange("selectedID", null, (Object)this.getSelectedID());
        this.supp.firePropertyChange("selectedIndexes", null, this.getSelectedIndexes());
        this.supp.firePropertyChange("selectedIndex", null, this.getSelectedIndex());
    }

    private void setUserSelectedIDs(Collection<Integer> userSelectedIDs) {
        if (!this.userSelectedIDs.equals(new HashSet<Integer>(userSelectedIDs))) {
            this.userSelectedIDs.clear();
            this.userSelectedIDs.addAll(userSelectedIDs);
            this.supp.firePropertyChange("userSelectedIDs", null, this.getUserSelectedIDs());
            this.supp.firePropertyChange("userSelectedID", null, (Object)this.getUserSelectedID());
        }
    }

    public final boolean isUpdating() {
        return this.updating;
    }

    private final void setUpdating(boolean upd) {
        if (upd != this.isUpdating()) {
            this.updating = upd;
            if (!this.isUpdating()) {
                this.selectIDs(this.getUserSelectedIDs());
            }
            this.supp.firePropertyChange("updating", null, (Object)this.updating);
        }
    }

    public final boolean isStrict() {
        return this.strict;
    }

    public final void setStrict(boolean strict) {
        this.strict = strict;
    }

    @Override
    public final void addPropertyChangeListener(String name, PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(name, l);
    }

    @Override
    public final void addPropertyChangeListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(l);
    }
}

