/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.list;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JList;
import org.openconcerto.ui.DefaultListModel;
import org.openconcerto.ui.list.RJLTransferable;

public class ReorderableJList
extends JList
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    private final DragSource dragSource;
    private final DropTarget dropTarget;
    private int draggedIndex = -1;

    public ReorderableJList() {
        this.setModel(new DefaultListModel());
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        this.dropTarget = new DropTarget(this, this);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        Point clickPoint = dge.getDragOrigin();
        int index = this.locationToIndex(clickPoint);
        if (index == -1) {
            return;
        }
        Object target = this.getModel().getElementAt(index);
        RJLTransferable trans = new RJLTransferable(target);
        this.draggedIndex = index;
        this.dragSource.startDrag(dge, new Cursor(12), trans, this);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.draggedIndex = -1;
        this.setCursor(Cursor.getDefaultCursor());
        this.repaint();
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (dtde.getSource() != this.dropTarget) {
            dtde.rejectDrag();
        } else {
            dtde.acceptDrag(3);
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (dtde.getSource() != this.dropTarget) {
            dtde.rejectDrag();
        }
        Point dragPoint = dtde.getLocation();
        int index = this.locationToIndex(dragPoint);
        try {
            if (index != this.draggedIndex) {
                DefaultListModel mod = (DefaultListModel)this.getModel();
                Object from = mod.remove(this.draggedIndex);
                mod.insertElementAt(from, index);
                this.setSelectedIndex(index);
                this.draggedIndex = index;
                this.repaint();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.repaint();
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }
}

