/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.Row;
import org.openconcerto.utils.io.JSONConverter;
import org.openconcerto.utils.io.Transferable;

public class TableContent
implements Transferable {
    private static final long serialVersionUID = 3648381615123520834L;
    private String tableId;
    private List<Row> rows;

    public TableContent() {
    }

    public TableContent(String tableId) {
        this.init(tableId, null);
    }

    public TableContent(String tableId, List<Row> rows) {
        this.init(tableId, rows);
    }

    public TableContent(JSONObject json) {
        this.fromJSON(json);
    }

    private void init(String tableId, List<Row> rows) {
        this.tableId = tableId;
        this.rows = rows != null ? rows : new ArrayList<Row>();
    }

    public String getTableId() {
        return this.tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public void setRows(List<Row> rows) {
        this.rows = rows;
    }

    public String toString() {
        return "TableContent of " + this.tableId + " lines count : " + this.getRows().size();
    }

    @Override
    public JSONObject toJSON() {
        JSONObject result = new JSONObject();
        result.put("class", "TableContent");
        result.put("table-id", this.tableId);
        result.put("rows", JSONConverter.getJSON(this.rows));
        return result;
    }

    @Override
    public void fromJSON(JSONObject json) {
        this.tableId = JSONConverter.getParameterFromJSON(json, "table-id", String.class);
        JSONArray jsonRows = JSONConverter.getParameterFromJSON(json, "rows", JSONArray.class);
        if (jsonRows != null) {
            this.rows = new ArrayList<Row>();
            for (Object o : jsonRows) {
                this.rows.add(new Row(JSONConverter.getObjectFromJSON(o, JSONObject.class)));
            }
        }
    }
}

