/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.io.JSONAble;
import org.openconcerto.utils.io.JSONConverter;

public class RowSpec
implements Externalizable,
JSONAble {
    private String tableId;
    private String[] columnIds;

    public RowSpec() {
    }

    public RowSpec(JSONObject json) {
        this.fromJSON(json);
    }

    public RowSpec(String tableId, String[] columnIds) {
        this.tableId = tableId;
        this.columnIds = columnIds;
    }

    public String[] getIds() {
        return this.columnIds;
    }

    public void setIds(String[] columnIds) {
        this.columnIds = columnIds;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getTableId() {
        return this.tableId;
    }

    public String toString() {
        String r = "RowSpec:" + this.tableId + " : ";
        int i = 0;
        while (i < this.columnIds.length) {
            r = i < this.columnIds.length - 1 ? String.valueOf(r) + this.columnIds[i] + ", " : String.valueOf(r) + this.columnIds[i];
            ++i;
        }
        return r;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            out.writeUTF(this.tableId);
            out.writeObject(this.columnIds);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.tableId = in.readUTF();
        this.columnIds = (String[])in.readObject();
    }

    @Override
    public JSONObject toJSON() {
        JSONObject result = new JSONObject();
        result.put("class", "RowSpec");
        result.put("table-id", this.tableId);
        result.put("column-ids", this.columnIds);
        return result;
    }

    @Override
    public void fromJSON(JSONObject json) {
        this.tableId = JSONConverter.getParameterFromJSON(json, "table-id", String.class);
        JSONArray jsonColumnIds = (JSONArray)json.get("column-ids");
        if (jsonColumnIds != null) {
            try {
                this.columnIds = new String[jsonColumnIds.size()];
                this.columnIds = CollectionUtils.castList(jsonColumnIds, String.class).toArray(this.columnIds);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("invalid value for 'possible-column-ids', List<String> expected");
            }
        }
        if (!json.containsKey("table-id") || json.get("table-id") instanceof String) {
            throw new IllegalArgumentException("value for 'value-type' not found or invalid");
        }
        if (!json.containsKey("column-ids") || json.get("column-ids") instanceof JSONArray) {
            throw new IllegalArgumentException("value for 'value-type' not found or invalid");
        }
        this.tableId = (String)json.get("table-id");
        int columnCount = jsonColumnIds.size();
        this.columnIds = new String[columnCount];
        int i = 0;
        while (i < columnCount) {
            Object jsonColumnId = jsonColumnIds.get(i);
            if (!(jsonColumnId instanceof String)) {
                throw new IllegalArgumentException("one or more column Ids are invalid in 'column-ids'");
            }
            this.columnIds[i] = (String)jsonColumnId;
            ++i;
        }
    }
}

