/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.io.JSONAble;
import org.openconcerto.utils.io.JSONConverter;

public class RowSelectionSpec
implements Externalizable,
JSONAble {
    private String tableId;
    private List<Long> ids;

    public RowSelectionSpec() {
    }

    public RowSelectionSpec(JSONObject json) {
        this.fromJSON(json);
    }

    public RowSelectionSpec(String tableId, List<Long> ids) {
        this.init(tableId, ids);
    }

    public RowSelectionSpec(String tableId) {
        this.init(tableId, null);
    }

    private void init(String tableId, List<Long> ids) {
        this.tableId = tableId;
        this.ids = ids != null ? ids : new ArrayList<Long>();
    }

    public List<Long> getIds() {
        return this.ids;
    }

    public String getTableId() {
        return this.tableId;
    }

    public String toString() {
        StringBuilder r = new StringBuilder("RowSelectionSpec: ").append(this.tableId).append(" : ");
        int idsSize = this.ids.size();
        int i = 0;
        while (i < idsSize) {
            if (i < idsSize - 1) {
                r.append(this.ids.get(i)).append(", ");
            } else {
                r.append(this.ids.get(i));
            }
            ++i;
        }
        return r.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            out.writeUTF(this.tableId);
            out.writeObject(this.ids);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.tableId = in.readUTF();
        this.ids = CollectionUtils.castList((List)in.readObject(), Long.class);
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("class", "RowSelectionSpec");
        json.put("table-id", this.tableId);
        json.put("ids", this.ids);
        return json;
    }

    @Override
    public void fromJSON(JSONObject json) {
        this.tableId = JSONConverter.getParameterFromJSON(json, "table-id", String.class);
        JSONArray jsonIds = JSONConverter.getParameterFromJSON(json, "ids", JSONArray.class);
        this.ids = new ArrayList<Long>();
        for (Object jsonId : jsonIds) {
            this.ids.add(JSONConverter.getObjectFromJSON(jsonId, Long.class));
        }
    }

    public void setTableId(String id) {
        this.tableId = id;
    }
}

