/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.JSONToLightUIConvertorManager;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.io.JSONAble;
import org.openconcerto.utils.io.JSONConverter;
import org.openconcerto.utils.ui.StringWithId;

public class Row
implements Externalizable,
JSONAble {
    private long id;
    private String extendId;
    private List<Object> values;
    private Boolean fillWidth = false;
    private Boolean toggleable = false;
    private Boolean visible = true;

    public Row() {
    }

    public Row(JSONObject json) {
        this.fromJSON(json);
    }

    public Row(long id, int valueCount) {
        this.id = id;
        this.values = new ArrayList<Object>();
        if (valueCount > 0) {
            int i = 0;
            while (i < valueCount) {
                this.values.add(null);
                ++i;
            }
        }
    }

    public Row(long id) {
        this.id = id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setValues(List<Object> values) {
        this.values = values;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public long getId() {
        return this.id;
    }

    public String getExtendId() {
        return this.extendId;
    }

    public void setExtendId(String extendId) {
        this.extendId = extendId;
    }

    public void addValue(Object v) {
        this.values.add(v);
    }

    public void setValue(int index, Object v) {
        this.values.set(index, v);
    }

    public Boolean isFillWidth() {
        return this.fillWidth;
    }

    public void setFillWidth(Boolean fillWidth) {
        this.fillWidth = fillWidth;
    }

    public Boolean isToggleable() {
        return this.toggleable;
    }

    public void setToggleable(Boolean toggleable) {
        this.toggleable = toggleable;
    }

    public Boolean isVisible() {
        return this.visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.id);
        out.writeUTF(this.extendId);
        out.writeObject(this.values);
        out.writeBoolean(this.fillWidth);
        out.writeBoolean(this.toggleable);
        out.writeBoolean(this.visible);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readLong();
        this.extendId = in.readUTF();
        this.values = CollectionUtils.castList((List)in.readObject(), Object.class);
        this.fillWidth = in.readBoolean();
        this.toggleable = in.readBoolean();
        this.visible = in.readBoolean();
    }

    @Override
    public JSONObject toJSON() {
        JSONObject result = new JSONObject();
        result.put("class", "Row");
        result.put("id", this.id);
        if (this.extendId != null) {
            result.put("extend-id", this.extendId);
        }
        if (!this.values.isEmpty()) {
            result.put("values", JSONConverter.getJSON(this.values));
        }
        if (this.fillWidth.booleanValue()) {
            result.put("fill-width", true);
        }
        if (this.toggleable.booleanValue()) {
            result.put("toggleable", true);
        }
        if (!this.visible.booleanValue()) {
            result.put("visible", false);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void fromJSON(JSONObject json) {
        this.id = JSONConverter.getParameterFromJSON(json, "id", Long.class);
        this.extendId = JSONConverter.getParameterFromJSON(json, "extend-id", String.class);
        this.fillWidth = JSONConverter.getParameterFromJSON(json, "fill-width", Boolean.class, false);
        this.toggleable = JSONConverter.getParameterFromJSON(json, "toggleable", Boolean.class, false);
        this.visible = JSONConverter.getParameterFromJSON(json, "visible", Boolean.class, true);
        JSONArray jsonValues = JSONConverter.getParameterFromJSON(json, "values", JSONArray.class);
        if (jsonValues == null) return;
        int valuesSize = jsonValues.size();
        this.values = new ArrayList<Object>(valuesSize);
        int i = 0;
        while (i < valuesSize) {
            void var5_5;
            Object e = jsonValues.get(i);
            if (e instanceof JSONObject) {
                JSONObject jsonValue = (JSONObject)e;
                String valueClassName = JSONConverter.getParameterFromJSON(jsonValue, "class", String.class);
                if (valueClassName == null) {
                    throw new IllegalArgumentException("null value store in ghost");
                }
                if (valueClassName.equals(StringWithId.class.getSimpleName())) {
                    StringWithId stringWithId = new StringWithId(jsonValue);
                } else {
                    if (!valueClassName.equals(LightUIElement.class.getSimpleName())) throw new IllegalArgumentException("invalid value for 'values', StringWithId or LightUIElement expected");
                    LightUIElement lightUIElement = JSONToLightUIConvertorManager.getInstance().createUIElementFromJSON(jsonValue);
                }
            } else if (e instanceof String) {
                String string = JSONConverter.getObjectFromJSON(e, String.class);
            } else if (e instanceof Integer) {
                Integer n = JSONConverter.getObjectFromJSON(e, Integer.class);
            } else if (e instanceof Long) {
                Long l = JSONConverter.getObjectFromJSON(e, Long.class);
            } else if (e instanceof Boolean) {
                Boolean bl = JSONConverter.getObjectFromJSON(e, Boolean.class);
            } else if (e != null) {
                throw new IllegalArgumentException("unknow type: " + e.getClass().getName());
            }
            this.values.add(var5_5);
            ++i;
        }
    }

    public String toString() {
        return "Row id: " + this.id + " values: " + this.values;
    }
}

