/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.IUserControl;
import org.openconcerto.ui.light.InvalidClassException;
import org.openconcerto.ui.light.JSONToLightUIConvertor;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.utils.io.JSONConverter;

public class LightUITextArea
extends LightUIElement
implements IUserControl {
    private int nbLine = 4;

    public LightUITextArea(String id) {
        super(id);
        this.setType(27);
        this.setValueType(0);
    }

    public LightUITextArea(JSONObject json) {
        super(json);
    }

    public LightUITextArea(LightUITextArea text) {
        super(text);
    }

    public void setNbLine(int nbLine) {
        this.nbLine = nbLine;
    }

    public int getNbLine() {
        return this.nbLine;
    }

    @Override
    public JSONToLightUIConvertor getConvertor() {
        return new JSONToLightUIConvertor(){

            @Override
            public LightUIElement convert(JSONObject json) {
                return new LightUITextArea(json);
            }
        };
    }

    @Override
    public LightUIElement clone() {
        return new LightUITextArea(this);
    }

    @Override
    protected void copy(LightUIElement element) {
        super.copy(element);
        if (!(element instanceof LightUITextArea)) {
            throw new InvalidClassException(this.getClassName(), element.getClassName(), element.getId());
        }
        LightUITextArea text = (LightUITextArea)element;
        this.nbLine = text.nbLine;
    }

    @Override
    public void setValueFromContext(Object value) {
        this.setValue(JSONConverter.getObjectFromJSON(value, String.class));
    }

    @Override
    public Object getValueFromContext() {
        return this.getValue();
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        json.put("nbline", this.nbLine);
        return json;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        Integer jsonValues = JSONConverter.getParameterFromJSON(json, "nbline", Integer.class);
        this.nbLine = jsonValues;
    }
}

